%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Application Note AN005
% Parameters for the 'Back-to-back three-phase grid-tied converter with LCL filter'
% Copyright imperix ltd, 2020
% dev@imperix.ch
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Created in March 2020 by imperix ltd
% Revised in October 2020 by imperix ltd

%% SYSTEM PARAMETERS
SwitchingFreq = 20e3;           % Switching frequency [Hz]
Deadtime = 700e-9;              % Deadtime [s]
ControlFreq = SwitchingFreq;    % Control frequency [Hz]
ControlPeriod = 1/ControlFreq;  % Control period [s]
SamplingFreq = ControlFreq;     % Sampling frequency [Hz]
SamplingPeriod = ControlPeriod; % Sampling period [s]
SamplingPhase = 0.0;            % Sampling phase [-]

%% PLANT PARAMETERS

Cdc_module = 260e-6;  % DC bus capacitance of one module [F]
Cdc = 6*Cdc_module;   % Capacitance of the whole bus [F]
Vdc0 = 725;           % Initial bus voltage [V]
L1 = 2.5e-3;          % LCL filter inductance (grid side) [Ohm]
R1 = 22e-3;           % Internal resistance of L1 [Ohm]
L2 = 2.5e-3;          % LCL filter inductance (converter side) [Ohm]
R2 = 22e-3;           % Internal resistance of L2 [Ohm]
Cf = 3e-6;            % LCL filter capacitance [F]
Rf = 1;               % Series resitor of Cf [Ohm]
Vg = 230;             % Grid voltage (line to neutral) [V]
GridFreq = 50;        % Grid frequency [Hz]
Lg = 0.1e-3;          % Grid inductance [H]
Lload = 4.5e-3;       % Load inductance [H]
Rload = 15;           % Load resistance [Ohm]
LoadFreq = 60;        % Frequency of the load currents [Hz]

%% Grid side control

% DC bus voltage
tr_Vdc = 15e-3;                 % Response time of the DC bus controller [s]
ksi_Vdc = 1;                    % Damping of DC bus controller
w0_Vdc = 4.744/tr_Vdc;          % Controller bandwidth [rad/s]
KiVdc = w0_Vdc^2*Cdc;           % Integral gain
KpVdc = 2*ksi_Vdc/w0_Vdc*KiVdc; % Proportional gain

% Grid current
KpIg = 10;                      % Proportional gain
KrIg = 500;                     % Resonant gain

% Active damping
wad = 0.13*2*pi*SamplingFreq;   % Active damping pulsation [rad/s]
Kad = wad*L2;                   % Active damping gain

%% Load side control
tr_load = 2e-3;                 % Response time of load current controller [s]
ksi_load = 1;                   % Damping of load controller
w0_Il = 4.744/tr_load;          % Controller bandwidth [rad/s]
KiIl = w0_Il^2*Lload;           % Integral gain
KpIl = 2*ksi_load/w0_Il*KiIl;   % Proportional gain