%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Product Note PN172
% Parameters for the 'Modular Multilevel Converter (MMC) SSPWM openLoop' system
% Copyright imperix ltd, 2024
% dev@imperix.ch
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clc; close all;

%% Time parameters:
fs = 20e3;                      % Interrupt frequency [Hz]
Ts = 1/fs;                      % Interrupt period [s]

%% Bus-side parameters :
Vdc = 200;                      % Bus EMF (V)

%% Three-phase-side parameters :
Vac = 230;
Vac_pk = 325;                   % Nominal peak AC amplitude (source EMF) (V)
f = 50;                         % Line frequency (Hz)
w = 2*pi*f; 

%% Submodules parameters :
N = 4;                          % Number of submodules per arm
Csm = 5.0e-3;                   % Submodule capacitance (F)
Rsm = 50e-3;                    % Submodule capacitor ESR (ohm)

%% Branch parameters :
Rb = 60e-3;                     % Parasitic branch resistance (constant part, ohm)
Lb = 2.3e-3;                    % Branch indu ctance (self part, H)

%% Load parameters
Rg = 8.5;

%% Simulation
Vsm0 = Vdc/N;
DT   = 1e-6;
