library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity ix_axis_to_reg is
  generic (
    G_AXIS_WIDTH : integer := 32;
    G_REG_WIDTH  : integer := 16
  );
  port (
    clk_250_mhz : in std_logic;
    S_AXIS_tdata  : in  std_logic_vector(G_AXIS_WIDTH-1 downto 0);
    S_AXIS_tvalid : in  std_logic;
    S_AXIS_tready : out std_logic;
    o_data : out std_logic_vector(G_REG_WIDTH-1 downto 0)
  );
end ix_axis_to_reg;

architecture impl of ix_axis_to_reg is
  ATTRIBUTE X_INTERFACE_INFO : STRING;
  ATTRIBUTE X_INTERFACE_PARAMETER : STRING;
  
  ATTRIBUTE X_INTERFACE_INFO of clk_250_mhz : SIGNAL is "xilinx.com:signal:clock:1.0 clk_250_mhz CLK";
  ATTRIBUTE X_INTERFACE_PARAMETER of clk_250_mhz : SIGNAL is "ASSOCIATED_BUSIF S_AXIS, FREQ_HZ 250000000";
  
  ATTRIBUTE X_INTERFACE_INFO of S_AXIS_tdata  : SIGNAL is "xilinx.com:interface:axis:1.0 S_AXIS TDATA";
  ATTRIBUTE X_INTERFACE_INFO of S_AXIS_tvalid : SIGNAL is "xilinx.com:interface:axis:1.0 S_AXIS TVALID";
  ATTRIBUTE X_INTERFACE_INFO of S_AXIS_tready : SIGNAL is "xilinx.com:interface:axis:1.0 S_AXIS TREADY";
  
  signal reg_data : std_logic_vector(G_REG_WIDTH-1 downto 0) := (others => '0');
  
begin
  
  S_AXIS_tready <= '1';
  
  process(clk_250_mhz)
  begin
    if rising_edge(clk_250_mhz) then
      if S_AXIS_tvalid = '1' then
        reg_data <= S_AXIS_tdata(G_REG_WIDTH-1 downto 0);
      end if;
    end if;
  end process;
  
  o_data <= reg_data;
  
end impl;