library IEEE;
use IEEE.STD_LOGIC_1164.all;

entity ixip is
  generic (
    SB_GT_SFP_0            : boolean := false;
    SB_GT_SFP_1            : boolean := false;
    SB_GT_SFP_2            : boolean := false;
    Remove_CB_PWM_0_to_7   : boolean := true;
    Remove_CB_PWM_8_to_15  : boolean := true;
    Remove_CB_PWM_16_to_23 : boolean := true;
    Remove_CB_PWM_24_to_31 : boolean := true;
    Remove_PP_PWM          : boolean := true;
    Remove_SS_PWM          : boolean := true);
  port (
    clk_50_mhz             : out std_logic;
    clk_250_mhz            : out std_logic;
    ADC_reg_00             : out std_logic_vector (15 downto 0);
    ADC_reg_01             : out std_logic_vector (15 downto 0);
    ADC_reg_02             : out std_logic_vector (15 downto 0);
    ADC_reg_03             : out std_logic_vector (15 downto 0);
    ADC_reg_04             : out std_logic_vector (15 downto 0);
    ADC_reg_05             : out std_logic_vector (15 downto 0);
    ADC_reg_06             : out std_logic_vector (15 downto 0);
    ADC_reg_07             : out std_logic_vector (15 downto 0);
    ADC_reg_08             : out std_logic_vector (15 downto 0);
    ADC_reg_09             : out std_logic_vector (15 downto 0);
    ADC_reg_10             : out std_logic_vector (15 downto 0);
    ADC_reg_11             : out std_logic_vector (15 downto 0);
    ADC_reg_12             : out std_logic_vector (15 downto 0);
    ADC_reg_13             : out std_logic_vector (15 downto 0);
    ADC_reg_14             : out std_logic_vector (15 downto 0);
    ADC_reg_15             : out std_logic_vector (15 downto 0);
    data_valid_pulse       : out std_logic;
    sync_pulse             : out std_logic;
    pwm                    : out std_logic_vector (31 downto 0);
    gpo                    : out std_logic_vector (15 downto 0);
    BBOX_tri_o             : out std_logic_vector (51 downto 0);
    BBOX_tri_t             : out std_logic_vector (51 downto 0);
    cpu_core_state         : out std_logic_vector (1 downto 0);
    fault                  : out std_logic;
    rxn_0                  : out std_logic;
    rxp_0                  : out std_logic;
    rxn_1                  : out std_logic;
    rxp_1                  : out std_logic;
    rxn_2                  : out std_logic;
    rxp_2                  : out std_logic;
    private_out            : out std_logic_vector (35 downto 0);
    adc_done_cpu_pulse     : out std_logic;
    adc_done_pulse         : out std_logic;
    sampling_pulse         : out std_logic;
    GT_gt0_qplllock        : out std_logic;
    GT_gt0_qpllrefclklost  : out std_logic;
    GT_gt_qpllclk_quad1    : out std_logic;
    GT_gt_qpllrefclk_quad1 : out std_logic;
    GT_gt_refclk1          : out std_logic;
    USR_tri_o              : out std_logic_vector (35 downto 0);
    USR_tri_t              : out std_logic_vector (35 downto 0);
    CLOCK_0_clk_en         : out std_logic;
    CLOCK_0_period         : out std_logic_vector (15 downto 0);
    CLOCK_0_prescaler      : out std_logic_vector (15 downto 0);
    CLOCK_0_timer          : out std_logic_vector (15 downto 0);
    CLOCK_1_clk_en         : out std_logic;
    CLOCK_1_period         : out std_logic_vector (15 downto 0);
    CLOCK_1_prescaler      : out std_logic_vector (15 downto 0);
    CLOCK_1_timer          : out std_logic_vector (15 downto 0);
    CLOCK_2_clk_en         : out std_logic;
    CLOCK_2_period         : out std_logic_vector (15 downto 0);
    CLOCK_2_prescaler      : out std_logic_vector (15 downto 0);
    CLOCK_2_timer          : out std_logic_vector (15 downto 0);
    CLOCK_3_clk_en         : out std_logic;
    CLOCK_3_period         : out std_logic_vector (15 downto 0);
    CLOCK_3_prescaler      : out std_logic_vector (15 downto 0);
    CLOCK_3_timer          : out std_logic_vector (15 downto 0);
    reading                : out std_logic;
    SBIO_BUS_sb_addr       : out std_logic_vector (9 downto 0);
    SBIO_BUS_sb_we         : out std_logic;
    SBIO_BUS_sb_wdata      : out std_logic_vector (15 downto 0);
    BSCAN_bscanid_en       : out std_logic;
    BSCAN_capture          : out std_logic;
    BSCAN_drck             : out std_logic;
    BSCAN_reset            : out std_logic;
    BSCAN_runtest          : out std_logic;
    BSCAN_sel              : out std_logic;
    BSCAN_shift            : out std_logic;
    BSCAN_tck              : out std_logic;
    BSCAN_tdi              : out std_logic;
    BSCAN_tms              : out std_logic;
    BSCAN_update           : out std_logic;
    FIXED_IO_mio           : inout std_logic_vector (53 downto 0);
    DDR_cas_n              : inout std_logic;
    DDR_cke                : inout std_logic;
    DDR_ck_n               : inout std_logic;
    DDR_ck_p               : inout std_logic;
    DDR_cs_n               : inout std_logic;
    DDR_reset_n            : inout std_logic;
    DDR_odt                : inout std_logic;
    DDR_ras_n              : inout std_logic;
    DDR_we_n               : inout std_logic;
    DDR_ba                 : inout std_logic_vector (2 downto 0);
    DDR_addr               : inout std_logic_vector (14 downto 0);
    FIXED_IO_ddr_vrn       : inout std_logic;
    FIXED_IO_ddr_vrp       : inout std_logic;
    DDR_dm                 : inout std_logic_vector (3 downto 0);
    DDR_dq                 : inout std_logic_vector (31 downto 0);
    DDR_dqs_n              : inout std_logic_vector (3 downto 0);
    DDR_dqs_p              : inout std_logic_vector (3 downto 0);
    FIXED_IO_ps_srstb      : inout std_logic;
    FIXED_IO_ps_clk        : inout std_logic;
    FIXED_IO_ps_porb       : inout std_logic;
    flt                    : in std_logic_vector (15 downto 0);
    gpi                    : in std_logic_vector (15 downto 0);
    BBOX_tri_i             : in std_logic_vector (51 downto 0);
    private_in             : in std_logic_vector (30 downto 0);
    txn_0                  : in std_logic;
    txp_0                  : in std_logic;
    txn_1                  : in std_logic;
    txp_1                  : in std_logic;
    txn_2                  : in std_logic;
    txp_2                  : in std_logic;
    USR_tri_i              : in std_logic_vector (35 downto 0);
    sb_pwm                 : in std_logic_vector (31 downto 0);
    user_fw_id             : in std_logic_vector (15 downto 0);
    SBIO_BUS_sb_rdata      : in std_logic_vector (15 downto 0);
    BSCAN_tdo              : in std_logic
  );

end ixip;

architecture stub of ixip is

  attribute X_INTERFACE_INFO                          : string;
  attribute X_INTERFACE_INFO of DDR_cas_n             : signal is "xilinx.com:interface:ddrx:1.0 DDR CAS_N";
  attribute X_INTERFACE_INFO of DDR_ck_n              : signal is "xilinx.com:interface:ddrx:1.0 DDR CK_N";
  attribute X_INTERFACE_INFO of DDR_ck_p              : signal is "xilinx.com:interface:ddrx:1.0 DDR CK_P";
  attribute X_INTERFACE_INFO of DDR_cke               : signal is "xilinx.com:interface:ddrx:1.0 DDR CKE";
  attribute X_INTERFACE_INFO of DDR_cs_n              : signal is "xilinx.com:interface:ddrx:1.0 DDR CS_N";
  attribute X_INTERFACE_INFO of DDR_odt               : signal is "xilinx.com:interface:ddrx:1.0 DDR ODT";
  attribute X_INTERFACE_INFO of DDR_ras_n             : signal is "xilinx.com:interface:ddrx:1.0 DDR RAS_N";
  attribute X_INTERFACE_INFO of DDR_reset_n           : signal is "xilinx.com:interface:ddrx:1.0 DDR RESET_N";
  attribute X_INTERFACE_INFO of DDR_we_n              : signal is "xilinx.com:interface:ddrx:1.0 DDR WE_N";
  attribute X_INTERFACE_INFO of FIXED_IO_ddr_vrn      : signal is "xilinx.com:display_processing_system7:fixedio:1.0 FIXED_IO DDR_VRN";
  attribute X_INTERFACE_PARAMETER                     : string;
  attribute X_INTERFACE_PARAMETER of FIXED_IO_ddr_vrn : signal is "XIL_INTERFACENAME FIXED_IO, CAN_DEBUG false";
  attribute X_INTERFACE_INFO of FIXED_IO_ddr_vrp      : signal is "xilinx.com:display_processing_system7:fixedio:1.0 FIXED_IO DDR_VRP";
  attribute X_INTERFACE_INFO of FIXED_IO_ps_clk       : signal is "xilinx.com:display_processing_system7:fixedio:1.0 FIXED_IO PS_CLK";
  attribute X_INTERFACE_INFO of FIXED_IO_ps_porb      : signal is "xilinx.com:display_processing_system7:fixedio:1.0 FIXED_IO PS_PORB";
  attribute X_INTERFACE_INFO of FIXED_IO_ps_srstb     : signal is "xilinx.com:display_processing_system7:fixedio:1.0 FIXED_IO PS_SRSTB";
  attribute X_INTERFACE_INFO of DDR_addr              : signal is "xilinx.com:interface:ddrx:1.0 DDR ADDR";
  attribute X_INTERFACE_PARAMETER of DDR_addr         : signal is "XIL_INTERFACENAME DDR, AXI_ARBITRATION_SCHEME TDM, BURST_LENGTH 8, CAN_DEBUG false, CAS_LATENCY 11, CAS_WRITE_LATENCY 11, CS_ENABLED true, DATA_MASK_ENABLED true, DATA_WIDTH 8, MEMORY_TYPE COMPONENTS, MEM_ADDR_MAP ROW_COLUMN_BANK, SLOT Single, TIMEPERIOD_PS 1250";
  attribute X_INTERFACE_INFO of DDR_ba                : signal is "xilinx.com:interface:ddrx:1.0 DDR BA";
  attribute X_INTERFACE_INFO of DDR_dm                : signal is "xilinx.com:interface:ddrx:1.0 DDR DM";
  attribute X_INTERFACE_INFO of DDR_dq                : signal is "xilinx.com:interface:ddrx:1.0 DDR DQ";
  attribute X_INTERFACE_INFO of DDR_dqs_n             : signal is "xilinx.com:interface:ddrx:1.0 DDR DQS_N";
  attribute X_INTERFACE_INFO of DDR_dqs_p             : signal is "xilinx.com:interface:ddrx:1.0 DDR DQS_P";
  attribute X_INTERFACE_INFO of FIXED_IO_mio          : signal is "xilinx.com:display_processing_system7:fixedio:1.0 FIXED_IO MIO";
  attribute X_INTERFACE_INFO of USR_tri_i             : signal is "xilinx.com:interface:gpio:1.0 USR TRI_I";
  attribute X_INTERFACE_INFO of USR_tri_o             : signal is "xilinx.com:interface:gpio:1.0 USR TRI_O";
  attribute X_INTERFACE_INFO of USR_tri_t             : signal is "xilinx.com:interface:gpio:1.0 USR TRI_T";
  attribute X_INTERFACE_INFO of CLOCK_0_clk_en        : signal is "imperix.ch:ix:clock_gen:1.0 CLOCK_0 clk_en";
  attribute X_INTERFACE_INFO of CLOCK_0_period        : signal is "imperix.ch:ix:clock_gen:1.0 CLOCK_0 period";
  attribute X_INTERFACE_INFO of CLOCK_0_prescaler     : signal is "imperix.ch:ix:clock_gen:1.0 CLOCK_0 prescaler";
  attribute X_INTERFACE_INFO of CLOCK_0_timer         : signal is "imperix.ch:ix:clock_gen:1.0 CLOCK_0 timer";
  attribute X_INTERFACE_INFO of CLOCK_1_clk_en        : signal is "imperix.ch:ix:clock_gen:1.0 CLOCK_1 clk_en";
  attribute X_INTERFACE_INFO of CLOCK_1_period        : signal is "imperix.ch:ix:clock_gen:1.0 CLOCK_1 period";
  attribute X_INTERFACE_INFO of CLOCK_1_prescaler     : signal is "imperix.ch:ix:clock_gen:1.0 CLOCK_1 prescaler";
  attribute X_INTERFACE_INFO of CLOCK_1_timer         : signal is "imperix.ch:ix:clock_gen:1.0 CLOCK_1 timer";
  attribute X_INTERFACE_INFO of CLOCK_2_clk_en        : signal is "imperix.ch:ix:clock_gen:1.0 CLOCK_2 clk_en";
  attribute X_INTERFACE_INFO of CLOCK_2_period        : signal is "imperix.ch:ix:clock_gen:1.0 CLOCK_2 period";
  attribute X_INTERFACE_INFO of CLOCK_2_prescaler     : signal is "imperix.ch:ix:clock_gen:1.0 CLOCK_2 prescaler";
  attribute X_INTERFACE_INFO of CLOCK_2_timer         : signal is "imperix.ch:ix:clock_gen:1.0 CLOCK_2 timer";
  attribute X_INTERFACE_INFO of CLOCK_3_clk_en        : signal is "imperix.ch:ix:clock_gen:1.0 CLOCK_3 clk_en";
  attribute X_INTERFACE_INFO of CLOCK_3_period        : signal is "imperix.ch:ix:clock_gen:1.0 CLOCK_3 period";
  attribute X_INTERFACE_INFO of CLOCK_3_prescaler     : signal is "imperix.ch:ix:clock_gen:1.0 CLOCK_3 prescaler";
  attribute X_INTERFACE_INFO of CLOCK_3_timer         : signal is "imperix.ch:ix:clock_gen:1.0 CLOCK_3 timer";
  attribute X_INTERFACE_INFO of BSCAN_bscanid_en      : signal is "xilinx.com:interface:bscan:1.0 BSCAN BSCANID_EN";
  attribute X_INTERFACE_PARAMETER of BSCAN_bscanid_en : signal is "XIL_INTERFACENAME BSCAN, MODE Master";
  attribute X_INTERFACE_INFO of BSCAN_capture         : signal is "xilinx.com:interface:bscan:1.0 BSCAN CAPTURE";
  attribute X_INTERFACE_INFO of BSCAN_drck            : signal is "xilinx.com:interface:bscan:1.0 BSCAN DRCK";
  attribute X_INTERFACE_INFO of BSCAN_reset           : signal is "xilinx.com:interface:bscan:1.0 BSCAN RESET";
  attribute X_INTERFACE_INFO of BSCAN_runtest         : signal is "xilinx.com:interface:bscan:1.0 BSCAN RUNTEST";
  attribute X_INTERFACE_INFO of BSCAN_sel             : signal is "xilinx.com:interface:bscan:1.0 BSCAN SEL";
  attribute X_INTERFACE_INFO of BSCAN_shift           : signal is "xilinx.com:interface:bscan:1.0 BSCAN SHIFT";
  attribute X_INTERFACE_INFO of BSCAN_tck             : signal is "xilinx.com:interface:bscan:1.0 BSCAN TCK";
  attribute X_INTERFACE_INFO of BSCAN_tdi             : signal is "xilinx.com:interface:bscan:1.0 BSCAN TDI";
  attribute X_INTERFACE_INFO of BSCAN_tms             : signal is "xilinx.com:interface:bscan:1.0 BSCAN TMS";
  attribute X_INTERFACE_INFO of BSCAN_update          : signal is "xilinx.com:interface:bscan:1.0 BSCAN UPDATE";
  attribute X_INTERFACE_INFO of BSCAN_tdo             : signal is "xilinx.com:interface:bscan:1.0 BSCAN TDO";

  component ip_imp_OWDWE0 is
    port (
      clk_50_mhz             : out std_logic;
      clk_250_mhz            : out std_logic;
      ADC_reg_00             : out std_logic_vector (15 downto 0);
      ADC_reg_01             : out std_logic_vector (15 downto 0);
      ADC_reg_02             : out std_logic_vector (15 downto 0);
      ADC_reg_03             : out std_logic_vector (15 downto 0);
      ADC_reg_04             : out std_logic_vector (15 downto 0);
      ADC_reg_05             : out std_logic_vector (15 downto 0);
      ADC_reg_06             : out std_logic_vector (15 downto 0);
      ADC_reg_07             : out std_logic_vector (15 downto 0);
      ADC_reg_08             : out std_logic_vector (15 downto 0);
      ADC_reg_09             : out std_logic_vector (15 downto 0);
      ADC_reg_10             : out std_logic_vector (15 downto 0);
      ADC_reg_11             : out std_logic_vector (15 downto 0);
      ADC_reg_12             : out std_logic_vector (15 downto 0);
      ADC_reg_13             : out std_logic_vector (15 downto 0);
      ADC_reg_14             : out std_logic_vector (15 downto 0);
      ADC_reg_15             : out std_logic_vector (15 downto 0);
      data_valid_pulse       : out std_logic;
      sync_pulse             : out std_logic;
      pwm                    : out std_logic_vector (31 downto 0);
      gpo                    : out std_logic_vector (15 downto 0);
      oversampling_pulse     : out std_logic;
      BBOX_tri_o             : out std_logic_vector (51 downto 0);
      BBOX_tri_t             : out std_logic_vector (51 downto 0);
      cpu_core_state         : out std_logic_vector (1 downto 0);
      fault                  : out std_logic;
      private_out            : out std_logic_vector (35 downto 0);
      adc_done_cpu_pulse     : out std_logic;
      adc_done_pulse         : out std_logic;
      sampling_pulse         : out std_logic;
      GT_gt0_qplllock        : out std_logic;
      GT_gt0_qpllrefclklost  : out std_logic;
      GT_gt_qpllclk_quad1    : out std_logic;
      GT_gt_qpllrefclk_quad1 : out std_logic;
      GT_gt_refclk1          : out std_logic;
      USR_tri_o              : out std_logic_vector (35 downto 0);
      USR_tri_t              : out std_logic_vector (35 downto 0);
      CLOCK_0_clk_en         : out std_logic;
      CLOCK_0_period         : out std_logic_vector (15 downto 0);
      CLOCK_0_prescaler      : out std_logic_vector (15 downto 0);
      CLOCK_0_timer          : out std_logic_vector (15 downto 0);
      CLOCK_1_clk_en         : out std_logic;
      CLOCK_1_period         : out std_logic_vector (15 downto 0);
      CLOCK_1_prescaler      : out std_logic_vector (15 downto 0);
      CLOCK_1_timer          : out std_logic_vector (15 downto 0);
      CLOCK_2_clk_en         : out std_logic;
      CLOCK_2_period         : out std_logic_vector (15 downto 0);
      CLOCK_2_prescaler      : out std_logic_vector (15 downto 0);
      CLOCK_2_timer          : out std_logic_vector (15 downto 0);
      CLOCK_3_clk_en         : out std_logic;
      CLOCK_3_period         : out std_logic_vector (15 downto 0);
      CLOCK_3_prescaler      : out std_logic_vector (15 downto 0);
      CLOCK_3_timer          : out std_logic_vector (15 downto 0);
      reading                : out std_logic;
      SBIO_BUS_sb_addr       : out std_logic_vector (9 downto 0);
      SBIO_BUS_sb_we         : out std_logic;
      SBIO_BUS_sb_wdata      : out std_logic_vector (15 downto 0);
      m0_bscan_bscanid_en    : out std_logic;
      m0_bscan_capture       : out std_logic;
      m0_bscan_drck          : out std_logic;
      m0_bscan_reset         : out std_logic;
      m0_bscan_runtest       : out std_logic;
      m0_bscan_sel           : out std_logic;
      m0_bscan_shift         : out std_logic;
      m0_bscan_tck           : out std_logic;
      m0_bscan_tdi           : out std_logic;
      m0_bscan_tms           : out std_logic;
      m0_bscan_update        : out std_logic;
      FIXED_IO_mio           : inout std_logic_vector (53 downto 0);
      DDR_cas_n              : inout std_logic;
      DDR_cke                : inout std_logic;
      DDR_ck_n               : inout std_logic;
      DDR_ck_p               : inout std_logic;
      DDR_cs_n               : inout std_logic;
      DDR_reset_n            : inout std_logic;
      DDR_odt                : inout std_logic;
      DDR_ras_n              : inout std_logic;
      DDR_we_n               : inout std_logic;
      DDR_ba                 : inout std_logic_vector (2 downto 0);
      DDR_addr               : inout std_logic_vector (14 downto 0);
      FIXED_IO_ddr_vrn       : inout std_logic;
      FIXED_IO_ddr_vrp       : inout std_logic;
      DDR_dm                 : inout std_logic_vector (3 downto 0);
      DDR_dq                 : inout std_logic_vector (31 downto 0);
      DDR_dqs_n              : inout std_logic_vector (3 downto 0);
      DDR_dqs_p              : inout std_logic_vector (3 downto 0);
      FIXED_IO_ps_srstb      : inout std_logic;
      FIXED_IO_ps_clk        : inout std_logic;
      FIXED_IO_ps_porb       : inout std_logic;
      flt                    : in std_logic_vector (15 downto 0);
      gpi                    : in std_logic_vector (15 downto 0);
      BBOX_tri_i             : in std_logic_vector (51 downto 0);
      private_in             : in std_logic_vector (30 downto 0);
      inst_aurora            : in std_logic_vector (2 downto 0);
      USR_tri_i              : in std_logic_vector (35 downto 0);
      sb_pwm                 : in std_logic_vector (31 downto 0);
      inst_cb_pwm            : in std_logic_vector (31 downto 0);
      inst_pp_pwm            : in std_logic;
      inst_ss_pwm            : in std_logic;
      user_fw_id             : in std_logic_vector (15 downto 0);
      SBIO_BUS_sb_rdata      : in std_logic_vector (15 downto 0);
      m0_bscan_tdo           : in std_logic
    );
  end component ip_imp_OWDWE0;

  signal inst_aurora : std_logic_vector(2 downto 0);
  signal inst_cb_pwm : std_logic_vector(31 downto 0);
  signal inst_ss_pwm : std_logic;
  signal inst_pp_pwm : std_logic;

  signal i_private_in  : std_logic_vector(30 downto 0);
  signal i_private_out : std_logic_vector(35 downto 0);

  signal RealSync_SFP_0 : boolean;
  signal RealSync_SFP_1 : boolean;
  signal RealSync_SFP_2 : boolean;

begin

  RealSync_SFP_0 <= not SB_GT_SFP_0;
  RealSync_SFP_1 <= not SB_GT_SFP_1;
  RealSync_SFP_2 <= not SB_GT_SFP_2;

  inst_aurora(0) <= '1' when RealSync_SFP_0 else
  '0';
  inst_aurora(1) <= '1' when RealSync_SFP_1 else
  '0';
  inst_aurora(2) <= '1' when RealSync_SFP_2 else
  '0';

  i_private_in(22 downto 0) <= private_in(22 downto 0);

  i_private_in(23) <= private_in(23) when RealSync_SFP_0 else
  '0';
  i_private_in(24) <= private_in(24) when RealSync_SFP_0 else
  '0';
  i_private_in(25) <= private_in(25) when RealSync_SFP_1 else
  '0';
  i_private_in(26) <= private_in(26) when RealSync_SFP_1 else
  '0';
  i_private_in(27) <= private_in(27) when RealSync_SFP_2 else
  '0';
  i_private_in(28) <= private_in(28) when RealSync_SFP_2 else
  '0';

  rxp_0 <= '0' when RealSync_SFP_0 else
    private_in(23);
  rxn_0 <= '0' when RealSync_SFP_0 else
    private_in(24);
  rxp_1 <= '0' when RealSync_SFP_1 else
    private_in(25);
  rxn_1 <= '0' when RealSync_SFP_1 else
    private_in(26);
  rxp_2 <= '0' when RealSync_SFP_2 else
    private_in(27);
  rxn_2 <= '0' when RealSync_SFP_2 else
    private_in(28);

  i_private_in(30 downto 29) <= private_in(30 downto 29);

  private_out(27 downto 0) <= i_private_out(27 downto 0);

  private_out(28) <= i_private_out(28) when RealSync_SFP_0 else
  txp_0;
  private_out(29) <= i_private_out(29) when RealSync_SFP_0 else
  txn_0;
  private_out(30) <= i_private_out(30) when RealSync_SFP_1 else
  txp_1;
  private_out(31) <= i_private_out(31) when RealSync_SFP_1 else
  txn_1;
  private_out(32) <= i_private_out(32) when RealSync_SFP_2 else
  txp_2;
  private_out(33) <= i_private_out(33) when RealSync_SFP_2 else
  txn_2;

  private_out(35 downto 34) <= i_private_out(35 downto 34);

  inst_cb_pwm(0) <= '1' when not Remove_CB_PWM_0_to_7 else
  '0';
  inst_cb_pwm(1) <= '1' when not Remove_CB_PWM_0_to_7 else
  '0';
  inst_cb_pwm(2) <= '1' when not Remove_CB_PWM_0_to_7 else
  '0';
  inst_cb_pwm(3) <= '1' when not Remove_CB_PWM_0_to_7 else
  '0';
  inst_cb_pwm(4) <= '1' when not Remove_CB_PWM_0_to_7 else
  '0';
  inst_cb_pwm(5) <= '1' when not Remove_CB_PWM_0_to_7 else
  '0';
  inst_cb_pwm(6) <= '1' when not Remove_CB_PWM_0_to_7 else
  '0';
  inst_cb_pwm(7) <= '1' when not Remove_CB_PWM_0_to_7 else
  '0';
  inst_cb_pwm(8) <= '1' when not Remove_CB_PWM_8_to_15 else
  '0';
  inst_cb_pwm(9) <= '1' when not Remove_CB_PWM_8_to_15 else
  '0';
  inst_cb_pwm(10) <= '1' when not Remove_CB_PWM_8_to_15 else
  '0';
  inst_cb_pwm(11) <= '1' when not Remove_CB_PWM_8_to_15 else
  '0';
  inst_cb_pwm(12) <= '1' when not Remove_CB_PWM_8_to_15 else
  '0';
  inst_cb_pwm(13) <= '1' when not Remove_CB_PWM_8_to_15 else
  '0';
  inst_cb_pwm(14) <= '1' when not Remove_CB_PWM_8_to_15 else
  '0';
  inst_cb_pwm(15) <= '1' when not Remove_CB_PWM_8_to_15 else
  '0';
  inst_cb_pwm(16) <= '1' when not Remove_CB_PWM_16_to_23 else
  '0';
  inst_cb_pwm(17) <= '1' when not Remove_CB_PWM_16_to_23 else
  '0';
  inst_cb_pwm(18) <= '1' when not Remove_CB_PWM_16_to_23 else
  '0';
  inst_cb_pwm(19) <= '1' when not Remove_CB_PWM_16_to_23 else
  '0';
  inst_cb_pwm(20) <= '1' when not Remove_CB_PWM_16_to_23 else
  '0';
  inst_cb_pwm(21) <= '1' when not Remove_CB_PWM_16_to_23 else
  '0';
  inst_cb_pwm(22) <= '1' when not Remove_CB_PWM_16_to_23 else
  '0';
  inst_cb_pwm(23) <= '1' when not Remove_CB_PWM_16_to_23 else
  '0';
  inst_cb_pwm(24) <= '1' when not Remove_CB_PWM_24_to_31 else
  '0';
  inst_cb_pwm(25) <= '1' when not Remove_CB_PWM_24_to_31 else
  '0';
  inst_cb_pwm(26) <= '1' when not Remove_CB_PWM_24_to_31 else
  '0';
  inst_cb_pwm(27) <= '1' when not Remove_CB_PWM_24_to_31 else
  '0';
  inst_cb_pwm(28) <= '1' when not Remove_CB_PWM_24_to_31 else
  '0';
  inst_cb_pwm(29) <= '1' when not Remove_CB_PWM_24_to_31 else
  '0';
  inst_cb_pwm(30) <= '1' when not Remove_CB_PWM_24_to_31 else
  '0';
  inst_cb_pwm(31) <= '1' when not Remove_CB_PWM_24_to_31 else
  '0';

  inst_ss_pwm <= '1' when not Remove_SS_PWM else
    '0';
  inst_pp_pwm <= '1' when not Remove_PP_PWM else
    '0';
  ip_inst : ip_imp_OWDWE0
  port map
  (
    clk_50_mhz             => clk_50_mhz,
    clk_250_mhz            => clk_250_mhz,
    ADC_reg_00             => ADC_reg_00,
    ADC_reg_01             => ADC_reg_01,
    ADC_reg_02             => ADC_reg_02,
    ADC_reg_03             => ADC_reg_03,
    ADC_reg_04             => ADC_reg_04,
    ADC_reg_05             => ADC_reg_05,
    ADC_reg_06             => ADC_reg_06,
    ADC_reg_07             => ADC_reg_07,
    ADC_reg_08             => ADC_reg_08,
    ADC_reg_09             => ADC_reg_09,
    ADC_reg_10             => ADC_reg_10,
    ADC_reg_11             => ADC_reg_11,
    ADC_reg_12             => ADC_reg_12,
    ADC_reg_13             => ADC_reg_13,
    ADC_reg_14             => ADC_reg_14,
    ADC_reg_15             => ADC_reg_15,
    data_valid_pulse       => data_valid_pulse,
    sync_pulse             => sync_pulse,
    pwm                    => pwm,
    gpo                    => gpo,
    oversampling_pulse     => open,
    BBOX_tri_o             => BBOX_tri_o,
    BBOX_tri_t             => BBOX_tri_t,
    cpu_core_state         => cpu_core_state,
    fault                  => fault,
    private_out            => i_private_out,
    adc_done_cpu_pulse     => adc_done_cpu_pulse,
    adc_done_pulse         => adc_done_pulse,
    sampling_pulse         => sampling_pulse,
    GT_gt0_qplllock        => GT_gt0_qplllock,
    GT_gt0_qpllrefclklost  => GT_gt0_qpllrefclklost,
    GT_gt_qpllclk_quad1    => GT_gt_qpllclk_quad1,
    GT_gt_qpllrefclk_quad1 => GT_gt_qpllrefclk_quad1,
    GT_gt_refclk1          => GT_gt_refclk1,
    USR_tri_o              => USR_tri_o,
    USR_tri_t              => USR_tri_t,
    CLOCK_0_clk_en         => CLOCK_0_clk_en,
    CLOCK_0_period         => CLOCK_0_period,
    CLOCK_0_prescaler      => CLOCK_0_prescaler,
    CLOCK_0_timer          => CLOCK_0_timer,
    CLOCK_1_clk_en         => CLOCK_1_clk_en,
    CLOCK_1_period         => CLOCK_1_period,
    CLOCK_1_prescaler      => CLOCK_1_prescaler,
    CLOCK_1_timer          => CLOCK_1_timer,
    CLOCK_2_clk_en         => CLOCK_2_clk_en,
    CLOCK_2_period         => CLOCK_2_period,
    CLOCK_2_prescaler      => CLOCK_2_prescaler,
    CLOCK_2_timer          => CLOCK_2_timer,
    CLOCK_3_clk_en         => CLOCK_3_clk_en,
    CLOCK_3_period         => CLOCK_3_period,
    CLOCK_3_prescaler      => CLOCK_3_prescaler,
    CLOCK_3_timer          => CLOCK_3_timer,
    reading                => reading,
    SBIO_BUS_sb_addr       => SBIO_BUS_sb_addr,
    SBIO_BUS_sb_we         => SBIO_BUS_sb_we,
    SBIO_BUS_sb_wdata      => SBIO_BUS_sb_wdata,
    m0_bscan_bscanid_en    => BSCAN_bscanid_en,
    m0_bscan_capture       => BSCAN_capture,
    m0_bscan_drck          => BSCAN_drck,
    m0_bscan_reset         => BSCAN_reset,
    m0_bscan_runtest       => BSCAN_runtest,
    m0_bscan_sel           => BSCAN_sel,
    m0_bscan_shift         => BSCAN_shift,
    m0_bscan_tck           => BSCAN_tck,
    m0_bscan_tdi           => BSCAN_tdi,
    m0_bscan_tms           => BSCAN_tms,
    m0_bscan_update        => BSCAN_update,
    m0_bscan_tdo           => BSCAN_tdo,
    FIXED_IO_mio           => FIXED_IO_mio,
    DDR_cas_n              => DDR_cas_n,
    DDR_cke                => DDR_cke,
    DDR_ck_n               => DDR_ck_n,
    DDR_ck_p               => DDR_ck_p,
    DDR_cs_n               => DDR_cs_n,
    DDR_reset_n            => DDR_reset_n,
    DDR_odt                => DDR_odt,
    DDR_ras_n              => DDR_ras_n,
    DDR_we_n               => DDR_we_n,
    DDR_ba                 => DDR_ba,
    DDR_addr               => DDR_addr,
    FIXED_IO_ddr_vrn       => FIXED_IO_ddr_vrn,
    FIXED_IO_ddr_vrp       => FIXED_IO_ddr_vrp,
    DDR_dm                 => DDR_dm,
    DDR_dq                 => DDR_dq,
    DDR_dqs_n              => DDR_dqs_n,
    DDR_dqs_p              => DDR_dqs_p,
    FIXED_IO_ps_srstb      => FIXED_IO_ps_srstb,
    FIXED_IO_ps_clk        => FIXED_IO_ps_clk,
    FIXED_IO_ps_porb       => FIXED_IO_ps_porb,
    flt                    => flt,
    gpi                    => gpi,
    BBOX_tri_i             => BBOX_tri_i,
    private_in             => i_private_in,
    inst_aurora            => inst_aurora,
    USR_tri_i              => USR_tri_i,
    sb_pwm                 => sb_pwm,
    inst_cb_pwm            => inst_cb_pwm,
    inst_pp_pwm            => inst_pp_pwm,
    inst_ss_pwm            => inst_ss_pwm,
    user_fw_id             => user_fw_id,
    SBIO_BUS_sb_rdata      => SBIO_BUS_sb_rdata);

end;
