#### ===========================================================================
#### USR I/O
#### ===========================================================================
set_property -dict {PACKAGE_PIN B3   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[0]}]
set_property -dict {PACKAGE_PIN C3   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[1]}]
set_property -dict {PACKAGE_PIN A5   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[2]}]
set_property -dict {PACKAGE_PIN B5   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[3]}]
set_property -dict {PACKAGE_PIN D4   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[4]}]
set_property -dict {PACKAGE_PIN E5   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[5]}]
set_property -dict {PACKAGE_PIN E4   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[6]}]
set_property -dict {PACKAGE_PIN B4   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[7]}]
set_property -dict {PACKAGE_PIN C4   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[8]}]
set_property -dict {PACKAGE_PIN F4   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[9]}]
set_property -dict {PACKAGE_PIN F5   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[10]}]
set_property -dict {PACKAGE_PIN D5   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[11]}]
set_property -dict {PACKAGE_PIN D6   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[12]}]
set_property -dict {PACKAGE_PIN J6   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[13]}]
set_property -dict {PACKAGE_PIN J7   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[14]}]
set_property -dict {PACKAGE_PIN G7   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[15]}]
set_property -dict {PACKAGE_PIN D1   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[16]}]
set_property -dict {PACKAGE_PIN E1   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[17]}]
set_property -dict {PACKAGE_PIN C2   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[18]}]
set_property -dict {PACKAGE_PIN E2   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[19]}]
set_property -dict {PACKAGE_PIN E3   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[20]}]
set_property -dict {PACKAGE_PIN A2   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[21]}]
set_property -dict {PACKAGE_PIN A3   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[22]}]
set_property -dict {PACKAGE_PIN D2   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[23]}]
set_property -dict {PACKAGE_PIN F6   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[24]}]
set_property -dict {PACKAGE_PIN G6   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[25]}]
set_property -dict {PACKAGE_PIN H6   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[26]}]
set_property -dict {PACKAGE_PIN H7   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[27]}]
set_property -dict {PACKAGE_PIN M12  IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[28]}]
set_property -dict {PACKAGE_PIN N13  IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[29]}]
set_property -dict {PACKAGE_PIN G8   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[30]}]
set_property -dict {PACKAGE_PIN H8   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[31]}]
set_property -dict {PACKAGE_PIN K8   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[32]}]
set_property -dict {PACKAGE_PIN L8   IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[33]}]
set_property -dict {PACKAGE_PIN L10  IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[34]}]
set_property -dict {PACKAGE_PIN M10  IOSTANDARD LVCMOS33} [get_ports {USR_tri_io[35]}]

#### ===========================================================================
#### DIGITAL OUTPUTS
#### ===========================================================================
set_property -dict {PACKAGE_PIN M8   IOSTANDARD LVCMOS33 SLEW FAST} [get_ports {dout[0]}]
set_property -dict {PACKAGE_PIN M9   IOSTANDARD LVCMOS33 SLEW FAST} [get_ports {dout[1]}]
set_property -dict {PACKAGE_PIN J9   IOSTANDARD LVCMOS33 SLEW FAST} [get_ports {dout[2]}]
set_property -dict {PACKAGE_PIN K9   IOSTANDARD LVCMOS33 SLEW FAST} [get_ports {dout[3]}]
set_property -dict {PACKAGE_PIN N8   IOSTANDARD LVCMOS33 SLEW FAST} [get_ports {dout[4]}]
set_property -dict {PACKAGE_PIN N9   IOSTANDARD LVCMOS33 SLEW FAST} [get_ports {dout[5]}]
set_property -dict {PACKAGE_PIN M11  IOSTANDARD LVCMOS33 SLEW FAST} [get_ports {dout[6]}]
set_property -dict {PACKAGE_PIN N11  IOSTANDARD LVCMOS33 SLEW FAST} [get_ports {dout[7]}]
set_property -dict {PACKAGE_PIN AP18 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[8]}]
set_property -dict {PACKAGE_PIN AP17 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[9]}]
set_property -dict {PACKAGE_PIN AN17 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[10]}]
set_property -dict {PACKAGE_PIN AN16 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[11]}]
set_property -dict {PACKAGE_PIN AP16 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[12]}]
set_property -dict {PACKAGE_PIN AP15 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[13]}]
set_property -dict {PACKAGE_PIN AM18 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[14]}]
set_property -dict {PACKAGE_PIN AN18 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[15]}]
set_property -dict {PACKAGE_PIN AK14 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[16]}]
set_property -dict {PACKAGE_PIN AK15 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[17]}]
set_property -dict {PACKAGE_PIN AM15 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[18]}]
set_property -dict {PACKAGE_PIN AM16 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[19]}]
set_property -dict {PACKAGE_PIN AB15 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[20]}]
set_property -dict {PACKAGE_PIN AB16 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[21]}]
set_property -dict {PACKAGE_PIN AD16 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[22]}]
set_property -dict {PACKAGE_PIN AD17 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[23]}]
set_property -dict {PACKAGE_PIN AB19 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[24]}]
set_property -dict {PACKAGE_PIN AC19 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[25]}]
set_property -dict {PACKAGE_PIN AG19 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[26]}]
set_property -dict {PACKAGE_PIN AG20 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[27]}]
set_property -dict {PACKAGE_PIN AE18 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[28]}]
set_property -dict {PACKAGE_PIN AE19 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[29]}]
set_property -dict {PACKAGE_PIN AK22 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[30]}]
set_property -dict {PACKAGE_PIN AK23 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[31]}]
set_property -dict {PACKAGE_PIN AN22 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[32]}]
set_property -dict {PACKAGE_PIN AP23 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[33]}]
set_property -dict {PACKAGE_PIN AD20 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[34]}]
set_property -dict {PACKAGE_PIN AL22 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[35]}]
set_property -dict {PACKAGE_PIN AL23 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[36]}]
set_property -dict {PACKAGE_PIN AE20 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[37]}]
set_property -dict {PACKAGE_PIN AA19 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[38]}]
set_property -dict {PACKAGE_PIN AA20 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[39]}]
set_property -dict {PACKAGE_PIN AN19 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[40]}]
set_property -dict {PACKAGE_PIN AF23 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[41]}]
set_property -dict {PACKAGE_PIN AM19 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[42]}]
set_property -dict {PACKAGE_PIN AP22 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[43]}]
set_property -dict {PACKAGE_PIN AE24 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[44]}]
set_property -dict {PACKAGE_PIN AP21 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[45]}]
set_property -dict {PACKAGE_PIN AE23 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[46]}]
set_property -dict {PACKAGE_PIN AL20 IOSTANDARD LVCMOS18 SLEW FAST} [get_ports {dout[47]}]

#### ===========================================================================
#### DIGITAL INPUTS
#### ===========================================================================
set_property -dict {PACKAGE_PIN A20  IOSTANDARD LVCMOS18} [get_ports {din[0]}]
set_property -dict {PACKAGE_PIN A21  IOSTANDARD LVCMOS18} [get_ports {din[1]}]
set_property -dict {PACKAGE_PIN A18  IOSTANDARD LVCMOS18} [get_ports {din[2]}]
set_property -dict {PACKAGE_PIN D22  IOSTANDARD LVCMOS18} [get_ports {din[3]}]
set_property -dict {PACKAGE_PIN C21  IOSTANDARD LVCMOS18} [get_ports {din[4]}]
set_property -dict {PACKAGE_PIN C18  IOSTANDARD LVCMOS18} [get_ports {din[5]}]
set_property -dict {PACKAGE_PIN C23  IOSTANDARD LVCMOS18} [get_ports {din[6]}]
set_property -dict {PACKAGE_PIN C22  IOSTANDARD LVCMOS18} [get_ports {din[7]}]
set_property -dict {PACKAGE_PIN B18  IOSTANDARD LVCMOS18} [get_ports {din[8]}]
set_property -dict {PACKAGE_PIN B19  IOSTANDARD LVCMOS18} [get_ports {din[9]}]
set_property -dict {PACKAGE_PIN G20  IOSTANDARD LVCMOS18} [get_ports {din[10]}]
set_property -dict {PACKAGE_PIN F20  IOSTANDARD LVCMOS18} [get_ports {din[11]}]
set_property -dict {PACKAGE_PIN D20  IOSTANDARD LVCMOS18} [get_ports {din[12]}]
set_property -dict {PACKAGE_PIN D21  IOSTANDARD LVCMOS18} [get_ports {din[13]}]
set_property -dict {PACKAGE_PIN E19  IOSTANDARD LVCMOS18} [get_ports {din[14]}]
set_property -dict {PACKAGE_PIN D19  IOSTANDARD LVCMOS18} [get_ports {din[15]}]
set_property -dict {PACKAGE_PIN A23  IOSTANDARD LVCMOS18} [get_ports {din[16]}]
set_property -dict {PACKAGE_PIN B21  IOSTANDARD LVCMOS18} [get_ports {din[17]}]
set_property -dict {PACKAGE_PIN AN23 IOSTANDARD LVCMOS18} [get_ports {din[18]}]
set_property -dict {PACKAGE_PIN AM23 IOSTANDARD LVCMOS18} [get_ports {din[19]}]
set_property -dict {PACKAGE_PIN AF21 IOSTANDARD LVCMOS18} [get_ports {din[20]}]
set_property -dict {PACKAGE_PIN AN21 IOSTANDARD LVCMOS18} [get_ports {din[21]}]
set_property -dict {PACKAGE_PIN AK18 IOSTANDARD LVCMOS18} [get_ports {din[22]}]
set_property -dict {PACKAGE_PIN AM14 IOSTANDARD LVCMOS18} [get_ports {din[23]}]

# Specific Port Properties
set_property UNAVAILABLE_DURING_CALIBRATION TRUE [get_ports {din[2]}]
set_property UNAVAILABLE_DURING_CALIBRATION TRUE [get_ports {din[8]}]
set_property UNAVAILABLE_DURING_CALIBRATION TRUE [get_ports {din[14]}]
set_property UNAVAILABLE_DURING_CALIBRATION TRUE [get_ports {din[23]}]

#### ===========================================================================
#### PRIVATE IO (Misc)
#### ===========================================================================
set_property -dict {PACKAGE_PIN B1   IOSTANDARD LVCMOS33} [get_ports private_io]

#### ===========================================================================
#### GT CLOCKS & SIGNALS (Private In/Out)
#### ===========================================================================
# GT REF CLK 0
create_clock -period 4.000 -name {private_in[32]} -waveform {0.000 2.000} [get_ports {private_in[32]}]
set_property PACKAGE_PIN W10  [get_ports {private_in[32]}]
set_property PACKAGE_PIN W9   [get_ports {private_in[33]}]
set_property -dict {PACKAGE_PIN AC17 IOSTANDARD LVDS} [get_ports {private_out[32]}]
set_property -dict {PACKAGE_PIN AC16 IOSTANDARD LVDS} [get_ports {private_out[33]}]

# GT REF CLK 1
create_clock -period 4.000 -name {private_in[34]} -waveform {0.000 2.000} [get_ports {private_in[34]}]
# Note: Input pins for Ref Clk 1 were commented out in source, assuming standard GT dedicated pins are used or constrained elsewhere if necessary.
set_property PACKAGE_PIN AB8  [get_ports {private_out[34]}]
set_property PACKAGE_PIN AB7  [get_ports {private_out[35]}]

# GT REF CLK 2 (Out Only in source)
set_property -dict {PACKAGE_PIN AG15 IOSTANDARD LVCMOS18} [get_ports {private_out[36]}]
set_property -dict {PACKAGE_PIN AG14 IOSTANDARD LVCMOS18} [get_ports {private_out[37]}]

# RXTX 0 (RSVD)
set_property PACKAGE_PIN AP4 [get_ports {private_in[0]}]
set_property PACKAGE_PIN AP3 [get_ports {private_in[1]}]
set_property PACKAGE_PIN AN6 [get_ports {private_out[0]}]
set_property PACKAGE_PIN AN5 [get_ports {private_out[1]}]

# RXTX 1 (RSVD)
set_property PACKAGE_PIN AN2 [get_ports {private_in[2]}]
set_property PACKAGE_PIN AN1 [get_ports {private_in[3]}]
set_property PACKAGE_PIN AM4 [get_ports {private_out[2]}]
set_property PACKAGE_PIN AM3 [get_ports {private_out[3]}]

# RXTX 2 (RSVD)
set_property PACKAGE_PIN AL2 [get_ports {private_in[4]}]
set_property PACKAGE_PIN AL1 [get_ports {private_in[5]}]
set_property PACKAGE_PIN AL6 [get_ports {private_out[4]}]
set_property PACKAGE_PIN AL5 [get_ports {private_out[5]}]

# RXTX 3 (RSVD)
set_property PACKAGE_PIN AK4 [get_ports {private_in[6]}]
set_property PACKAGE_PIN AK3 [get_ports {private_in[7]}]
set_property PACKAGE_PIN AJ6 [get_ports {private_out[6]}]
set_property PACKAGE_PIN AJ5 [get_ports {private_out[7]}]

# RXTX 0 (UP)
set_property PACKAGE_PIN AJ2 [get_ports {private_in[8]}]
set_property PACKAGE_PIN AJ1 [get_ports {private_in[9]}]
set_property PACKAGE_PIN AH4 [get_ports {private_out[8]}]
set_property PACKAGE_PIN AH3 [get_ports {private_out[9]}]

# RXTX 1 (UP)
set_property PACKAGE_PIN AG2 [get_ports {private_in[10]}]
set_property PACKAGE_PIN AG1 [get_ports {private_in[11]}]
set_property PACKAGE_PIN AG6 [get_ports {private_out[10]}]
set_property PACKAGE_PIN AG5 [get_ports {private_out[11]}]

# RXTX 2 (UP)
set_property PACKAGE_PIN AF4 [get_ports {private_in[12]}]
set_property PACKAGE_PIN AF3 [get_ports {private_in[13]}]
set_property PACKAGE_PIN AE6 [get_ports {private_out[12]}]
set_property PACKAGE_PIN AE5 [get_ports {private_out[13]}]

# RXTX 3 (UP)
set_property PACKAGE_PIN AE2 [get_ports {private_in[14]}]
set_property PACKAGE_PIN AE1 [get_ports {private_in[15]}]
set_property PACKAGE_PIN AD4 [get_ports {private_out[14]}]
set_property PACKAGE_PIN AD3 [get_ports {private_out[15]}]

# RXTX 0 (DOWN0)
set_property PACKAGE_PIN AC2 [get_ports {private_in[16]}]
set_property PACKAGE_PIN AC1 [get_ports {private_in[17]}]
set_property PACKAGE_PIN AC6 [get_ports {private_out[16]}]
set_property PACKAGE_PIN AC5 [get_ports {private_out[17]}]

# RXTX 1 (DOWN0)
set_property PACKAGE_PIN AB4 [get_ports {private_in[18]}]
set_property PACKAGE_PIN AB3 [get_ports {private_in[19]}]
set_property PACKAGE_PIN AA6 [get_ports {private_out[18]}]
set_property PACKAGE_PIN AA5 [get_ports {private_out[19]}]

# RXTX 2 (DOWN0)
set_property PACKAGE_PIN AA2 [get_ports {private_in[20]}]
set_property PACKAGE_PIN AA1 [get_ports {private_in[21]}]
set_property PACKAGE_PIN Y4  [get_ports {private_out[20]}]
set_property PACKAGE_PIN Y3  [get_ports {private_out[21]}]

# RXTX 3 (DOWN0)
set_property PACKAGE_PIN W2  [get_ports {private_in[22]}]
set_property PACKAGE_PIN W1  [get_ports {private_in[23]}]
set_property PACKAGE_PIN W6  [get_ports {private_out[22]}]
set_property PACKAGE_PIN W5  [get_ports {private_out[23]}]

# RXTX 0 (DOWN1)
set_property PACKAGE_PIN V4  [get_ports {private_in[24]}]
set_property PACKAGE_PIN V3  [get_ports {private_in[25]}]
set_property PACKAGE_PIN U6  [get_ports {private_out[24]}]
set_property PACKAGE_PIN U5  [get_ports {private_out[25]}]

# RXTX 1 (DOWN1)
set_property PACKAGE_PIN U2  [get_ports {private_in[26]}]
set_property PACKAGE_PIN U1  [get_ports {private_in[27]}]
set_property PACKAGE_PIN T4  [get_ports {private_out[26]}]
set_property PACKAGE_PIN T3  [get_ports {private_out[27]}]

# RXTX 2 (DOWN1)
set_property PACKAGE_PIN R2  [get_ports {private_in[28]}]
set_property PACKAGE_PIN R1  [get_ports {private_in[29]}]
set_property PACKAGE_PIN R6  [get_ports {private_out[28]}]
set_property PACKAGE_PIN R5  [get_ports {private_out[29]}]

# RXTX 3 (DOWN1)
set_property PACKAGE_PIN P4  [get_ports {private_in[30]}]
set_property PACKAGE_PIN P3  [get_ports {private_in[31]}]
set_property PACKAGE_PIN N6  [get_ports {private_out[30]}]
set_property PACKAGE_PIN N5  [get_ports {private_out[31]}]

#### ===========================================================================
#### ADC INTERFACE
#### ===========================================================================
# ADC DCLK Clocks
create_clock -period 4.167 -name {private_in[48]} -waveform {0.000 2.084} [get_ports {private_in[48]}]
create_clock -period 4.167 -name {private_in[50]} -waveform {0.000 2.084} [get_ports {private_in[50]}]
create_clock -period 4.167 -name {private_in[52]} -waveform {0.000 2.084} [get_ports {private_in[52]}]
create_clock -period 4.167 -name {private_in[54]} -waveform {0.000 2.084} [get_ports {private_in[54]}]
create_clock -period 4.167 -name {private_in[56]} -waveform {0.000 2.084} [get_ports {private_in[56]}]
create_clock -period 4.167 -name {private_in[58]} -waveform {0.000 2.084} [get_ports {private_in[58]}]
create_clock -period 4.167 -name {private_in[60]} -waveform {0.000 2.084} [get_ports {private_in[60]}]
create_clock -period 4.167 -name {private_in[62]} -waveform {0.000 2.084} [get_ports {private_in[62]}]
create_clock -period 4.167 -name {private_in[64]} -waveform {0.000 2.084} [get_ports {private_in[64]}]
create_clock -period 4.167 -name {private_in[66]} -waveform {0.000 2.084} [get_ports {private_in[66]}]
create_clock -period 4.167 -name {private_in[68]} -waveform {0.000 2.084} [get_ports {private_in[68]}]
create_clock -period 4.167 -name {private_in[70]} -waveform {0.000 2.084} [get_ports {private_in[70]}]

# ADC LVDS Inputs
set_property -dict {PACKAGE_PIN F22  IOSTANDARD LVDS} [get_ports {private_in[48]}]
set_property -dict {PACKAGE_PIN E22  IOSTANDARD LVDS} [get_ports {private_in[49]}]
set_property -dict {PACKAGE_PIN F23  IOSTANDARD LVDS} [get_ports {private_in[50]}]
set_property -dict {PACKAGE_PIN E23  IOSTANDARD LVDS} [get_ports {private_in[51]}]
set_property -dict {PACKAGE_PIN G21  IOSTANDARD LVDS} [get_ports {private_in[52]}]
set_property -dict {PACKAGE_PIN F21  IOSTANDARD LVDS} [get_ports {private_in[53]}]
set_property -dict {PACKAGE_PIN G23  IOSTANDARD LVDS} [get_ports {private_in[54]}]
set_property -dict {PACKAGE_PIN G24  IOSTANDARD LVDS} [get_ports {private_in[55]}]
set_property -dict {PACKAGE_PIN AH18 IOSTANDARD LVDS} [get_ports {private_in[56]}]
set_property -dict {PACKAGE_PIN AH17 IOSTANDARD LVDS} [get_ports {private_in[57]}]
set_property -dict {PACKAGE_PIN AJ16 IOSTANDARD LVDS} [get_ports {private_in[58]}]
set_property -dict {PACKAGE_PIN AJ15 IOSTANDARD LVDS} [get_ports {private_in[59]}]
set_property -dict {PACKAGE_PIN AJ17 IOSTANDARD LVDS} [get_ports {private_in[60]}]
set_property -dict {PACKAGE_PIN AK17 IOSTANDARD LVDS} [get_ports {private_in[61]}]
set_property -dict {PACKAGE_PIN AF18 IOSTANDARD LVDS} [get_ports {private_in[62]}]
set_property -dict {PACKAGE_PIN AG18 IOSTANDARD LVDS} [get_ports {private_in[63]}]
set_property -dict {PACKAGE_PIN AJ20 IOSTANDARD LVDS} [get_ports {private_in[64]}]
set_property -dict {PACKAGE_PIN AK20 IOSTANDARD LVDS} [get_ports {private_in[65]}]
set_property -dict {PACKAGE_PIN AG21 IOSTANDARD LVDS} [get_ports {private_in[66]}]
set_property -dict {PACKAGE_PIN AH21 IOSTANDARD LVDS} [get_ports {private_in[67]}]
set_property -dict {PACKAGE_PIN AJ21 IOSTANDARD LVDS} [get_ports {private_in[68]}]
set_property -dict {PACKAGE_PIN AJ22 IOSTANDARD LVDS} [get_ports {private_in[69]}]
set_property -dict {PACKAGE_PIN AH22 IOSTANDARD LVDS} [get_ports {private_in[70]}]
set_property -dict {PACKAGE_PIN AH23 IOSTANDARD LVDS} [get_ports {private_in[71]}]
set_property -dict {PACKAGE_PIN E24  IOSTANDARD LVDS} [get_ports {private_in[72]}]
set_property -dict {PACKAGE_PIN D24  IOSTANDARD LVDS} [get_ports {private_in[73]}]
set_property -dict {PACKAGE_PIN J21  IOSTANDARD LVDS} [get_ports {private_in[74]}]
set_property -dict {PACKAGE_PIN J22  IOSTANDARD LVDS} [get_ports {private_in[75]}]
set_property -dict {PACKAGE_PIN H21  IOSTANDARD LVDS} [get_ports {private_in[76]}]
set_property -dict {PACKAGE_PIN H22  IOSTANDARD LVDS} [get_ports {private_in[77]}]
set_property -dict {PACKAGE_PIN G25  IOSTANDARD LVDS} [get_ports {private_in[78]}]
set_property -dict {PACKAGE_PIN G26  IOSTANDARD LVDS} [get_ports {private_in[79]}]
set_property -dict {PACKAGE_PIN AA16 IOSTANDARD LVDS} [get_ports {private_in[80]}]
set_property -dict {PACKAGE_PIN AA15 IOSTANDARD LVDS} [get_ports {private_in[81]}]
set_property -dict {PACKAGE_PIN AA14 IOSTANDARD LVDS} [get_ports {private_in[82]}]
set_property -dict {PACKAGE_PIN AB14 IOSTANDARD LVDS} [get_ports {private_in[83]}]
set_property -dict {PACKAGE_PIN AD15 IOSTANDARD LVDS} [get_ports {private_in[84]}]
set_property -dict {PACKAGE_PIN AE15 IOSTANDARD LVDS} [get_ports {private_in[85]}]
set_property -dict {PACKAGE_PIN AF16 IOSTANDARD LVDS} [get_ports {private_in[86]}]
set_property -dict {PACKAGE_PIN AF15 IOSTANDARD LVDS} [get_ports {private_in[87]}]
set_property -dict {PACKAGE_PIN AJ19 IOSTANDARD LVDS} [get_ports {private_in[88]}]
set_property -dict {PACKAGE_PIN AK19 IOSTANDARD LVDS} [get_ports {private_in[89]}]
set_property -dict {PACKAGE_PIN AP19 IOSTANDARD LVDS} [get_ports {private_in[90]}]
set_property -dict {PACKAGE_PIN AP20 IOSTANDARD LVDS} [get_ports {private_in[91]}]
set_property -dict {PACKAGE_PIN AA18 IOSTANDARD LVDS} [get_ports {private_in[92]}]
set_property -dict {PACKAGE_PIN AB18 IOSTANDARD LVDS} [get_ports {private_in[93]}]
set_property -dict {PACKAGE_PIN AC18 IOSTANDARD LVDS} [get_ports {private_in[94]}]
set_property -dict {PACKAGE_PIN AD19 IOSTANDARD LVDS} [get_ports {private_in[95]}]

# ADC/DAC Control Pins
set_property -dict {PACKAGE_PIN AE17 IOSTANDARD LVCMOS18} [get_ports {private_out[38]}]
set_property -dict {PACKAGE_PIN C1   IOSTANDARD LVCMOS33} [get_ports {private_out[39]}]
set_property -dict {PACKAGE_PIN AF17 IOSTANDARD LVCMOS18} [get_ports {private_out[40]}]
set_property -dict {PACKAGE_PIN AL15 IOSTANDARD LVCMOS18} [get_ports {private_out[41]}]
set_property -dict {PACKAGE_PIN AN14 IOSTANDARD LVCMOS18} [get_ports {private_out[42]}]
set_property -dict {PACKAGE_PIN AJ14 IOSTANDARD LVCMOS18} [get_ports {private_out[43]}]
set_property -dict {PACKAGE_PIN AH14 IOSTANDARD LVCMOS18} [get_ports {private_out[44]}]
set_property -dict {PACKAGE_PIN AL18 IOSTANDARD LVCMOS18} [get_ports {private_out[45]}]
set_property -dict {PACKAGE_PIN AL16 IOSTANDARD LVCMOS18} [get_ports {private_out[46]}]
set_property -dict {PACKAGE_PIN AP13 IOSTANDARD LVCMOS18} [get_ports {private_out[47]}]
set_property -dict {PACKAGE_PIN AN13 IOSTANDARD LVCMOS18} [get_ports {private_out[48]}]

#### ===========================================================================
#### RS485 & OTHER IO
#### ===========================================================================
set_property -dict {PACKAGE_PIN A19  IOSTANDARD LVCMOS18} [get_ports {private_in[96]}]
set_property -dict {PACKAGE_PIN AG23 IOSTANDARD LVCMOS18} [get_ports {private_in[97]}]

set_property -dict {PACKAGE_PIN C19  IOSTANDARD LVCMOS18} [get_ports {private_out[49]}]
set_property -dict {PACKAGE_PIN B20  IOSTANDARD LVCMOS18} [get_ports {private_out[50]}]
set_property -dict {PACKAGE_PIN A22  IOSTANDARD LVCMOS18} [get_ports {private_out[51]}]
set_property -dict {PACKAGE_PIN AM21 IOSTANDARD LVCMOS18} [get_ports {private_out[52]}]
set_property -dict {PACKAGE_PIN AL21 IOSTANDARD LVCMOS18} [get_ports {private_out[53]}]
set_property -dict {PACKAGE_PIN AF22 IOSTANDARD LVCMOS18} [get_ports {private_out[54]}]

#### ===========================================================================
#### WAIVERS
#### ===========================================================================
create_waiver -type METHODOLOGY -id {TIMING-6} -user "vh" -desc "Remaining CDC checked"
create_waiver -type METHODOLOGY -id {TIMING-7} -user "vh" -desc "Remaining CDC checked"