library IEEE;
use IEEE.STD_LOGIC_1164.all;

entity ixip is
  generic (
    Remove_CB_PWM_0_to_7   : boolean := false;
    Remove_CB_PWM_8_to_15  : boolean := false;
    Remove_CB_PWM_16_to_23 : boolean := false;
    Remove_CB_PWM_24_to_31 : boolean := false;
    Remove_CB_PWM_32_to_39 : boolean := false;
    Remove_CB_PWM_40_to_47 : boolean := false;
    Remove_PP_PWM          : boolean := true;
    Remove_SS_PWM          : boolean := true;
    Enable_GT_Lane_4       : boolean := false;
    Enable_GT_Lane_5       : boolean := false;
    Enable_GT_Lane_6       : boolean := false;
    Enable_GT_Lane_7       : boolean := false;
    Enable_Serial_A        : boolean := false;
    Enable_Serial_B        : boolean := false
  );
  port (
    clk_50_mhz       : out std_logic;
    clk_250_mhz      : out std_logic;
    sync_pulse       : out std_logic;
    data_valid_pulse : out std_logic;
    cpu_core_state   : out std_logic_vector (1 downto 0);
    fault            : out std_logic;
    private_out      : out std_logic_vector (54 downto 0);

    ADC_reg_00 : out std_logic_vector (15 downto 0);
    ADC_reg_01 : out std_logic_vector (15 downto 0);
    ADC_reg_02 : out std_logic_vector (15 downto 0);
    ADC_reg_03 : out std_logic_vector (15 downto 0);
    ADC_reg_04 : out std_logic_vector (15 downto 0);
    ADC_reg_05 : out std_logic_vector (15 downto 0);
    ADC_reg_06 : out std_logic_vector (15 downto 0);
    ADC_reg_07 : out std_logic_vector (15 downto 0);
    ADC_reg_08 : out std_logic_vector (15 downto 0);
    ADC_reg_09 : out std_logic_vector (15 downto 0);
    ADC_reg_10 : out std_logic_vector (15 downto 0);
    ADC_reg_11 : out std_logic_vector (15 downto 0);
    ADC_reg_12 : out std_logic_vector (15 downto 0);
    ADC_reg_13 : out std_logic_vector (15 downto 0);
    ADC_reg_14 : out std_logic_vector (15 downto 0);
    ADC_reg_15 : out std_logic_vector (15 downto 0);
    ADC_reg_16 : out std_logic_vector (15 downto 0);
    ADC_reg_17 : out std_logic_vector (15 downto 0);
    ADC_reg_18 : out std_logic_vector (15 downto 0);
    ADC_reg_19 : out std_logic_vector (15 downto 0);
    ADC_reg_20 : out std_logic_vector (15 downto 0);
    ADC_reg_21 : out std_logic_vector (15 downto 0);
    ADC_reg_22 : out std_logic_vector (15 downto 0);
    ADC_reg_23 : out std_logic_vector (15 downto 0);

    ADC_FIX32_16_reg_00 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_01 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_02 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_03 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_04 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_05 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_06 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_07 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_08 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_09 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_10 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_11 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_12 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_13 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_14 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_15 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_16 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_17 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_18 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_19 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_20 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_21 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_22 : out std_logic_vector (31 downto 0);
    ADC_FIX32_16_reg_23 : out std_logic_vector (31 downto 0);

    ADC_FLOAT_reg_00 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_01 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_02 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_03 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_04 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_05 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_06 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_07 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_08 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_09 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_10 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_11 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_12 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_13 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_14 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_15 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_16 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_17 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_18 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_19 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_20 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_21 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_22 : out std_logic_vector (31 downto 0);
    ADC_FLOAT_reg_23 : out std_logic_vector (31 downto 0);

    adc_done_pulse           : out std_logic;
    adc_done_cpu_pulse       : out std_logic;
    adc_done_float_pulse     : out std_logic;
    adc_done_cpu_float_pulse : out std_logic;

    sampling_pulse    : out std_logic;
    reading           : out std_logic;
    SBIO_BUS_sb_addr  : out std_logic_vector (9 downto 0);
    SBIO_BUS_sb_we    : out std_logic;
    SBIO_BUS_sb_wdata : out std_logic_vector (15 downto 0);
    dout              : out std_logic_vector (47 downto 0);
    CLOCK_0_clk_en    : out std_logic;
    CLOCK_0_period    : out std_logic_vector (15 downto 0);
    CLOCK_0_prescaler : out std_logic_vector (15 downto 0);
    CLOCK_0_timer     : out std_logic_vector (15 downto 0);
    CLOCK_1_clk_en    : out std_logic;
    CLOCK_1_period    : out std_logic_vector (15 downto 0);
    CLOCK_1_prescaler : out std_logic_vector (15 downto 0);
    CLOCK_1_timer     : out std_logic_vector (15 downto 0);
    CLOCK_2_clk_en    : out std_logic;
    CLOCK_2_period    : out std_logic_vector (15 downto 0);
    CLOCK_2_prescaler : out std_logic_vector (15 downto 0);
    CLOCK_2_timer     : out std_logic_vector (15 downto 0);
    CLOCK_3_clk_en    : out std_logic;
    CLOCK_3_period    : out std_logic_vector (15 downto 0);
    CLOCK_3_prescaler : out std_logic_vector (15 downto 0);
    CLOCK_3_timer     : out std_logic_vector (15 downto 0);
    USR_tri_o         : out std_logic_vector (35 downto 0);
    USR_tri_t         : out std_logic_vector (35 downto 0);

    gt_refclk        : out std_logic;
    GT_USER_RX_4_rxn : out std_logic;
    GT_USER_RX_4_rxp : out std_logic;
    GT_USER_RX_5_rxn : out std_logic;
    GT_USER_RX_5_rxp : out std_logic;
    GT_USER_RX_6_rxn : out std_logic;
    GT_USER_RX_6_rxp : out std_logic;
    GT_USER_RX_7_rxn : out std_logic;
    GT_USER_RX_7_rxp : out std_logic;

    GT_USER_TX_4_txn : in std_logic;
    GT_USER_TX_4_txp : in std_logic;
    GT_USER_TX_5_txn : in std_logic;
    GT_USER_TX_5_txp : in std_logic;
    GT_USER_TX_6_txn : in std_logic;
    GT_USER_TX_6_txp : in std_logic;
    GT_USER_TX_7_txn : in std_logic;
    GT_USER_TX_7_txp : in std_logic;

    SERIAL_A_rx  : out std_logic;
    SERIAL_A_clk : in std_logic;
    SERIAL_A_en  : in std_logic;
    SERIAL_A_tx  : in std_logic;

    SERIAL_B_rx  : out std_logic;
    SERIAL_B_clk : in std_logic;
    SERIAL_B_en  : in std_logic;
    SERIAL_B_tx  : in std_logic;

    BSCAN_bscanid_en : out std_logic;
    BSCAN_capture    : out std_logic;
    BSCAN_drck       : out std_logic;
    BSCAN_reset      : out std_logic;
    BSCAN_runtest    : out std_logic;
    BSCAN_sel        : out std_logic;
    BSCAN_shift      : out std_logic;
    BSCAN_tck        : out std_logic;
    BSCAN_tdi        : out std_logic;
    BSCAN_tms        : out std_logic;
    BSCAN_update     : out std_logic;
    BSCAN_tdo        : in std_logic;

    private_io        : inout std_logic;
    sb_pwm            : in std_logic_vector (47 downto 0);
    private_in        : in std_logic_vector (97 downto 0);
    user_fw_id        : in std_logic_vector (15 downto 0);
    SBIO_BUS_sb_rdata : in std_logic_vector (15 downto 0);
    USR_tri_i         : in std_logic_vector (35 downto 0);
    din               : in std_logic_vector (23 downto 0)
  );
end ixip;

architecture stub of ixip is

  attribute X_INTERFACE_INFO              : string;
  attribute X_INTERFACE_PARAMETER         : string;
  attribute X_INTERFACE_MODE              : string;
  attribute X_INTERFACE_INFO of USR_tri_i : signal is "xilinx.com:interface:gpio:1.0 USR TRI_I";
  attribute X_INTERFACE_INFO of USR_tri_o : signal is "xilinx.com:interface:gpio:1.0 USR TRI_O";
  attribute X_INTERFACE_INFO of USR_tri_t : signal is "xilinx.com:interface:gpio:1.0 USR TRI_T";

  -- Lane 4 RX
  attribute X_INTERFACE_INFO of GT_USER_RX_4_rxp : signal is
  "xilinx.com:display_aurora:GT_Serial_Transceiver_Pins_RX_rtl:1.0 GT_USER_RX_4 RXP";
  attribute X_INTERFACE_INFO of GT_USER_RX_4_rxn : signal is
  "xilinx.com:display_aurora:GT_Serial_Transceiver_Pins_RX_rtl:1.0 GT_USER_RX_4 RXN";
  attribute X_INTERFACE_PARAMETER of GT_USER_RX_4_rxp : signal is
  "XIL_INTERFACENAME GT_USER_RX_4";
  attribute X_INTERFACE_MODE of GT_USER_RX_4_rxp : signal is "MASTER";
  -- Lane 5 RX
  attribute X_INTERFACE_INFO of GT_USER_RX_5_rxp : signal is
  "xilinx.com:display_aurora:GT_Serial_Transceiver_Pins_RX_rtl:1.0 GT_USER_RX_5 RXP";
  attribute X_INTERFACE_INFO of GT_USER_RX_5_rxn : signal is
  "xilinx.com:display_aurora:GT_Serial_Transceiver_Pins_RX_rtl:1.0 GT_USER_RX_5 RXN";
  attribute X_INTERFACE_PARAMETER of GT_USER_RX_5_rxp : signal is
  "XIL_INTERFACENAME GT_USER_RX_5";
  attribute X_INTERFACE_MODE of GT_USER_RX_5_rxp : signal is "MASTER";
  -- Lane 6 RX
  attribute X_INTERFACE_INFO of GT_USER_RX_6_rxp : signal is
  "xilinx.com:display_aurora:GT_Serial_Transceiver_Pins_RX_rtl:1.0 GT_USER_RX_6 RXP";
  attribute X_INTERFACE_INFO of GT_USER_RX_6_rxn : signal is
  "xilinx.com:display_aurora:GT_Serial_Transceiver_Pins_RX_rtl:1.0 GT_USER_RX_6 RXN";
  attribute X_INTERFACE_PARAMETER of GT_USER_RX_6_rxp : signal is
  "XIL_INTERFACENAME GT_USER_RX_6";
  attribute X_INTERFACE_MODE of GT_USER_RX_6_rxp : signal is "MASTER";
  -- Lane 7 RX
  attribute X_INTERFACE_INFO of GT_USER_RX_7_rxp : signal is
  "xilinx.com:display_aurora:GT_Serial_Transceiver_Pins_RX_rtl:1.0 GT_USER_RX_7 RXP";
  attribute X_INTERFACE_INFO of GT_USER_RX_7_rxn : signal is
  "xilinx.com:display_aurora:GT_Serial_Transceiver_Pins_RX_rtl:1.0 GT_USER_RX_7 RXN";
  attribute X_INTERFACE_PARAMETER of GT_USER_RX_7_rxp : signal is
  "XIL_INTERFACENAME GT_USER_RX_7";
  attribute X_INTERFACE_MODE of GT_USER_RX_7_rxp : signal is "MASTER";

  -- Lane 4 TX
  attribute X_INTERFACE_INFO of GT_USER_TX_4_txp : signal is
  "xilinx.com:display_aurora:GT_Serial_Transceiver_Pins_TX_rtl:1.0 GT_USER_TX_4 TXP";
  attribute X_INTERFACE_INFO of GT_USER_TX_4_txn : signal is
  "xilinx.com:display_aurora:GT_Serial_Transceiver_Pins_TX_rtl:1.0 GT_USER_TX_4 TXN";
  attribute X_INTERFACE_PARAMETER of GT_USER_TX_4_txp : signal is
  "XIL_INTERFACENAME GT_USER_TX_4";
  attribute X_INTERFACE_MODE of GT_USER_TX_4_txp : signal is "SLAVE";
  -- Lane 5 TX
  attribute X_INTERFACE_INFO of GT_USER_TX_5_txp : signal is
  "xilinx.com:display_aurora:GT_Serial_Transceiver_Pins_TX_rtl:1.0 GT_USER_TX_5 TXP";
  attribute X_INTERFACE_INFO of GT_USER_TX_5_txn : signal is
  "xilinx.com:display_aurora:GT_Serial_Transceiver_Pins_TX_rtl:1.0 GT_USER_TX_5 TXN";
  attribute X_INTERFACE_PARAMETER of GT_USER_TX_5_txp : signal is
  "XIL_INTERFACENAME GT_USER_TX_5";
  attribute X_INTERFACE_MODE of GT_USER_TX_5_txp : signal is "SLAVE";
  -- Lane 6 TX
  attribute X_INTERFACE_INFO of GT_USER_TX_6_txp : signal is
  "xilinx.com:display_aurora:GT_Serial_Transceiver_Pins_TX_rtl:1.0 GT_USER_TX_6 TXP";
  attribute X_INTERFACE_INFO of GT_USER_TX_6_txn : signal is
  "xilinx.com:display_aurora:GT_Serial_Transceiver_Pins_TX_rtl:1.0 GT_USER_TX_6 TXN";
  attribute X_INTERFACE_PARAMETER of GT_USER_TX_6_txp : signal is
  "XIL_INTERFACENAME GT_USER_TX_6";
  attribute X_INTERFACE_MODE of GT_USER_TX_6_txp : signal is "SLAVE";
  -- Lane 7 TX
  attribute X_INTERFACE_INFO of GT_USER_TX_7_txp : signal is
  "xilinx.com:display_aurora:GT_Serial_Transceiver_Pins_TX_rtl:1.0 GT_USER_TX_7 TXP";
  attribute X_INTERFACE_INFO of GT_USER_TX_7_txn : signal is
  "xilinx.com:display_aurora:GT_Serial_Transceiver_Pins_TX_rtl:1.0 GT_USER_TX_7 TXN";
  attribute X_INTERFACE_PARAMETER of GT_USER_TX_7_txp : signal is
  "XIL_INTERFACENAME GT_USER_TX_7";
  attribute X_INTERFACE_MODE of GT_USER_TX_7_txp : signal is "SLAVE";
  -- Serial A Interface
  attribute X_INTERFACE_INFO of SERIAL_A_rx : signal is
  "imperix.ch:ix:serial_rs485:1.0 SERIAL_A rx";
  attribute X_INTERFACE_INFO of SERIAL_A_clk : signal is
  "imperix.ch:ix:serial_rs485:1.0 SERIAL_A clk";
  attribute X_INTERFACE_INFO of SERIAL_A_en : signal is
  "imperix.ch:ix:serial_rs485:1.0 SERIAL_A en";
  attribute X_INTERFACE_INFO of SERIAL_A_tx : signal is
  "imperix.ch:ix:serial_rs485:1.0 SERIAL_A tx";
  -- Serial B Interface
  attribute X_INTERFACE_INFO of SERIAL_B_rx : signal is
  "imperix.ch:ix:serial_rs485:1.0 SERIAL_B rx";
  attribute X_INTERFACE_INFO of SERIAL_B_clk : signal is
  "imperix.ch:ix:serial_rs485:1.0 SERIAL_B clk";
  attribute X_INTERFACE_INFO of SERIAL_B_en : signal is
  "imperix.ch:ix:serial_rs485:1.0 SERIAL_B en";
  attribute X_INTERFACE_INFO of SERIAL_B_tx : signal is
  "imperix.ch:ix:serial_rs485:1.0 SERIAL_B tx";
  attribute X_INTERFACE_PARAMETER of SERIAL_A_rx : signal is
  "XIL_INTERFACENAME SERIAL_A";
  attribute X_INTERFACE_MODE of SERIAL_A_rx      : signal is "MASTER";
  attribute X_INTERFACE_PARAMETER of SERIAL_B_rx : signal is
  "XIL_INTERFACENAME SERIAL_B";
  attribute X_INTERFACE_MODE of SERIAL_B_rx : signal is "MASTER";
  -- Clock 0 Interface
  attribute X_INTERFACE_INFO of CLOCK_0_clk_en : signal is
  "imperix.ch:ix:clock_gen:1.0 CLOCK_0 clk_en";
  attribute X_INTERFACE_INFO of CLOCK_0_period : signal is
  "imperix.ch:ix:clock_gen:1.0 CLOCK_0 period";
  attribute X_INTERFACE_INFO of CLOCK_0_prescaler : signal is
  "imperix.ch:ix:clock_gen:1.0 CLOCK_0 prescaler";
  attribute X_INTERFACE_INFO of CLOCK_0_timer : signal is
  "imperix.ch:ix:clock_gen:1.0 CLOCK_0 timer";
  -- Clock 1 Interface
  attribute X_INTERFACE_INFO of CLOCK_1_clk_en : signal is
  "imperix.ch:ix:clock_gen:1.0 CLOCK_1 clk_en";
  attribute X_INTERFACE_INFO of CLOCK_1_period : signal is
  "imperix.ch:ix:clock_gen:1.0 CLOCK_1 period";
  attribute X_INTERFACE_INFO of CLOCK_1_prescaler : signal is
  "imperix.ch:ix:clock_gen:1.0 CLOCK_1 prescaler";
  attribute X_INTERFACE_INFO of CLOCK_1_timer : signal is
  "imperix.ch:ix:clock_gen:1.0 CLOCK_1 timer";
  -- Clock 2 Interface
  attribute X_INTERFACE_INFO of CLOCK_2_clk_en : signal is
  "imperix.ch:ix:clock_gen:1.0 CLOCK_2 clk_en";
  attribute X_INTERFACE_INFO of CLOCK_2_period : signal is
  "imperix.ch:ix:clock_gen:1.0 CLOCK_2 period";
  attribute X_INTERFACE_INFO of CLOCK_2_prescaler : signal is
  "imperix.ch:ix:clock_gen:1.0 CLOCK_2 prescaler";
  attribute X_INTERFACE_INFO of CLOCK_2_timer : signal is
  "imperix.ch:ix:clock_gen:1.0 CLOCK_2 timer";
  -- Clock 3 Interface
  attribute X_INTERFACE_INFO of CLOCK_3_clk_en : signal is
  "imperix.ch:ix:clock_gen:1.0 CLOCK_3 clk_en";
  attribute X_INTERFACE_INFO of CLOCK_3_period : signal is
  "imperix.ch:ix:clock_gen:1.0 CLOCK_3 period";
  attribute X_INTERFACE_INFO of CLOCK_3_prescaler : signal is
  "imperix.ch:ix:clock_gen:1.0 CLOCK_3 prescaler";
  attribute X_INTERFACE_INFO of CLOCK_3_timer : signal is
  "imperix.ch:ix:clock_gen:1.0 CLOCK_3 timer";

  -- BSCAN Interface
  attribute X_INTERFACE_INFO of BSCAN_bscanid_en : signal is
  "xilinx.com:interface:bscan:1.0 BSCAN BSCANID_EN";
  attribute X_INTERFACE_PARAMETER of BSCAN_bscanid_en : signal is
  "XIL_INTERFACENAME BSCAN, MODE Master";
  attribute X_INTERFACE_INFO of BSCAN_capture : signal is
  "xilinx.com:interface:bscan:1.0 BSCAN CAPTURE";
  attribute X_INTERFACE_INFO of BSCAN_drck : signal is
  "xilinx.com:interface:bscan:1.0 BSCAN DRCK";
  attribute X_INTERFACE_INFO of BSCAN_reset : signal is
  "xilinx.com:interface:bscan:1.0 BSCAN RESET";
  attribute X_INTERFACE_INFO of BSCAN_runtest : signal is
  "xilinx.com:interface:bscan:1.0 BSCAN RUNTEST";
  attribute X_INTERFACE_INFO of BSCAN_sel : signal is
  "xilinx.com:interface:bscan:1.0 BSCAN SEL";
  attribute X_INTERFACE_INFO of BSCAN_shift : signal is
  "xilinx.com:interface:bscan:1.0 BSCAN SHIFT";
  attribute X_INTERFACE_INFO of BSCAN_tck : signal is
  "xilinx.com:interface:bscan:1.0 BSCAN TCK";
  attribute X_INTERFACE_INFO of BSCAN_tdi : signal is
  "xilinx.com:interface:bscan:1.0 BSCAN TDI";
  attribute X_INTERFACE_INFO of BSCAN_tms : signal is
  "xilinx.com:interface:bscan:1.0 BSCAN TMS";
  attribute X_INTERFACE_INFO of BSCAN_update : signal is
  "xilinx.com:interface:bscan:1.0 BSCAN UPDATE";
  attribute X_INTERFACE_INFO of BSCAN_tdo : signal is
  "xilinx.com:interface:bscan:1.0 BSCAN TDO";

  component ip_imp_OWDWE0 is
    port (
      clk_50_mhz       : out std_logic;
      clk_250_mhz      : out std_logic;
      sync_pulse       : out std_logic;
      data_valid_pulse : out std_logic;
      cpu_core_state   : out std_logic_vector (1 downto 0);
      fault            : out std_logic;
      private_out      : out std_logic_vector (54 downto 0);
      gt_refclk        : out std_logic;
      ADC_reg_00       : out std_logic_vector (15 downto 0);
      ADC_reg_01       : out std_logic_vector (15 downto 0);
      ADC_reg_02       : out std_logic_vector (15 downto 0);
      ADC_reg_03       : out std_logic_vector (15 downto 0);
      ADC_reg_04       : out std_logic_vector (15 downto 0);
      ADC_reg_05       : out std_logic_vector (15 downto 0);
      ADC_reg_06       : out std_logic_vector (15 downto 0);
      ADC_reg_07       : out std_logic_vector (15 downto 0);
      ADC_reg_08       : out std_logic_vector (15 downto 0);
      ADC_reg_09       : out std_logic_vector (15 downto 0);
      ADC_reg_10       : out std_logic_vector (15 downto 0);
      ADC_reg_11       : out std_logic_vector (15 downto 0);
      ADC_reg_12       : out std_logic_vector (15 downto 0);
      ADC_reg_13       : out std_logic_vector (15 downto 0);
      ADC_reg_14       : out std_logic_vector (15 downto 0);
      ADC_reg_15       : out std_logic_vector (15 downto 0);
      ADC_reg_16       : out std_logic_vector (15 downto 0);
      ADC_reg_17       : out std_logic_vector (15 downto 0);
      ADC_reg_18       : out std_logic_vector (15 downto 0);
      ADC_reg_19       : out std_logic_vector (15 downto 0);
      ADC_reg_20       : out std_logic_vector (15 downto 0);
      ADC_reg_21       : out std_logic_vector (15 downto 0);
      ADC_reg_22       : out std_logic_vector (15 downto 0);
      ADC_reg_23       : out std_logic_vector (15 downto 0);

      ADC_SANDBOX_32b_reg_00 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_01 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_02 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_03 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_04 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_05 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_06 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_07 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_08 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_09 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_10 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_11 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_12 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_13 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_14 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_15 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_16 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_17 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_18 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_19 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_20 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_21 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_22 : out std_logic_vector (31 downto 0);
      ADC_SANDBOX_32b_reg_23 : out std_logic_vector (31 downto 0);

      ADC_FLOAT_reg_00 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_01 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_02 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_03 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_04 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_05 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_06 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_07 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_08 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_09 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_10 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_11 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_12 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_13 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_14 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_15 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_16 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_17 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_18 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_19 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_20 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_21 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_22 : out std_logic_vector (31 downto 0);
      ADC_FLOAT_reg_23 : out std_logic_vector (31 downto 0);

      m0_bscan_bscanid_en : out std_logic;
      m0_bscan_capture    : out std_logic;
      m0_bscan_drck       : out std_logic;
      m0_bscan_reset      : out std_logic;
      m0_bscan_runtest    : out std_logic;
      m0_bscan_sel        : out std_logic;
      m0_bscan_shift      : out std_logic;
      m0_bscan_tck        : out std_logic;
      m0_bscan_tdi        : out std_logic;
      m0_bscan_tms        : out std_logic;
      m0_bscan_update     : out std_logic;
      m0_bscan_tdo        : in std_logic;

      adc_done_pulse     : out std_logic;
      adc_done_cpu_pulse : out std_logic;

      adc_done_float_pulse     : out std_logic;
      adc_done_cpu_float_pulse : out std_logic;

      sampling_pulse    : out std_logic;
      reading           : out std_logic;
      SBIO_BUS_sb_addr  : out std_logic_vector (9 downto 0);
      SBIO_BUS_sb_we    : out std_logic;
      SBIO_BUS_sb_wdata : out std_logic_vector (15 downto 0);
      dout              : out std_logic_vector (47 downto 0);
      CLOCK_0_clk_en    : out std_logic;
      CLOCK_0_period    : out std_logic_vector (15 downto 0);
      CLOCK_0_prescaler : out std_logic_vector (15 downto 0);
      CLOCK_0_timer     : out std_logic_vector (15 downto 0);
      CLOCK_1_clk_en    : out std_logic;
      CLOCK_1_period    : out std_logic_vector (15 downto 0);
      CLOCK_1_prescaler : out std_logic_vector (15 downto 0);
      CLOCK_1_timer     : out std_logic_vector (15 downto 0);
      CLOCK_2_clk_en    : out std_logic;
      CLOCK_2_period    : out std_logic_vector (15 downto 0);
      CLOCK_2_prescaler : out std_logic_vector (15 downto 0);
      CLOCK_2_timer     : out std_logic_vector (15 downto 0);
      CLOCK_3_clk_en    : out std_logic;
      CLOCK_3_period    : out std_logic_vector (15 downto 0);
      CLOCK_3_prescaler : out std_logic_vector (15 downto 0);
      CLOCK_3_timer     : out std_logic_vector (15 downto 0);
      USR_tri_o         : out std_logic_vector (35 downto 0);
      USR_tri_t         : out std_logic_vector (35 downto 0);
      private_io        : inout std_logic;
      sb_pwm            : in std_logic_vector (47 downto 0);
      inst_cb_pwm       : in std_logic_vector (47 downto 0);
      inst_pp_pwm       : in std_logic;
      inst_ss_pwm       : in std_logic;
      private_in        : in std_logic_vector (97 downto 0);
      user_fw_id        : in std_logic_vector (15 downto 0);
      SBIO_BUS_sb_rdata : in std_logic_vector (15 downto 0);
      USR_tri_i         : in std_logic_vector (35 downto 0);
      din               : in std_logic_vector (23 downto 0)
    );
  end component ip_imp_OWDWE0;

  signal inst_cb_pwm   : std_logic_vector(47 downto 0);
  signal inst_ss_pwm   : std_logic;
  signal inst_pp_pwm   : std_logic;
  signal i_private_in  : std_logic_vector(97 downto 0);
  signal i_private_out : std_logic_vector(54 downto 0);

begin

  i_private_in(0) <= '0' when Enable_GT_Lane_4 else
  private_in(0);
  i_private_in(1) <= '0' when Enable_GT_Lane_4 else
  private_in(1);
  i_private_in(2) <= '0' when Enable_GT_Lane_5 else
  private_in(2);
  i_private_in(3) <= '0' when Enable_GT_Lane_5 else
  private_in(3);
  i_private_in(4) <= '0' when Enable_GT_Lane_6 else
  private_in(4);
  i_private_in(5) <= '0' when Enable_GT_Lane_6 else
  private_in(5);
  i_private_in(6) <= '0' when Enable_GT_Lane_7 else
  private_in(6);
  i_private_in(7) <= '0' when Enable_GT_Lane_7 else
  private_in(7);

  i_private_in(95 downto 8) <= private_in(95 downto 8);

  i_private_in(96) <= '0' when Enable_Serial_A else
  private_in(96);
  i_private_in(97) <= '0' when Enable_Serial_B else
  private_in(97);

  GT_USER_RX_4_rxp <= private_in(0) when Enable_GT_Lane_4 else
    '0';
  GT_USER_RX_4_rxn <= private_in(1) when Enable_GT_Lane_4 else
    '0';
  GT_USER_RX_5_rxp <= private_in(2) when Enable_GT_Lane_5 else
    '0';
  GT_USER_RX_5_rxn <= private_in(3) when Enable_GT_Lane_5 else
    '0';
  GT_USER_RX_6_rxp <= private_in(4) when Enable_GT_Lane_6 else
    '0';
  GT_USER_RX_6_rxn <= private_in(5) when Enable_GT_Lane_6 else
    '0';
  GT_USER_RX_7_rxp <= private_in(6) when Enable_GT_Lane_7 else
    '0';
  GT_USER_RX_7_rxn <= private_in(7) when Enable_GT_Lane_7 else
    '0';

  SERIAL_A_rx <= private_in(96) when Enable_Serial_A else
    '0';
  SERIAL_B_rx <= private_in(97) when Enable_Serial_B else
    '0';

  private_out(0) <= GT_USER_TX_4_txp when Enable_GT_Lane_4 else
  i_private_out(0);
  private_out(1) <= GT_USER_TX_4_txn when Enable_GT_Lane_4 else
  i_private_out(1);
  private_out(2) <= GT_USER_TX_5_txp when Enable_GT_Lane_5 else
  i_private_out(2);
  private_out(3) <= GT_USER_TX_5_txn when Enable_GT_Lane_5 else
  i_private_out(3);
  private_out(4) <= GT_USER_TX_6_txp when Enable_GT_Lane_6 else
  i_private_out(4);
  private_out(5) <= GT_USER_TX_6_txn when Enable_GT_Lane_6 else
  i_private_out(5);
  private_out(6) <= GT_USER_TX_7_txp when Enable_GT_Lane_7 else
  i_private_out(6);
  private_out(7) <= GT_USER_TX_7_txn when Enable_GT_Lane_7 else
  i_private_out(7);

  private_out(48 downto 8) <= i_private_out(48 downto 8);

  private_out(49) <= SERIAL_A_clk when Enable_Serial_A else
  i_private_out(49);
  private_out(50) <= SERIAL_A_en when Enable_Serial_A else
  i_private_out(50);
  private_out(51) <= SERIAL_A_tx when Enable_Serial_A else
  i_private_out(51);

  private_out(52) <= SERIAL_B_clk when Enable_Serial_B else
  i_private_out(52);
  private_out(53) <= SERIAL_B_en when Enable_Serial_B else
  i_private_out(53);
  private_out(54) <= SERIAL_B_tx when Enable_Serial_B else
  i_private_out(54);

  gen_pwm_0_7 : for i in 0 to 7 generate
    inst_cb_pwm(i) <= '1' when not Remove_CB_PWM_0_to_7 else
    '0';
  end generate;

  gen_pwm_8_15 : for i in 8 to 15 generate
    inst_cb_pwm(i) <= '1' when not Remove_CB_PWM_8_to_15 else
    '0';
  end generate;

  gen_pwm_16_23 : for i in 16 to 23 generate
    inst_cb_pwm(i) <= '1' when not Remove_CB_PWM_16_to_23 else
    '0';
  end generate;

  gen_pwm_24_31 : for i in 24 to 31 generate
    inst_cb_pwm(i) <= '1' when not Remove_CB_PWM_24_to_31 else
    '0';
  end generate;

  gen_pwm_32_39 : for i in 32 to 39 generate
    inst_cb_pwm(i) <= '1' when not Remove_CB_PWM_32_to_39 else
    '0';
  end generate;

  gen_pwm_40_47 : for i in 40 to 47 generate
    inst_cb_pwm(i) <= '1' when not Remove_CB_PWM_40_to_47 else
    '0';
  end generate;

  inst_ss_pwm <= '1' when not Remove_SS_PWM else
    '0';
  inst_pp_pwm <= '1' when not Remove_PP_PWM else
    '0';

  ip_inst : ip_imp_OWDWE0
  port map
  (
    clk_50_mhz       => clk_50_mhz,
    clk_250_mhz      => clk_250_mhz,
    sync_pulse       => sync_pulse,
    data_valid_pulse => data_valid_pulse,
    cpu_core_state   => cpu_core_state,
    fault            => fault,
    private_out      => i_private_out,
    gt_refclk        => gt_refclk,
    ADC_reg_00       => ADC_reg_00,
    ADC_reg_01       => ADC_reg_01,
    ADC_reg_02       => ADC_reg_02,
    ADC_reg_03       => ADC_reg_03,
    ADC_reg_04       => ADC_reg_04,
    ADC_reg_05       => ADC_reg_05,
    ADC_reg_06       => ADC_reg_06,
    ADC_reg_07       => ADC_reg_07,
    ADC_reg_08       => ADC_reg_08,
    ADC_reg_09       => ADC_reg_09,
    ADC_reg_10       => ADC_reg_10,
    ADC_reg_11       => ADC_reg_11,
    ADC_reg_12       => ADC_reg_12,
    ADC_reg_13       => ADC_reg_13,
    ADC_reg_14       => ADC_reg_14,
    ADC_reg_15       => ADC_reg_15,
    ADC_reg_16       => ADC_reg_16,
    ADC_reg_17       => ADC_reg_17,
    ADC_reg_18       => ADC_reg_18,
    ADC_reg_19       => ADC_reg_19,
    ADC_reg_20       => ADC_reg_20,
    ADC_reg_21       => ADC_reg_21,
    ADC_reg_22       => ADC_reg_22,
    ADC_reg_23       => ADC_reg_23,

    ADC_SANDBOX_32b_reg_00 => ADC_FIX32_16_reg_00,
    ADC_SANDBOX_32b_reg_01 => ADC_FIX32_16_reg_01,
    ADC_SANDBOX_32b_reg_02 => ADC_FIX32_16_reg_02,
    ADC_SANDBOX_32b_reg_03 => ADC_FIX32_16_reg_03,
    ADC_SANDBOX_32b_reg_04 => ADC_FIX32_16_reg_04,
    ADC_SANDBOX_32b_reg_05 => ADC_FIX32_16_reg_05,
    ADC_SANDBOX_32b_reg_06 => ADC_FIX32_16_reg_06,
    ADC_SANDBOX_32b_reg_07 => ADC_FIX32_16_reg_07,
    ADC_SANDBOX_32b_reg_08 => ADC_FIX32_16_reg_08,
    ADC_SANDBOX_32b_reg_09 => ADC_FIX32_16_reg_09,
    ADC_SANDBOX_32b_reg_10 => ADC_FIX32_16_reg_10,
    ADC_SANDBOX_32b_reg_11 => ADC_FIX32_16_reg_11,
    ADC_SANDBOX_32b_reg_12 => ADC_FIX32_16_reg_12,
    ADC_SANDBOX_32b_reg_13 => ADC_FIX32_16_reg_13,
    ADC_SANDBOX_32b_reg_14 => ADC_FIX32_16_reg_14,
    ADC_SANDBOX_32b_reg_15 => ADC_FIX32_16_reg_15,
    ADC_SANDBOX_32b_reg_16 => ADC_FIX32_16_reg_16,
    ADC_SANDBOX_32b_reg_17 => ADC_FIX32_16_reg_17,
    ADC_SANDBOX_32b_reg_18 => ADC_FIX32_16_reg_18,
    ADC_SANDBOX_32b_reg_19 => ADC_FIX32_16_reg_19,
    ADC_SANDBOX_32b_reg_20 => ADC_FIX32_16_reg_20,
    ADC_SANDBOX_32b_reg_21 => ADC_FIX32_16_reg_21,
    ADC_SANDBOX_32b_reg_22 => ADC_FIX32_16_reg_22,
    ADC_SANDBOX_32b_reg_23 => ADC_FIX32_16_reg_23,

    ADC_FLOAT_reg_00 => ADC_FLOAT_reg_00,
    ADC_FLOAT_reg_01 => ADC_FLOAT_reg_01,
    ADC_FLOAT_reg_02 => ADC_FLOAT_reg_02,
    ADC_FLOAT_reg_03 => ADC_FLOAT_reg_03,
    ADC_FLOAT_reg_04 => ADC_FLOAT_reg_04,
    ADC_FLOAT_reg_05 => ADC_FLOAT_reg_05,
    ADC_FLOAT_reg_06 => ADC_FLOAT_reg_06,
    ADC_FLOAT_reg_07 => ADC_FLOAT_reg_07,
    ADC_FLOAT_reg_08 => ADC_FLOAT_reg_08,
    ADC_FLOAT_reg_09 => ADC_FLOAT_reg_09,
    ADC_FLOAT_reg_10 => ADC_FLOAT_reg_10,
    ADC_FLOAT_reg_11 => ADC_FLOAT_reg_11,
    ADC_FLOAT_reg_12 => ADC_FLOAT_reg_12,
    ADC_FLOAT_reg_13 => ADC_FLOAT_reg_13,
    ADC_FLOAT_reg_14 => ADC_FLOAT_reg_14,
    ADC_FLOAT_reg_15 => ADC_FLOAT_reg_15,
    ADC_FLOAT_reg_16 => ADC_FLOAT_reg_16,
    ADC_FLOAT_reg_17 => ADC_FLOAT_reg_17,
    ADC_FLOAT_reg_18 => ADC_FLOAT_reg_18,
    ADC_FLOAT_reg_19 => ADC_FLOAT_reg_19,
    ADC_FLOAT_reg_20 => ADC_FLOAT_reg_20,
    ADC_FLOAT_reg_21 => ADC_FLOAT_reg_21,
    ADC_FLOAT_reg_22 => ADC_FLOAT_reg_22,
    ADC_FLOAT_reg_23 => ADC_FLOAT_reg_23,

    m0_bscan_bscanid_en => BSCAN_bscanid_en,
    m0_bscan_capture    => BSCAN_capture,
    m0_bscan_drck       => BSCAN_drck,
    m0_bscan_reset      => BSCAN_reset,
    m0_bscan_runtest    => BSCAN_runtest,
    m0_bscan_sel        => BSCAN_sel,
    m0_bscan_shift      => BSCAN_shift,
    m0_bscan_tck        => BSCAN_tck,
    m0_bscan_tdi        => BSCAN_tdi,
    m0_bscan_tms        => BSCAN_tms,
    m0_bscan_update     => BSCAN_update,
    m0_bscan_tdo        => BSCAN_tdo,

    adc_done_pulse     => adc_done_pulse,
    adc_done_cpu_pulse => adc_done_cpu_pulse,

    adc_done_float_pulse     => adc_done_float_pulse,
    adc_done_cpu_float_pulse => adc_done_cpu_float_pulse,

    sampling_pulse    => sampling_pulse,
    reading           => reading,
    SBIO_BUS_sb_addr  => SBIO_BUS_sb_addr,
    SBIO_BUS_sb_we    => SBIO_BUS_sb_we,
    SBIO_BUS_sb_wdata => SBIO_BUS_sb_wdata,
    dout              => dout,
    CLOCK_0_clk_en    => CLOCK_0_clk_en,
    CLOCK_0_period    => CLOCK_0_period,
    CLOCK_0_prescaler => CLOCK_0_prescaler,
    CLOCK_0_timer     => CLOCK_0_timer,
    CLOCK_1_clk_en    => CLOCK_1_clk_en,
    CLOCK_1_period    => CLOCK_1_period,
    CLOCK_1_prescaler => CLOCK_1_prescaler,
    CLOCK_1_timer     => CLOCK_1_timer,
    CLOCK_2_clk_en    => CLOCK_2_clk_en,
    CLOCK_2_period    => CLOCK_2_period,
    CLOCK_2_prescaler => CLOCK_2_prescaler,
    CLOCK_2_timer     => CLOCK_2_timer,
    CLOCK_3_clk_en    => CLOCK_3_clk_en,
    CLOCK_3_period    => CLOCK_3_period,
    CLOCK_3_prescaler => CLOCK_3_prescaler,
    CLOCK_3_timer     => CLOCK_3_timer,
    USR_tri_o         => USR_tri_o,
    USR_tri_t         => USR_tri_t,
    private_io        => private_io,
    sb_pwm            => sb_pwm,
    inst_cb_pwm       => inst_cb_pwm,
    inst_pp_pwm       => inst_pp_pwm,
    inst_ss_pwm       => inst_ss_pwm,
    private_in        => i_private_in,
    user_fw_id        => user_fw_id,
    SBIO_BUS_sb_rdata => SBIO_BUS_sb_rdata,
    USR_tri_i         => USR_tri_i,
    din               => din
  );

end stub;