%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Technical Note 151
% Parameters for 'ISOP DAB' system
% Copyright imperix ltd, 2025
% dev@imperix.ch
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% General parameters
fs = 20e3;              % Sampling, interrupt and switching frequency [Hz]
Ts = 1/fs;              % Sampling period [s]
Vdc_grid = 800;         % Voltage of the DC grid [V]
Deadtime = 500e-9;      % Dead time [s]

%% DAB PARAMETERS
Ltot = (47e-6/4)*4;     % power transfer inductance [H]
V1 = Vdc_grid/2;        % primary voltage [V]
n = 1;                  % transformer turn ratio [-]
C_DAB = 0.5e-3*4;       % Capacitance of the DC bus [F]

ramp_duration = 0.05;   % ramp duration [s]
RATE_LIM = 4000;        % Voltage limiter [V/s]

%% DAB VOLTAGE REGULATOR
% SYMMETRICAL OPTIMUM 
Td2 = (1/2 + 1/2 + 1/2)*Ts; % 1/2Ts of control delay, 1/2Ts of modulator delay, 1/2Ts synchronous averaging
K2 = 1;
T2 = C_DAB;
Tdeq = 2*Td2;

a = 6;
Tn2 = a^2*Tdeq;
Ti2 = a^3*K2*Tdeq^2/T2;

Kp_DAB = (Tn2/Ti2);
Ki_DAB = (1/Ti2);


