%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Motor testbench parameters
% Used in TN138 'No load test for Motor Testbench'
% Copyright imperix ltd, 2023
% dev@imperix.ch
%
% Revision history:
% 12.05.2022 : first version
% 14.07.2023 : "Res.p" set to 1 pair of poles (instead of 2) following a
%              bug fix in the ACG SDK (>= v3.8.1).
%              Direction of rotation changed to "Clockwise" in the RES
%              block to follow the IEC 60034-8 standard. Motor testbenches
%              shipped prior to July 2023 were physically wired with the
%              reverse convention (a clockwise rotation of the shaft would
%              decrease the position angle).
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% =================== System parameters ======================== %%

ControlFreq    = 20e3;              % Control interrupt frequency [Hz]
ControlPeriod  = 1/ControlFreq;     % Control interrupt period [s]
SamplingPeriod = ControlPeriod;     % Sampling period [s]

% Deadtime
dt = 500e-9;

%% =================== Motor parameters ======================== %%

% Induction machine (IM)
% SEW Eurodrive DRN112M4
IM.p = 2;               % Nb of pole pair [-]
IM.Usn = 230;           % Rated phase voltage [V]
IM.Isn = 8.4;           % Rated current [A]
IM.fsn = 50;            % Rated stator frequency [Hz]
IM.wsn = 2*pi*IM.fsn;   % Rated angular frequency [rad/s]
IM.Wrn = 1464;          % Nominal rotor speed [rpm]
IM.Rs = 1.24;           % Stator resistance [Ohm]
IM.Rr = 0.73;           % Rotor resistance [Ohm]
IM.Jm = 0.0178;         % Moment of inertia [kg m^2]
IM.Temn = 26;           % Nominal torque [Nm]

IM.cos_phi = 0.81;      % Power factor [-]
IM.sin_phi = sqrt(1 - IM.cos_phi^2);

IM.Lm = 183e-3;                     % Mutual inductance [H]
IM.Lgs = 11.5e-3;                   % Stator leakage inductance [H]
IM.Lgr = 11.5e-3;                   % Rotor leakage inductance [H]
IM.Ls = IM.Lgs + IM.Lm;             % Stator inductance [H]
IM.Lr = IM.Lgr + IM.Lm;             % Rotor inductance [H] 
IM.Lsigma = IM.Ls - IM.Lm^2/IM.Lr;  % Total leakage inductance [H]

Is_re = IM.Isn*IM.cos_phi;
Is_im = IM.Isn*IM.sin_phi;
Um_re = IM.Usn - IM.Rs*Is_re + IM.wsn*IM.Lgs*Is_im;     % Voltage across Lm (real)
Um_im = -IM.Rs*Is_im - IM.wsn*IM.Lgs*Is_re;             % Voltage across Lm (imaginary)
Um = sqrt(Um_re^2 + Um_im^2);                           % Voltage across Lm (norm)

IM.Idsn = (sqrt(2)*Um) / (IM.wsn*IM.Lm);       % Nominal d-axis current
IM.Psi_d_n = IM.Lm * IM.Idsn;                  % Nominal rotor flux

% Permanent Magnets Synchronous Machine (PMSM)
% SEW Eurodrive CM3C80L
Pmsm.Jm = 40.6e-4;      % Moment of inertia [kg m^2]
Pmsm.Jm_brk = 46.2e-4;  % Inertia of the safety brake [kg m^2]

% Resolver (RH1M built into the CM3C80L)
Res.p = 1;              % Pole pairs [-]

% DC Link initial conditions
DcLink.Vdc0 = 800;      % Initial DC bus voltage [V]


%% ======================= IM - V/f control =========================== %%

Vf.Vmin = 0.1 * IM.Usn;                 % Minimal voltage [V]
Vf.f_min = IM.fsn * Vf.Vmin/IM.Usn;     % Minimal frequency [Hz]

% Filter derivative of the mechanical angle
Speed.fc = 200;
