%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Parameters for the 'Single-phase PV Inverter' system
% Copyright imperix ltd, 2025
% support@imperix.ch
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% SYSTEM PARAMETERS
SwitchingFreq = 20e3;           % Switching frequency [Hz]
MPPTPERIOD = 1/0.2e3;           % MPP tracking is at 1 kHz
Deadtime = 700e-9;              % Deadtime [s]

ControlFreq = SwitchingFreq;    % Control frequency [Hz]
ControlPeriod = 1/ControlFreq;  % Control period [s]
CTRLPERIOD = ControlPeriod;

%% PLANT PARAMETERS
Vpvmin = 0.1;                   % Lower treshold solar panel voltage
Vpvmax = 74;                    % Upper treshold solar panel voltage

wmin = 307;                     % Lower treshold grid angular frequency
wmax = 320;                     % Upper treshold grid angular frequency

Vg_rect_min = 1;                % Lower treshold grid voltage detection

Rpv = 8;                        % Parallel equivalent resistance of the PV [Ohm]
Rs = 0.5;                       % Serial equivalent resistance of the PV [Ohm]

Isc = 13;                       % Short-circuit current (PV panel)
Voc = 74;                       % Open-circuit voltage (PV panel)

%DC bus
Vdc0   = 750;                   % Initial DC bus voltage [V]

% Grid
GridFreq = 50;                  % Grid frequency [Hz]
Vg = 230;%230;                  % RMS Grid voltage [V]

Cdc = 3*500e-6;                 % Additional DC link capacitor [F]
Lg = 2.2e-3;                    % AC-side inductor (grid) [H]
Rg = 29e-3;                     % ESR of the AC-side inductor (grid) [Ohm]

Lb = 2.2e-3;                    % DC-side inductor (boost) [H]
Rb = 29e-3;                     % ESR of the DC-side inductor (boost) [Ohm]
Rp = 47;                        % Grid precharge resistance [ohm]

%% Controllers
% BOOST CURRENT REGULATOR -------------------------------------------------
K1 = 1/Rb;
T1 = Lb/Rb;

Td1 = CTRLPERIOD;

Tn1 = T1;
Ti1 = 2*K1*Td1;

Kp_Ipv = Tn1/Ti1; %15;
Ki_Ipv = 1/Ti1; % 1500;

% BOOST CASCADED VOLTAGE REGULATOR ----------------------------------------
K2 = 1;
T2 = Cdc;
Tdeq = 2*Td1;

a = 10;
Tn2 = a^2*Tdeq;
Ti2 = a^3*K2*Tdeq^2/T2;

Kp_Vdc = (Tn2/Ti2);
Ki_Vdc = (1/Ti2);

% INVERTER CURRENT REGULATOR ----------------------------------------------
Td3 = CTRLPERIOD;

K3 = 1/Rg;
T3 = Lg/Rg;

Tn3 = T3;
Ti3 = 2*K3*Td3;

Kp_Ig = Tn3/Ti3;
Ki_Ig = 1/Ti3;