%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Application Note AN010
% Parameters for 'Onboard battery charger'
% Copyright Adeel Jamal - Independent contractor, 2025
% Authorised for publication on the imperix knowledge base
% For any questions: support@imperix.ch
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% =================== System parameters ======================== %%

ControlFreq    = 50e3;              % control interrupt frequency [Hz]
ControlPeriod  = 1/ControlFreq;     % control interrupt period [s]

% Deadtime
dt_80040 = 300e-9;                   % module deadtime [s]

% Transformer magnetization
charge_time = 3;                    % transformer precharge time [s]

%% =================== Plant model ======================== %%

% Totem-pole rectifier inductance
Ltotem = 2.2e-3;

% Resonant tank parameters
Lr = 21e-6;                         % resonant inductance [H]
Cr = 110e-9;                        % resonant capacitance [F]
Lm = 90e-6;                         % magnetizing inductance [H]
n  = 8/9;                           % turns ratio (Np/Ns) [-]

Llk_s = 2e-6;                       % secondary leakage inductance [H]


% Module capacitance
C_80040 = 600e-6;                    % PEB 8024 module capacitance [F]

% Voltage sources
Vg   = 230;                         % input voltage [Vrms]
fg   = 50;                          % grid frequency [Hz]
Vload = 400;                        % load (battery) voltage [V]

%% =============== PI - DC bus voltage controller ================= %%
Vdc_ref = 340;                      % bus voltage setpoint [V]

Id_sat_hi = 14*sqrt(2);
Id_sat_lo = -14*sqrt(2);

% PIR gain coefficients
kp_vdc = 0.08;                      % proportional gain [-]
ki_vdc = 1;                         % integral gain [-]

%% =============== PR - Grid current controller ================= %%

% PIR gain coefficients
kp_ig = 15;                         % proportional gain [-]
kr_ig = 350;                        % resonant gain [-]

%% =============== PIR - Load Current control ================= %%

% PIR gain coefficients
kp_llc = 0.008;                     % proportional gain [-]
ki_llc = 1;                         % integral gain [-]
kr100_llc = 0.1;                    % resonant gain [-]
kr50_llc = 0;                       % resonant gain [-]

% Frequency limits (to remain in ZVS)
freq_lim  = [75 200]*1e3;           % upper and lower frequency limits [Hz]
freq_lim2 = [75 200]*1e-2; 

% PIR initialisation
if SIMULINK_MODE == 1               % if in code generation mode
    fs_init = 1.4;                    % initial switching frequency [-]
else                                % if in simulation mode
    fs_init = 1.0;                    % initial switching frequency [-]
end
