%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Product Note PN173
% Parameters for the 'Interelaved boost converter' system
% Copyright imperix ltd, 2025
% support@imperix.ch
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% PARAMETERS
ControlFreq = 20e3;     % Sampling, interrupt and switching frequency [Hz]
Ts = 1/ControlFreq;     % Sampling period [s]
Deadtime = 700e-9;      % Dead time [s]

%% BOOST PARAMETERS
n = 3;                  % Number of interleaved legs
Lb = 2.2e-3;            % Inductance used for the boost [H]
Rb = 29e-3;             % Resistance of the inductor used for the boost [Ohm]
C = n*500e-6;           % Capacitance of the DC bus [F]

Vb = 100;                % Voltage of the DC source [V]
Rload = 500;             % Resistor load [Ohm]

%% BOOST CURRENT REGULATOR -------------------------------------------------
% MAGNITUD OPTIMUM
K1 = 1/Rb;
T1 = Lb/Rb;

Td1 = (1/2 + 1/2 + 1/2)*Ts; % 1/2Ts of control delay, 1/2Ts of modulator delay, 1/2Ts synchronous averaging

Tn1 = T1;
Ti1 = 2*K1*Td1;

Kp_boost = (Tn1/Ti1);
Ki_boost = (1/Ti1);

% BOOST CASCADED VOLTAGE REGULATOR ----------------------------------------
T2 = C;
Tdeq = 2*Td1;

a = 14;
Tn2 = a^2*Tdeq;
Ti2 = a^3*Tdeq^2/T2;

Kp_dc = Tn2/Ti2;
Ki_dc = 1/Ti2;


