%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Product Note PN171
% Parameters for the 'Power Electronics bundle - Quick start guide' system
% Copyright imperix ltd, 2025
% support@imperix.ch
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%% PARAMETERS
ControlFreq = 20e3;     % Sampling, interrupt and switching frequency [Hz]
Ts = 1/ControlFreq;     % Sampling period [s]
Deadtime = 700e-9;      % Dead time [s]

%% BOOST PARAMETERS
n = 3;                  % Number of interleaved legs
Lb = 2.2e-3;            % Inductance used for the boost [H]
Rb = 29e-3;             % Resistance of the inductor used for the boost [Ohm]
C = (3+n)*500e-6;       % Capacitance of the DC bus [F]
Lg = 2.2e-3;            % Inductance used for the inverter [H]
Rg = 29e-3;            % Inductance used for the grid connection [Ohm]

Vb = 100;               % Voltage of the DC source [V]
Rload = 11.5;             % Resistor load [Ohm]
GridFreq = 50; 			% Grid frequency [Hz]

%% BOOST CURRENT REGULATOR -------------------------------------------------
% MAGNITUD OPTIMUM
K1 = 1/Rb;
T1 = Lb/Rb;

Td1 = (1/2 + 1/2 + 1/2)*Ts; % 1/2Ts of control delay, 1/2Ts of modulator delay, 1/2Ts synchronous averaging

Tn1 = T1;
Ti1 = 2*K1*Td1;

Kp_boost = (Tn1/Ti1);
Ki_boost = (1/Ti1);

%% INVERTER CURRENT REGULATOR -------------------------------------------------
% MAGNITUD OPTIMUM
K2 = 1/Rload;
T2 = Lg/Rload;

Td2 = (1/2 + 1/2 + 1/2)*Ts; % 1/2Ts of control delay, 1/2Ts of modulator delay, 1/2Ts synchronous averaging

Tn2 = T2;
Ti2 = 2*K2*Td2;

Kp_Ig = (Tn2/Ti2);
Ki_Ig = (1/Ti2);

%% CASCADED VOLTAGE REGULATOR ----------------------------------------
T2 = C;
Tdeq = 2*Td1;

a = 14;
Tn2 = a^2*Tdeq;
Ti2 = a^3*Tdeq^2/T2;

Kp_dc = Tn2/Ti2;
Ki_dc = 1/Ti2;




