%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Product Note PN170
% Parameters for the 'Three phase inverter' system
% Copyright imperix ltd, 2025
% support@imperix.ch
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%% PARAMETERS
ControlFreq = 20e3;     % Sampling, interrupt and switching frequency [Hz]
Ts = 1/ControlFreq;     % Sampling period [s]
Deadtime = 700e-9;      % Dead time [s]

%% THREE-PHASE INVERTER PARAMETERS
Lg = 2.2e-3;              % Inductance used for the inverter [H]
Rg = 29e-3;               % Inductance used for the grid connection [Ohm]
C = 500e-6;               % Capacitance of the DC bus [F]

Vdc = 800; %200;for OL    % Voltage of the DC source [V]
Rload = 11.5;             % Resistor load [Ohm]
GridFreq = 50; 			  % Grid frequency [Hz]

%% INVERTER CURRENT REGULATOR -------------------------------------------------
% MAGNITUD OPTIMUM
K1 = 1/Rload;
T1 = Lg/Rload;

Td1 = (1/2 + 1/2 + 1/2)*Ts; % 1/2Ts of control delay, 1/2Ts of modulator delay, 1/2Ts synchronous averaging

Tn1 = T1;
Ti1 = 2*K1*Td1;

Kp_Ig = (Tn1/Ti1);
Ki_Ig = (1/Ti1);



