
if { $argc != 1 } {
	puts "The script requires the project name to be set as an argument."	
} else {

	# ====================================================================================
	# The following TCL commands are common to all imperix projects
	# ====================================================================================

	start_gui
	
	set proj_name [lindex $argv 0]
	set script_path [ file dirname [ file normalize [ info script ] ] ]
	set vivado_dir_path ../vivado
	set ip_repo_dir_path ../ix_repo
	set hdl_dir_path ../hdl
	set constraint_dir_path ../constraints

	create_project $proj_name $vivado_dir_path/$proj_name -part xc7z030fbg676-3

	set_property target_language VHDL [current_project]
	
	# Work-around suggested by Xilinx to avoid the following inconsequential critical warning
	# [Memdata 28-165] The reference name: top_i_ip_m_blk_mem_gen_0 was not found in a previous reference definition. Either the bmm file or the bmm_info_* properties are malformed, therefore BRAM INIT strings can not be populated.
	# Source: https://support.xilinx.com/s/article/59639?language=en_US
	set_param memdata.disableAnnotatedBMM 1
	set_param memdata.disableBRAMInitStrings 1
	set_param memdata.ignoreEmbeddedBMMProperties 1

	set_property ip_repo_paths $ip_repo_dir_path [current_project]
	update_ip_catalog

	create_bd_design "top"

	create_bd_cell -type ip -vlnv imperix.ch:ix:IXIP:3.10 IXIP_0
	set_property name IXIP [get_bd_cells IXIP_0]

	add_files -fileset constrs_1 -norecurse $constraint_dir_path/sandbox_pins_3.10rev1.xdc

	make_bd_intf_pins_external [get_bd_intf_pins IXIP/FIXED_IO]
	make_bd_intf_pins_external [get_bd_intf_pins IXIP/DDR]
	make_bd_intf_pins_external [get_bd_intf_pins IXIP/BBOX]
	make_bd_intf_pins_external [get_bd_intf_pins IXIP/USR]

	set_property name FIXED_IO [get_bd_intf_ports FIXED_IO_0]
	set_property name DDR [get_bd_intf_ports DDR_0]
	set_property name BBOX [get_bd_intf_ports BBOX_0]
	set_property name USR [get_bd_intf_ports USR_0]

	make_bd_pins_external [get_bd_pins IXIP/private_out]
	make_bd_pins_external [get_bd_pins IXIP/pwm]
	make_bd_pins_external [get_bd_pins IXIP/gpo]
	make_bd_pins_external [get_bd_pins IXIP/private_in]
	make_bd_pins_external [get_bd_pins IXIP/flt]
	make_bd_pins_external [get_bd_pins IXIP/gpi]

	set_property name private_out [get_bd_ports private_out_0]
	set_property name pwm [get_bd_ports pwm_0]
	set_property name gpo [get_bd_ports gpo_0]
	set_property name private_in [get_bd_ports private_in_0]
	set_property name flt [get_bd_ports flt_0]
	set_property name gpi [get_bd_ports gpi_0]

	create_bd_cell -type ip -vlnv xilinx.com:ip:xlconstant:1.1 xlconstant_0
	set_property name USER_ID [get_bd_cells xlconstant_0]
	set_property -dict [list CONFIG.CONST_WIDTH {16}] [get_bd_cells USER_ID]
	set_property -dict [list CONFIG.CONST_VAL {1}] [get_bd_cells USER_ID]
	connect_bd_net [get_bd_pins USER_ID/dout] [get_bd_pins IXIP/user_fw_id]

	make_wrapper -files [get_files $vivado_dir_path/$proj_name/$proj_name.srcs/sources_1/bd/top/top.bd] -top
	import_files -force -norecurse $vivado_dir_path/$proj_name/$proj_name.gen/sources_1/bd/top/hdl/top_wrapper.vhd

	# ====================================================================================
	# START of the project-specific TCL commands
	# ====================================================================================

	# Copy constraints file in the current project

	import_files -fileset constrs_1 $constraint_dir_path/sandbox_pins_3.10rev1.xdc

	# Add source files to the project (VHDL)

	add_files -norecurse $hdl_dir_path/convert_16b_to_32b.vhd
	add_files -norecurse $hdl_dir_path/convert_32b_to_16b.vhd
	add_files -norecurse $hdl_dir_path/latcher.vhd
	add_files -norecurse $hdl_dir_path/sbio_256_registers.vhd
	add_files -norecurse $hdl_dir_path/aurora_ix_opalrt_driver.vhd

	update_compile_order -fileset sources_1

	# Add modules/IPs to the block diagram + configuration

	create_bd_cell -type module -reference sbio_256_registers sbio_256_registers_0
	create_bd_cell -type module -reference convert_16b_to_32b convert_16b_to_32b_0
	create_bd_cell -type module -reference convert_32b_to_16b convert_32b_to_16b_0
	create_bd_cell -type module -reference latcher latcher_0
	create_bd_cell -type module -reference aurora_ix_opalrt_driver aurora_ix_opalrt_driver_0

	create_bd_cell -type ip -vlnv xilinx.com:ip:aurora_8b10b:11.1 aurora_8b10b_0
	set_property -dict [list CONFIG.C_LANE_WIDTH {4} CONFIG.C_LINE_RATE {5} CONFIG.C_REFCLK_FREQUENCY {250.000} CONFIG.C_USE_CRC {true} CONFIG.C_USE_BYTESWAP {true}] [get_bd_cells aurora_8b10b_0]

	create_bd_cell -type ip -vlnv xilinx.com:ip:axis_data_fifo:2.0 axis_data_fifo_0
	set_property -dict [list CONFIG.FIFO_DEPTH {64} CONFIG.IS_ACLK_ASYNC {1}] [get_bd_cells axis_data_fifo_0]

	create_bd_cell -type ip -vlnv xilinx.com:ip:axis_data_fifo:2.0 axis_data_fifo_1
	set_property -dict [list CONFIG.FIFO_DEPTH {16} CONFIG.IS_ACLK_ASYNC {1}] [get_bd_cells axis_data_fifo_1]

	create_bd_cell -type ip -vlnv xilinx.com:ip:util_ds_buf:2.2 util_ds_buf_0
	set_property -dict [list CONFIG.C_BUF_TYPE {BUFG}] [get_bd_cells util_ds_buf_0]

	create_bd_cell -type ip -vlnv xilinx.com:ip:util_vector_logic:2.0 util_vector_logic_0
	set_property -dict [list CONFIG.C_SIZE {1} CONFIG.C_OPERATION {not} CONFIG.LOGO_FILE {data/sym_notgate.png}] [get_bd_cells util_vector_logic_0]

	# Configure the imperix firmware IP

	set_property -dict [list CONFIG.SB_GT_SFP_0 {true}] [get_bd_cells IXIP]

	# Make connections

	connect_bd_intf_net [get_bd_intf_pins IXIP/SBIO_BUS] [get_bd_intf_pins sbio_256_registers_0/SBIO_BUS]

	connect_bd_intf_net [get_bd_intf_pins sbio_256_registers_0/SBO] [get_bd_intf_pins convert_16b_to_32b_0/din]
	connect_bd_net [get_bd_pins sbio_256_registers_0/SBO_reg_255] [get_bd_pins aurora_ix_opalrt_driver_0/tx_n_signals]

	connect_bd_intf_net [get_bd_intf_pins convert_32b_to_16b_0/dout] [get_bd_intf_pins latcher_0/din]
	connect_bd_intf_net [get_bd_intf_pins latcher_0/dout] [get_bd_intf_pins sbio_256_registers_0/SBI]
	connect_bd_net [get_bd_pins aurora_ix_opalrt_driver_0/rx_n_signals] [get_bd_pins latcher_0/din_255]

	connect_bd_intf_net [get_bd_intf_pins convert_16b_to_32b_0/dout] [get_bd_intf_pins aurora_ix_opalrt_driver_0/TX_SIGNALS]
	connect_bd_intf_net [get_bd_intf_pins aurora_ix_opalrt_driver_0/RX_SIGNALS] [get_bd_intf_pins convert_32b_to_16b_0/din]

	connect_bd_net [get_bd_pins IXIP/GT_gt0_qplllock] [get_bd_pins aurora_8b10b_0/gt0_qplllock_in]
	connect_bd_net [get_bd_pins IXIP/GT_gt0_qpllrefclklost] [get_bd_pins aurora_8b10b_0/gt0_qpllrefclklost_in]
	connect_bd_net [get_bd_pins IXIP/GT_gt_qpllclk_quad1] [get_bd_pins aurora_8b10b_0/gt_qpllclk_quad1_in]
	connect_bd_net [get_bd_pins IXIP/GT_gt_qpllrefclk_quad1] [get_bd_pins aurora_8b10b_0/gt_qpllrefclk_quad1_in]
	connect_bd_net [get_bd_pins IXIP/GT_gt_refclk1] [get_bd_pins aurora_8b10b_0/gt_refclk1]

	connect_bd_net [get_bd_pins IXIP/rxn_0] [get_bd_pins aurora_8b10b_0/rxn]
	connect_bd_net [get_bd_pins IXIP/rxp_0] [get_bd_pins aurora_8b10b_0/rxp]
	connect_bd_net [get_bd_pins IXIP/txn_0] [get_bd_pins aurora_8b10b_0/txn]
	connect_bd_net [get_bd_pins IXIP/txp_0] [get_bd_pins aurora_8b10b_0/txp]

	connect_bd_net [get_bd_pins IXIP/reading] [get_bd_pins latcher_0/reading]

	connect_bd_net [get_bd_pins IXIP/clk_50_mhz] [get_bd_pins aurora_8b10b_0/drpclk_in]
	connect_bd_net [get_bd_pins IXIP/clk_50_mhz] [get_bd_pins aurora_8b10b_0/init_clk_in]

	connect_bd_intf_net [get_bd_intf_pins aurora_ix_opalrt_driver_0/M_AXIS_TX] [get_bd_intf_pins axis_data_fifo_0/S_AXIS]
	connect_bd_intf_net [get_bd_intf_pins axis_data_fifo_0/M_AXIS] [get_bd_intf_pins aurora_8b10b_0/USER_DATA_S_AXI_TX]

	connect_bd_intf_net [get_bd_intf_pins aurora_8b10b_0/USER_DATA_M_AXI_RX] [get_bd_intf_pins axis_data_fifo_1/S_AXIS]
	connect_bd_intf_net [get_bd_intf_pins axis_data_fifo_1/M_AXIS] [get_bd_intf_pins aurora_ix_opalrt_driver_0/S_AXIS_RX]

	connect_bd_net [get_bd_pins aurora_8b10b_0/tx_out_clk] [get_bd_pins util_ds_buf_0/BUFG_I]
	connect_bd_net [get_bd_pins util_ds_buf_0/BUFG_O] [get_bd_pins axis_data_fifo_0/m_axis_aclk]
	connect_bd_net [get_bd_pins util_ds_buf_0/BUFG_O] [get_bd_pins axis_data_fifo_1/s_axis_aclk]
	connect_bd_net [get_bd_pins util_ds_buf_0/BUFG_O] [get_bd_pins aurora_8b10b_0/user_clk]
	connect_bd_net [get_bd_pins util_ds_buf_0/BUFG_O] [get_bd_pins aurora_8b10b_0/sync_clk]

	connect_bd_net [get_bd_pins IXIP/sync_pulse] [get_bd_pins aurora_ix_opalrt_driver_0/reset]
	connect_bd_net [get_bd_pins IXIP/sync_pulse] [get_bd_pins util_vector_logic_0/Op1]

	connect_bd_net [get_bd_pins util_vector_logic_0/Res] [get_bd_pins axis_data_fifo_0/s_axis_aresetn]
	connect_bd_net [get_bd_pins util_vector_logic_0/Res] [get_bd_pins axis_data_fifo_1/s_axis_aresetn]

	connect_bd_net [get_bd_pins IXIP/clk_250_mhz] [get_bd_pins sbio_256_registers_0/clk]
	connect_bd_net [get_bd_pins IXIP/clk_250_mhz] [get_bd_pins aurora_ix_opalrt_driver_0/clk_250_mhz]
	connect_bd_net [get_bd_pins IXIP/clk_250_mhz] [get_bd_pins axis_data_fifo_0/s_axis_aclk]
	connect_bd_net [get_bd_pins IXIP/clk_250_mhz] [get_bd_pins axis_data_fifo_1/m_axis_aclk]
	connect_bd_net [get_bd_pins IXIP/clk_250_mhz] [get_bd_pins latcher_0/clk]

	connect_bd_net [get_bd_pins aurora_ix_opalrt_driver_0/tx_trigger] [get_bd_pins IXIP/data_valid_pulse]

	# ====================================================================================
	# END of the project-specific TCL commands
	# ====================================================================================

	regenerate_bd_layout
	save_bd_design

}