%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                         %
%           Initialisation File for the Technical Note: 179               %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Parameters for 'Data-driven control of three-phase inverter' 
% Copyrights Adeel Jamal, 2026
% dev@imperix.ch
% Created: January 2026
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% SYSTEM PARAMETERS

SwitchingFreq = 20e3;           % Switching frequency [Hz]
ConfigblockFreq = 20e3;         % For configuration block
dead_time = 124e-9;             % For TPI8032 
ControlFreq = SwitchingFreq;    % Control frequency [Hz]
ControlPeriod = 1/ControlFreq;  % Control period [s]
SamplingPhase = 0.5;            % Sampling phase [-]

%% DC Link PARAMETERS
Vdc0 = 700;                     % Initial DC voltage [V]
Lg = 0.95e-3;                   % TPI main inductor value [H]
Rg = 54e-3;                     % Series equivalent resistance of Lg [ohm]
Cdc = 1.5e-3;                   % DC bus capacitance [F]

%% AC Grid PARAMETERS
Vg = 230*sqrt(3);                       % RMS Grid voltage [V]
Freq = 50;                      % Grid frequency [Hz]
Ln = 10e-6;                    % Grid Inductance [H]
Rn = 1e-3;                     % Grid Resistance [Ohm]

%% GRID CURRENT CONTROLLER PARAMETERS (DQ)
% Magnitude optimum
K1 = 1/Rg;
T1 = Lg/Rg;
Td1 = (1/2 + 1/2 + 1/2)*ControlPeriod;
Tn1 = T1;
Ti1 = 2*K1*Td1;
KpIg = Tn1/Ti1;
KiIg = 1/Ti1;
