
# Loading additional proc with user specified bodies to compute parameter values.
source [file join [file dirname [file dirname [info script]]] gui/rtbox_aurora_adapter_v1_0.gtcl]

# Definitional proc to organize widgets for parameters.
proc init_gui { IPINST } {
  ipgui::add_param $IPINST -name "Component_Name"
  #Adding Group
  set Test [ipgui::add_group $IPINST -name "Test" -display_name {TX parameters}]
  ipgui::add_param $IPINST -name "C_TX_PAYLOAD_SZ_MODE" -parent ${Test}
  ipgui::add_param $IPINST -name "C_TX_STATIC_PAYLOAD_SZ" -parent ${Test}

  #Adding Group
  set RX_parameters_test [ipgui::add_group $IPINST -name "RX parameters test" -display_name {RX parameters}]
  ipgui::add_param $IPINST -name "C_CRC_FILTER" -parent ${RX_parameters_test}

  #Adding Group
  set Synchronization [ipgui::add_group $IPINST -name "Synchronization"]
  ipgui::add_param $IPINST -name "C_SYNC_INTERFACE" -parent ${Synchronization}


}

proc update_PARAM_VALUE.C_TX_STATIC_PAYLOAD_SZ { PARAM_VALUE.C_TX_STATIC_PAYLOAD_SZ PARAM_VALUE.C_TX_PAYLOAD_SZ_MODE } {
	# Procedure called to update C_TX_STATIC_PAYLOAD_SZ when any of the dependent parameters in the arguments change
	
	set C_TX_STATIC_PAYLOAD_SZ ${PARAM_VALUE.C_TX_STATIC_PAYLOAD_SZ}
	set C_TX_PAYLOAD_SZ_MODE ${PARAM_VALUE.C_TX_PAYLOAD_SZ_MODE}
	set values(C_TX_PAYLOAD_SZ_MODE) [get_property value $C_TX_PAYLOAD_SZ_MODE]
	if { [gen_USERPARAMETER_C_TX_STATIC_PAYLOAD_SZ_ENABLEMENT $values(C_TX_PAYLOAD_SZ_MODE)] } {
		set_property enabled true $C_TX_STATIC_PAYLOAD_SZ
	} else {
		set_property enabled false $C_TX_STATIC_PAYLOAD_SZ
	}
}

proc validate_PARAM_VALUE.C_TX_STATIC_PAYLOAD_SZ { PARAM_VALUE.C_TX_STATIC_PAYLOAD_SZ } {
	# Procedure called to validate C_TX_STATIC_PAYLOAD_SZ
	return true
}

proc update_PARAM_VALUE.C_CRC_FILTER { PARAM_VALUE.C_CRC_FILTER } {
	# Procedure called to update C_CRC_FILTER when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.C_CRC_FILTER { PARAM_VALUE.C_CRC_FILTER } {
	# Procedure called to validate C_CRC_FILTER
	return true
}

proc update_PARAM_VALUE.C_KEEP_SENDING_READY_FLAG { PARAM_VALUE.C_KEEP_SENDING_READY_FLAG } {
	# Procedure called to update C_KEEP_SENDING_READY_FLAG when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.C_KEEP_SENDING_READY_FLAG { PARAM_VALUE.C_KEEP_SENDING_READY_FLAG } {
	# Procedure called to validate C_KEEP_SENDING_READY_FLAG
	return true
}

proc update_PARAM_VALUE.C_SYNC_INTERFACE { PARAM_VALUE.C_SYNC_INTERFACE } {
	# Procedure called to update C_SYNC_INTERFACE when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.C_SYNC_INTERFACE { PARAM_VALUE.C_SYNC_INTERFACE } {
	# Procedure called to validate C_SYNC_INTERFACE
	return true
}

proc update_PARAM_VALUE.C_TX_PAYLOAD_SZ_MODE { PARAM_VALUE.C_TX_PAYLOAD_SZ_MODE } {
	# Procedure called to update C_TX_PAYLOAD_SZ_MODE when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.C_TX_PAYLOAD_SZ_MODE { PARAM_VALUE.C_TX_PAYLOAD_SZ_MODE } {
	# Procedure called to validate C_TX_PAYLOAD_SZ_MODE
	return true
}


proc update_MODELPARAM_VALUE.C_KEEP_SENDING_READY_FLAG { MODELPARAM_VALUE.C_KEEP_SENDING_READY_FLAG PARAM_VALUE.C_KEEP_SENDING_READY_FLAG } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.C_KEEP_SENDING_READY_FLAG}] ${MODELPARAM_VALUE.C_KEEP_SENDING_READY_FLAG}
}

proc update_MODELPARAM_VALUE.C_TX_STATIC_PAYLOAD_SZ { MODELPARAM_VALUE.C_TX_STATIC_PAYLOAD_SZ PARAM_VALUE.C_TX_STATIC_PAYLOAD_SZ } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.C_TX_STATIC_PAYLOAD_SZ}] ${MODELPARAM_VALUE.C_TX_STATIC_PAYLOAD_SZ}
}

proc update_MODELPARAM_VALUE.C_TX_PAYLOAD_SZ_MODE { MODELPARAM_VALUE.C_TX_PAYLOAD_SZ_MODE PARAM_VALUE.C_TX_PAYLOAD_SZ_MODE } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.C_TX_PAYLOAD_SZ_MODE}] ${MODELPARAM_VALUE.C_TX_PAYLOAD_SZ_MODE}
}

proc update_MODELPARAM_VALUE.C_CRC_FILTER { MODELPARAM_VALUE.C_CRC_FILTER PARAM_VALUE.C_CRC_FILTER } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.C_CRC_FILTER}] ${MODELPARAM_VALUE.C_CRC_FILTER}
}

