
if { $argc != 1 } {
	puts "The script requires the project name to be set as an argument."	
} else {

	# ====================================================================================
	# The following TCL commands are common to all imperix projects
	# ====================================================================================

	start_gui
	
	set proj_name [lindex $argv 0]
	set script_path [ file dirname [ file normalize [ info script ] ] ]
	set vivado_dir_path ../vivado
	set ip_repo_dir_path ../ix_repo
	set hdl_dir_path ../hdl
	set constraint_dir_path ../constraints

	create_project $proj_name $vivado_dir_path/$proj_name -part xc7z030fbg676-3

	set_property target_language VHDL [current_project]
	
	# Work-around suggested by Xilinx to avoid the following inconsequential critical warning
	# [Memdata 28-165] The reference name: top_i_ip_m_blk_mem_gen_0 was not found in a previous reference definition. Either the bmm file or the bmm_info_* properties are malformed, therefore BRAM INIT strings can not be populated.
	# Source: https://support.xilinx.com/s/article/59639?language=en_US
	set_param memdata.disableAnnotatedBMM 1
	set_param memdata.disableBRAMInitStrings 1
	set_param memdata.ignoreEmbeddedBMMProperties 1

	set_property ip_repo_paths $ip_repo_dir_path [current_project]
	update_ip_catalog

	create_bd_design "top"

	create_bd_cell -type ip -vlnv imperix.ch:ix:IXIP:3.10 IXIP_0
	set_property name IXIP [get_bd_cells IXIP_0]

	foreach xdc_file [glob -nocomplain $constraint_dir_path/*.xdc] {
		add_files -fileset constrs_1 -norecurse $xdc_file
	}

	make_bd_intf_pins_external [get_bd_intf_pins IXIP/FIXED_IO]
	make_bd_intf_pins_external [get_bd_intf_pins IXIP/DDR]
	make_bd_intf_pins_external [get_bd_intf_pins IXIP/BBOX]
	make_bd_intf_pins_external [get_bd_intf_pins IXIP/USR]

	set_property name FIXED_IO [get_bd_intf_ports FIXED_IO_0]
	set_property name DDR [get_bd_intf_ports DDR_0]
	set_property name BBOX [get_bd_intf_ports BBOX_0]
	set_property name USR [get_bd_intf_ports USR_0]

	make_bd_pins_external [get_bd_pins IXIP/private_out]
	make_bd_pins_external [get_bd_pins IXIP/pwm]
	make_bd_pins_external [get_bd_pins IXIP/gpo]
	make_bd_pins_external [get_bd_pins IXIP/private_in]
	make_bd_pins_external [get_bd_pins IXIP/flt]
	make_bd_pins_external [get_bd_pins IXIP/gpi]

	set_property name private_out [get_bd_ports private_out_0]
	set_property name pwm [get_bd_ports pwm_0]
	set_property name gpo [get_bd_ports gpo_0]
	set_property name private_in [get_bd_ports private_in_0]
	set_property name flt [get_bd_ports flt_0]
	set_property name gpi [get_bd_ports gpi_0]

	create_bd_cell -type ip -vlnv xilinx.com:ip:xlconstant:1.1 xlconstant_0
	set_property name USER_ID [get_bd_cells xlconstant_0]
	set_property -dict [list CONFIG.CONST_WIDTH {16}] [get_bd_cells USER_ID]
	set_property -dict [list CONFIG.CONST_VAL {1}] [get_bd_cells USER_ID]
	connect_bd_net [get_bd_pins USER_ID/dout] [get_bd_pins IXIP/user_fw_id]

	make_wrapper -files [get_files $vivado_dir_path/$proj_name/$proj_name.srcs/sources_1/bd/top/top.bd] -top
	import_files -force -norecurse $vivado_dir_path/$proj_name/$proj_name.gen/sources_1/bd/top/hdl/top_wrapper.vhd

	# ====================================================================================
	# START of the project-specific TCL commands
	# ====================================================================================

	# Add source files to the project (VHDL)

	add_files -norecurse $hdl_dir_path/convert_16b_to_32b.vhd
	add_files -norecurse $hdl_dir_path/convert_32b_to_16b.vhd
	add_files -norecurse $hdl_dir_path/latcher.vhd
	add_files -norecurse $hdl_dir_path/sbio_256_registers.vhd
	add_files -norecurse $hdl_dir_path/aurora_ix_plexim_driver.vhd

	update_compile_order -fileset sources_1

	# Add source files to the project (IPs)

	set_property ip_repo_paths [list $ip_repo_dir_path $hdl_dir_path/rtbox_aurora_adapter] [current_project]
	update_ip_catalog

	# Add modules/IPs to the block diagram + configuration

	create_bd_cell -type module -reference sbio_256_registers sbio_256_registers_0
	create_bd_cell -type module -reference convert_16b_to_32b convert_16b_to_32b_0
	create_bd_cell -type module -reference convert_32b_to_16b convert_32b_to_16b_0
	create_bd_cell -type module -reference latcher latcher_0
	create_bd_cell -type module -reference aurora_ix_plexim_driver aurora_ix_plexim_driver_0
	create_bd_cell -type ip -vlnv xilinx.com:ip:xlconstant:1.1 xlconstant_0
	create_bd_cell -type ip -vlnv xilinx.com:ip:proc_sys_reset:5.0 proc_sys_reset_0

	create_bd_cell -type ip -vlnv xilinx.com:ip:aurora_64b66b:12.0 aurora_64b66b_0
	set_property -dict [list CONFIG.C_LINE_RATE {6.25} CONFIG.C_REFCLK_FREQUENCY {250.000} CONFIG.crc_mode {true}] [get_bd_cells aurora_64b66b_0]

	create_bd_cell -type ip -vlnv xilinx.com:ip:axis_data_fifo:2.0 axis_data_fifo_0
	set_property -dict [list CONFIG.FIFO_DEPTH {64} CONFIG.IS_ACLK_ASYNC {1}] [get_bd_cells axis_data_fifo_0]

	create_bd_cell -type ip -vlnv xilinx.com:ip:axis_data_fifo:2.0 axis_data_fifo_1
	set_property -dict [list CONFIG.FIFO_DEPTH {16} CONFIG.IS_ACLK_ASYNC {1}] [get_bd_cells axis_data_fifo_1]

	create_bd_cell -type ip -vlnv xilinx.com:ip:clk_wiz:6.0 clk_wiz_0
	set_property -dict [list CONFIG.PRIM_IN_FREQ.VALUE_SRC USER] [get_bd_cells clk_wiz_0]
	set_property -dict [list CONFIG.PRIM_SOURCE {Global_buffer} CONFIG.PRIM_IN_FREQ {195.3125} CONFIG.CLKOUT2_USED {true} CONFIG.CLKOUT1_REQUESTED_OUT_FREQ {97.65625} CONFIG.CLKOUT2_REQUESTED_OUT_FREQ {195.3125} CONFIG.USE_LOCKED {false} CONFIG.USE_RESET {false} CONFIG.CLKIN1_JITTER_PS {51.2} CONFIG.MMCM_DIVCLK_DIVIDE {1} CONFIG.MMCM_CLKFBOUT_MULT_F {5.000} CONFIG.MMCM_CLKIN1_PERIOD {5.120} CONFIG.MMCM_CLKIN2_PERIOD {10.0} CONFIG.MMCM_CLKOUT0_DIVIDE_F {10.000} CONFIG.MMCM_CLKOUT1_DIVIDE {5} CONFIG.NUM_OUT_CLKS {2} CONFIG.CLKOUT1_JITTER {113.970} CONFIG.CLKOUT1_PHASE_ERROR {91.276} CONFIG.CLKOUT2_JITTER {99.568} CONFIG.CLKOUT2_PHASE_ERROR {91.276}] [get_bd_cells clk_wiz_0]

	create_bd_cell -type ip -vlnv xilinx.com:ip:util_vector_logic:2.0 util_vector_logic_0
	set_property -dict [list CONFIG.C_SIZE {1} CONFIG.C_OPERATION {not} CONFIG.LOGO_FILE {data/sym_notgate.png}] [get_bd_cells util_vector_logic_0]

	create_bd_cell -type ip -vlnv plexim.com:user:rtbox_aurora_adapter:1.0 rtbox_aurora_adapter_0
	set_property -dict [list CONFIG.C_CRC_FILTER {true} CONFIG.C_TX_PAYLOAD_SZ_MODE {1} CONFIG.C_SYNC_INTERFACE {false}] [get_bd_cells rtbox_aurora_adapter_0]

	# Configure the imperix firmware IP

	set_property -dict [list CONFIG.SB_GT_SFP_0 {true}] [get_bd_cells IXIP]

	# Make connections

	connect_bd_intf_net [get_bd_intf_pins IXIP/SBIO_BUS] [get_bd_intf_pins sbio_256_registers_0/SBIO_BUS]

	connect_bd_intf_net [get_bd_intf_pins sbio_256_registers_0/SBO] [get_bd_intf_pins convert_16b_to_32b_0/din]
	connect_bd_net [get_bd_pins sbio_256_registers_0/SBO_reg_255] [get_bd_pins aurora_ix_plexim_driver_0/tx_n_signals]

	connect_bd_intf_net [get_bd_intf_pins convert_32b_to_16b_0/dout] [get_bd_intf_pins latcher_0/din]
	connect_bd_intf_net [get_bd_intf_pins latcher_0/dout] [get_bd_intf_pins sbio_256_registers_0/SBI]
	connect_bd_net [get_bd_pins aurora_ix_plexim_driver_0/rx_n_signals] [get_bd_pins latcher_0/din_255]

	connect_bd_intf_net [get_bd_intf_pins convert_16b_to_32b_0/dout] [get_bd_intf_pins aurora_ix_plexim_driver_0/TX_SIGNALS]
	connect_bd_intf_net [get_bd_intf_pins aurora_ix_plexim_driver_0/RX_SIGNALS] [get_bd_intf_pins convert_32b_to_16b_0/din]

	connect_bd_net [get_bd_pins proc_sys_reset_0/bus_struct_reset] [get_bd_pins aurora_64b66b_0/pma_init]
	connect_bd_net [get_bd_pins proc_sys_reset_0/peripheral_reset] [get_bd_pins aurora_64b66b_0/reset_pb]

	connect_bd_net [get_bd_pins IXIP/GT_gt_qpllclk_quad1] [get_bd_pins aurora_64b66b_0/gt_qpllclk_quad1_in]
	connect_bd_net [get_bd_pins IXIP/GT_gt_qpllrefclk_quad1] [get_bd_pins aurora_64b66b_0/gt_qpllrefclk_quad1_in]
	connect_bd_net [get_bd_pins IXIP/GT_gt_refclk1] [get_bd_pins aurora_64b66b_0/refclk1_in]

	connect_bd_net [get_bd_pins IXIP/rxn_0] [get_bd_pins aurora_64b66b_0/rxn]
	connect_bd_net [get_bd_pins IXIP/rxp_0] [get_bd_pins aurora_64b66b_0/rxp]
	connect_bd_net [get_bd_pins IXIP/txn_0] [get_bd_pins aurora_64b66b_0/txn]
	connect_bd_net [get_bd_pins IXIP/txp_0] [get_bd_pins aurora_64b66b_0/txp]

	connect_bd_net [get_bd_pins IXIP/reading] [get_bd_pins latcher_0/reading]

	connect_bd_net [get_bd_pins aurora_64b66b_0/tx_out_clk] [get_bd_pins clk_wiz_0/clk_in1]

	connect_bd_net [get_bd_pins clk_wiz_0/clk_out1] [get_bd_pins axis_data_fifo_0/m_axis_aclk]
	connect_bd_net [get_bd_pins clk_wiz_0/clk_out1] [get_bd_pins axis_data_fifo_1/s_axis_aclk]
	connect_bd_net [get_bd_pins clk_wiz_0/clk_out1] [get_bd_pins aurora_64b66b_0/user_clk]
	connect_bd_net [get_bd_pins clk_wiz_0/clk_out1] [get_bd_pins rtbox_aurora_adapter_0/aclk]
	connect_bd_net [get_bd_pins clk_wiz_0/clk_out2] [get_bd_pins aurora_64b66b_0/sync_clk]

	connect_bd_net [get_bd_pins IXIP/clk_50_mhz] [get_bd_pins proc_sys_reset_0/slowest_sync_clk]
	connect_bd_net [get_bd_pins IXIP/clk_50_mhz] [get_bd_pins aurora_64b66b_0/drp_clk_in]
	connect_bd_net [get_bd_pins IXIP/clk_50_mhz] [get_bd_pins aurora_64b66b_0/init_clk]

	connect_bd_intf_net [get_bd_intf_pins aurora_ix_plexim_driver_0/M_AXIS_TX] [get_bd_intf_pins axis_data_fifo_0/S_AXIS]
	connect_bd_intf_net [get_bd_intf_pins axis_data_fifo_0/M_AXIS] [get_bd_intf_pins rtbox_aurora_adapter_0/S_AXIS_TX]
	connect_bd_intf_net [get_bd_intf_pins rtbox_aurora_adapter_0/M_AXIS_RX] [get_bd_intf_pins axis_data_fifo_1/S_AXIS]
	connect_bd_intf_net [get_bd_intf_pins axis_data_fifo_1/M_AXIS] [get_bd_intf_pins aurora_ix_plexim_driver_0/S_AXIS_RX]

	connect_bd_intf_net [get_bd_intf_pins rtbox_aurora_adapter_0/M_AXIS_AURORA_TX] [get_bd_intf_pins aurora_64b66b_0/USER_DATA_S_AXIS_TX]
	connect_bd_intf_net [get_bd_intf_pins rtbox_aurora_adapter_0/S_AXIS_AURORA_RX] [get_bd_intf_pins aurora_64b66b_0/USER_DATA_M_AXIS_RX]
	connect_bd_intf_net [get_bd_intf_pins rtbox_aurora_adapter_0/CORE_STATUS] [get_bd_intf_pins aurora_64b66b_0/CORE_STATUS]

	connect_bd_net [get_bd_pins xlconstant_0/dout] [get_bd_pins rtbox_aurora_adapter_0/aresetn]
	connect_bd_net [get_bd_pins xlconstant_0/dout] [get_bd_pins proc_sys_reset_0/ext_reset_in]
	connect_bd_net [get_bd_pins xlconstant_0/dout] [get_bd_pins proc_sys_reset_0/aux_reset_in]
	connect_bd_net [get_bd_pins xlconstant_0/dout] [get_bd_pins proc_sys_reset_0/dcm_locked]

	connect_bd_net [get_bd_pins IXIP/sync_pulse] [get_bd_pins aurora_ix_plexim_driver_0/reset]
	connect_bd_net [get_bd_pins IXIP/sync_pulse] [get_bd_pins util_vector_logic_0/Op1]

	connect_bd_net [get_bd_pins util_vector_logic_0/Res] [get_bd_pins axis_data_fifo_0/s_axis_aresetn]
	connect_bd_net [get_bd_pins util_vector_logic_0/Res] [get_bd_pins axis_data_fifo_1/s_axis_aresetn]

	connect_bd_net [get_bd_pins IXIP/clk_250_mhz] [get_bd_pins sbio_256_registers_0/clk]
	connect_bd_net [get_bd_pins IXIP/clk_250_mhz] [get_bd_pins aurora_ix_plexim_driver_0/clk_250_mhz]
	connect_bd_net [get_bd_pins IXIP/clk_250_mhz] [get_bd_pins axis_data_fifo_0/s_axis_aclk]
	connect_bd_net [get_bd_pins IXIP/clk_250_mhz] [get_bd_pins axis_data_fifo_1/m_axis_aclk]
	connect_bd_net [get_bd_pins IXIP/clk_250_mhz] [get_bd_pins latcher_0/clk]

	connect_bd_net [get_bd_pins aurora_ix_plexim_driver_0/tx_trigger] [get_bd_pins IXIP/data_valid_pulse]

	# ====================================================================================
	# END of the project-specific TCL commands
	# ====================================================================================

	regenerate_bd_layout
	
	save_bd_design
}