/*
 *	@title	Command Line Interface functions, user interface
 *	@author	imperix Ltd (dev@imperix.ch)
 *	@file	cli_commands.c
 */

#include "DSP28x_Project.h"							                            // Headers for C28346
#include "Core/macros.h"								                        // Global defines and macros
#include "Driver/cli.h"									                        // Command line interface interpreter
#include "user.h"										                        // User-level routines
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

extern USER_STATE current_mode;							                        // Access to the global variable 'opmode'


// Prototype each user function first
void UserFctn1(unsigned int argc, char *argv[]);
void UserFctn2(unsigned int argc, char *argv[]);


void LoadCLIUserFunctions(void)
{
	/* The user-defined functions have to be registered by the command line interpreter before they can be used.
	 * These functions will be mapped in the /user folder in the command line mode.
	 * Use 'cd user' in order to be in this folder before using these commands.
	 */
	fs_mkcmd_user("mycmd1", UserFctn1);					                        // Links the "mycmd1" prompt text to the corresponding function
	fs_mkcmd_user("mycmd2", UserFctn2);					                        // Links the "mycmd1" prompt text to the corresponding function
}


void UserFctn1(unsigned int argc, char *argv[])
{
	printf("\nThis is a test function.");
}


void UserFctn2(unsigned int argc, char *argv[])
{
	printf("\nThis is a test function.");
	printf("\nThe command contains %u arguments (argc).", (unsigned int) argc);
	unsigned int i = 0;
	while (i<argc)
	{
		printf("\nArg. %u = %s", i, argv[i]);
		if (++i > ARGC_MAX) break;                                              // ARGC_MAX is the highest number of arguments passed by the interpreter
	}
}
