#ifndef USER_H_
#define USER_H_


#include "DSP28x_Project.h"								                        // Headers for C28346
#include "extern_user.h"								                        // Corresponding pre-compiled header


/**
 * Pre-computed general constants
 */
#define PI 					3.141592654
#define TWOPI 				6.283185307
#define TWOPI_OVER_THREE 	2.094395103
#define SQRT3 				1.732050808
#define SQRT2 				1.414213562



/**
 * Readability helpers
 */
#define FREQGEN0			(0)
#define FREQGEN1			(1)
#define FREQGEN2			(2)
#define FREQGEN3			(3)

#define BBOX0				(0)
#define BBOX1				(1)
#define BBOX2				(2)


/**
 * Time-related definitions
 */
#define SWITCHING_FREQUENCY	(1e3)						                        // Apparent switching frequency
#define SWITCHING_PERIOD	(1/SWITCHING_FREQUENCY)		                        // Switching period
#define SAMPLING_PERIOD		(1/SWITCHING_FREQUENCY)		                        // Sampling and control period (dsp)
#define SAMPLING_PERIOD_US	(1/SWITCHING_FREQUENCY*1e6)	                        // Same thing in microseconds...
#define FPGA_CLK_PERIOD		(33.33e-9)					                        // 30Mhz -> 33.3ns


/**
 * Modes of operation for the user-level application
 * These definitions apply to the user state machine
 */
typedef enum {
	STANDBY =0,
	STARTUP =1,
	NORMAL =2,
	SHUTDOWN =3,
	EMERGENCY =4
} USER_STATE ;


/**
 * First user-level interrupt service routine.
 * Remember that it has the highest level of priority when mapped to Ext1, intermediate when
 * mapped to Ext2 and lowest when mapped to the CPU Timer.
 * @param	void	no parameters
 * @return 			SAFE or UNSAFE depending on whether the user wants to trigger the blocking of the application or not
 */
USER_SAFE UserInterrupt1(void);


/**
 * First user-level interrupt service routine.
 * Remember that it has the highest level of priority when mapped to Ext1, intermediate when
 * mapped to Ext2 and lowest when mapped to the CPU Timer.
 * @param	void	no parameters
 * @return 			SAFE or UNSAFE depending on whether the user wants to trigger the blocking of the application or not
 */
USER_SAFE UserInterrupt2(void);


/**
 * The following prototypes are already defined in the pre-compiled library (extern_user.h)
 * They do not need to be specified here
 */
// USER_SAFE UserInit(void)
// void UserError(int code);


#endif /* USER_H_ */
