library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;

entity ix_axis_interface is
    Generic (
		INITIAL_TS : natural := 50000
	);
	Port (
		------------------------------------------------------------------------
		-- INTERFACE WITH USER FPGA LOGIC
		------------------------------------------------------------------------

		-- ADC outputs

		M_AXIS_ADC_00_tdata  : out std_logic_vector(15 downto 0);
		M_AXIS_ADC_00_tready : in std_logic;
		M_AXIS_ADC_00_tvalid : out std_logic;

		M_AXIS_ADC_01_tdata  : out std_logic_vector(15 downto 0);
		M_AXIS_ADC_01_tready : in std_logic;
		M_AXIS_ADC_01_tvalid : out std_logic;

		M_AXIS_ADC_02_tdata  : out std_logic_vector(15 downto 0);
		M_AXIS_ADC_02_tready : in std_logic;
		M_AXIS_ADC_02_tvalid : out std_logic;

		M_AXIS_ADC_03_tdata  : out std_logic_vector(15 downto 0);
		M_AXIS_ADC_03_tready : in std_logic;
		M_AXIS_ADC_03_tvalid : out std_logic;

		M_AXIS_ADC_04_tdata  : out std_logic_vector(15 downto 0);
		M_AXIS_ADC_04_tready : in std_logic;
		M_AXIS_ADC_04_tvalid : out std_logic;

		M_AXIS_ADC_05_tdata  : out std_logic_vector(15 downto 0);
		M_AXIS_ADC_05_tready : in std_logic;
		M_AXIS_ADC_05_tvalid : out std_logic;

		M_AXIS_ADC_06_tdata  : out std_logic_vector(15 downto 0);
		M_AXIS_ADC_06_tready : in std_logic;
		M_AXIS_ADC_06_tvalid : out std_logic;

		M_AXIS_ADC_07_tdata  : out std_logic_vector(15 downto 0);
		M_AXIS_ADC_07_tready : in std_logic;
		M_AXIS_ADC_07_tvalid : out std_logic;

		M_AXIS_ADC_08_tdata  : out std_logic_vector(15 downto 0);
		M_AXIS_ADC_08_tready : in std_logic;
		M_AXIS_ADC_08_tvalid : out std_logic;

		M_AXIS_ADC_09_tdata  : out std_logic_vector(15 downto 0);
		M_AXIS_ADC_09_tready : in std_logic;
		M_AXIS_ADC_09_tvalid : out std_logic;

		M_AXIS_ADC_10_tdata  : out std_logic_vector(15 downto 0);
		M_AXIS_ADC_10_tready : in std_logic;
		M_AXIS_ADC_10_tvalid : out std_logic;

		M_AXIS_ADC_11_tdata  : out std_logic_vector(15 downto 0);
		M_AXIS_ADC_11_tready : in std_logic;
		M_AXIS_ADC_11_tvalid : out std_logic;

		M_AXIS_ADC_12_tdata  : out std_logic_vector(15 downto 0);
		M_AXIS_ADC_12_tready : in std_logic;
		M_AXIS_ADC_12_tvalid : out std_logic;

		M_AXIS_ADC_13_tdata  : out std_logic_vector(15 downto 0);
		M_AXIS_ADC_13_tready : in std_logic;
		M_AXIS_ADC_13_tvalid : out std_logic;

		M_AXIS_ADC_14_tdata  : out std_logic_vector(15 downto 0);
		M_AXIS_ADC_14_tready : in std_logic;
		M_AXIS_ADC_14_tvalid : out std_logic;

		M_AXIS_ADC_15_tdata  : out std_logic_vector(15 downto 0);
		M_AXIS_ADC_15_tready : in std_logic;
		M_AXIS_ADC_15_tvalid : out std_logic;

		-- CPU to FPGA outputs

		M_AXIS_CPU2FPGA_00_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_00_tready : in std_logic;
		M_AXIS_CPU2FPGA_00_tvalid : out std_logic;

		M_AXIS_CPU2FPGA_01_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_01_tready : in std_logic;
		M_AXIS_CPU2FPGA_01_tvalid : out std_logic;

		M_AXIS_CPU2FPGA_02_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_02_tready : in std_logic;
		M_AXIS_CPU2FPGA_02_tvalid : out std_logic;

		M_AXIS_CPU2FPGA_03_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_03_tready : in std_logic;
		M_AXIS_CPU2FPGA_03_tvalid : out std_logic;

		M_AXIS_CPU2FPGA_04_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_04_tready : in std_logic;
		M_AXIS_CPU2FPGA_04_tvalid : out std_logic;

		M_AXIS_CPU2FPGA_05_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_05_tready : in std_logic;
		M_AXIS_CPU2FPGA_05_tvalid : out std_logic;

		M_AXIS_CPU2FPGA_06_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_06_tready : in std_logic;
		M_AXIS_CPU2FPGA_06_tvalid : out std_logic;

		M_AXIS_CPU2FPGA_07_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_07_tready : in std_logic;
		M_AXIS_CPU2FPGA_07_tvalid : out std_logic;

		M_AXIS_CPU2FPGA_08_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_08_tready : in std_logic;
		M_AXIS_CPU2FPGA_08_tvalid : out std_logic;

		M_AXIS_CPU2FPGA_09_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_09_tready : in std_logic;
		M_AXIS_CPU2FPGA_09_tvalid : out std_logic;

		M_AXIS_CPU2FPGA_10_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_10_tready : in std_logic;
		M_AXIS_CPU2FPGA_10_tvalid : out std_logic;

		M_AXIS_CPU2FPGA_11_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_11_tready : in std_logic;
		M_AXIS_CPU2FPGA_11_tvalid : out std_logic;

		M_AXIS_CPU2FPGA_12_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_12_tready : in std_logic;
		M_AXIS_CPU2FPGA_12_tvalid : out std_logic;

		M_AXIS_CPU2FPGA_13_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_13_tready : in std_logic;
		M_AXIS_CPU2FPGA_13_tvalid : out std_logic;

		M_AXIS_CPU2FPGA_14_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_14_tready : in std_logic;
		M_AXIS_CPU2FPGA_14_tvalid : out std_logic;

		M_AXIS_CPU2FPGA_15_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_15_tready : in std_logic;
		M_AXIS_CPU2FPGA_15_tvalid : out std_logic;

		-- FPGA to CPU inputs

		S_AXIS_FPGA2CPU_00_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_00_tready : out std_logic;
		S_AXIS_FPGA2CPU_00_tvalid : in std_logic := '1';

		S_AXIS_FPGA2CPU_01_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_01_tready : out std_logic;
		S_AXIS_FPGA2CPU_01_tvalid : in std_logic := '1';

		S_AXIS_FPGA2CPU_02_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_02_tready : out std_logic;
		S_AXIS_FPGA2CPU_02_tvalid : in std_logic := '1';

		S_AXIS_FPGA2CPU_03_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_03_tready : out std_logic;
		S_AXIS_FPGA2CPU_03_tvalid : in std_logic := '1';

		S_AXIS_FPGA2CPU_04_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_04_tready : out std_logic;
		S_AXIS_FPGA2CPU_04_tvalid : in std_logic := '1';

		S_AXIS_FPGA2CPU_05_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_05_tready : out std_logic;
		S_AXIS_FPGA2CPU_05_tvalid : in std_logic := '1';

		S_AXIS_FPGA2CPU_06_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_06_tready : out std_logic;
		S_AXIS_FPGA2CPU_06_tvalid : in std_logic := '1';

		S_AXIS_FPGA2CPU_07_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_07_tready : out std_logic;
		S_AXIS_FPGA2CPU_07_tvalid : in std_logic := '1';

		S_AXIS_FPGA2CPU_08_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_08_tready : out std_logic;
		S_AXIS_FPGA2CPU_08_tvalid : in std_logic := '1';

		S_AXIS_FPGA2CPU_09_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_09_tready : out std_logic;
		S_AXIS_FPGA2CPU_09_tvalid : in std_logic := '1';

		S_AXIS_FPGA2CPU_10_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_10_tready : out std_logic;
		S_AXIS_FPGA2CPU_10_tvalid : in std_logic := '1';

		S_AXIS_FPGA2CPU_11_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_11_tready : out std_logic;
		S_AXIS_FPGA2CPU_11_tvalid : in std_logic := '1';

		S_AXIS_FPGA2CPU_12_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_12_tready : out std_logic;
		S_AXIS_FPGA2CPU_12_tvalid : in std_logic := '1';

		S_AXIS_FPGA2CPU_13_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_13_tready : out std_logic;
		S_AXIS_FPGA2CPU_13_tvalid : in std_logic := '1';

		S_AXIS_FPGA2CPU_14_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_14_tready : out std_logic;
		S_AXIS_FPGA2CPU_14_tvalid : in std_logic := '1';

		S_AXIS_FPGA2CPU_15_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_15_tready : out std_logic;
		S_AXIS_FPGA2CPU_15_tvalid : in std_logic := '1';

		-- Sample time Ts output

		M_AXIS_Ts_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_Ts_tready : in std_logic;
		M_AXIS_Ts_tvalid : out std_logic;

		-- reset outputs
		nReset_ctrl : out std_logic; -- Activated by CPU by written "1" in SBO_63. Typically used for PID controller
		nReset_sync : out std_logic; -- Activated when loading user code

		------------------------------------------------------------------------
		-- INTERFACE WITH IMPERIX FIRMWARE IP
		------------------------------------------------------------------------

		-- SBO

		sbo_00_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_01_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_02_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_03_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_04_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_05_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_06_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_07_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_08_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_09_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_10_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_11_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_12_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_13_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_14_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_15_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_16_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_17_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_18_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_19_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_20_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_21_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_22_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_23_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_24_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_25_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_26_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_27_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_28_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_29_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_30_in   : in std_logic_vector(15 downto 0) := (others => '0');
		sbo_31_in   : in std_logic_vector(15 downto 0) := (others => '0');

		sbo_63_in   : in std_logic_vector(15 downto 0) := (others => '0'); -- reserved for ctrl nReset

		-- ADC

		adc_00_in : in std_logic_vector(15 downto 0) := (others => '0');
		adc_01_in : in std_logic_vector(15 downto 0) := (others => '0');
		adc_02_in : in std_logic_vector(15 downto 0) := (others => '0');
		adc_03_in : in std_logic_vector(15 downto 0) := (others => '0');
		adc_04_in : in std_logic_vector(15 downto 0) := (others => '0');
		adc_05_in : in std_logic_vector(15 downto 0) := (others => '0');
		adc_06_in : in std_logic_vector(15 downto 0) := (others => '0');
		adc_07_in : in std_logic_vector(15 downto 0) := (others => '0');
		adc_08_in : in std_logic_vector(15 downto 0) := (others => '0');
		adc_09_in : in std_logic_vector(15 downto 0) := (others => '0');
		adc_10_in : in std_logic_vector(15 downto 0) := (others => '0');
		adc_11_in : in std_logic_vector(15 downto 0) := (others => '0');
		adc_12_in : in std_logic_vector(15 downto 0) := (others => '0');
		adc_13_in : in std_logic_vector(15 downto 0) := (others => '0');
		adc_14_in : in std_logic_vector(15 downto 0) := (others => '0');
		adc_15_in : in std_logic_vector(15 downto 0) := (others => '0');

		-- SBO

		sbi_00_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_01_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_02_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_03_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_04_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_05_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_06_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_07_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_08_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_09_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_10_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_11_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_12_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_13_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_14_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_15_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_16_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_17_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_18_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_19_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_20_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_21_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_22_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_23_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_24_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_25_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_26_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_27_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_28_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_29_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_30_out : out std_logic_vector(15 downto 0) := (others => '0');
		sbi_31_out : out std_logic_vector(15 downto 0) := (others => '0');

		-- Timing pulses

		adc_done_pulse_in   : in std_logic;
		data_valid_pulse_in : in std_logic;
		data_reading_in     : in std_logic;
		sync_pulse_in       : in std_logic;

		-- Main clock running at 250 MHz
		clk : in std_logic
	);
end ix_axis_interface;

architecture impl of ix_axis_interface is

	ATTRIBUTE X_INTERFACE_INFO : STRING;
	ATTRIBUTE X_INTERFACE_PARAMETER : STRING;
	ATTRIBUTE X_INTERFACE_INFO of clk: SIGNAL is "xilinx.com:signal:clock:1.0 clk CLK";

	-- Informations to infer the ADC interface
	ATTRIBUTE X_INTERFACE_INFO of adc_00_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 ADC reg_00";
	ATTRIBUTE X_INTERFACE_INFO of adc_01_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 ADC reg_01";
	ATTRIBUTE X_INTERFACE_INFO of adc_02_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 ADC reg_02";
	ATTRIBUTE X_INTERFACE_INFO of adc_03_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 ADC reg_03";
	ATTRIBUTE X_INTERFACE_INFO of adc_04_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 ADC reg_04";
	ATTRIBUTE X_INTERFACE_INFO of adc_05_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 ADC reg_05";
	ATTRIBUTE X_INTERFACE_INFO of adc_06_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 ADC reg_06";
	ATTRIBUTE X_INTERFACE_INFO of adc_07_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 ADC reg_07";
	ATTRIBUTE X_INTERFACE_INFO of adc_08_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 ADC reg_08";
	ATTRIBUTE X_INTERFACE_INFO of adc_09_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 ADC reg_09";
	ATTRIBUTE X_INTERFACE_INFO of adc_10_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 ADC reg_10";
	ATTRIBUTE X_INTERFACE_INFO of adc_11_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 ADC reg_11";
	ATTRIBUTE X_INTERFACE_INFO of adc_12_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 ADC reg_12";
	ATTRIBUTE X_INTERFACE_INFO of adc_13_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 ADC reg_13";
	ATTRIBUTE X_INTERFACE_INFO of adc_14_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 ADC reg_14";
	ATTRIBUTE X_INTERFACE_INFO of adc_15_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 ADC reg_15";

	-- Informations to infer the SBO interface
	ATTRIBUTE X_INTERFACE_INFO of sbo_00_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_00";
	ATTRIBUTE X_INTERFACE_INFO of sbo_01_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_01";
	ATTRIBUTE X_INTERFACE_INFO of sbo_02_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_02";
	ATTRIBUTE X_INTERFACE_INFO of sbo_03_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_03";
	ATTRIBUTE X_INTERFACE_INFO of sbo_04_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_04";
	ATTRIBUTE X_INTERFACE_INFO of sbo_05_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_05";
	ATTRIBUTE X_INTERFACE_INFO of sbo_06_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_06";
	ATTRIBUTE X_INTERFACE_INFO of sbo_07_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_07";
	ATTRIBUTE X_INTERFACE_INFO of sbo_08_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_08";
	ATTRIBUTE X_INTERFACE_INFO of sbo_09_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_09";
	ATTRIBUTE X_INTERFACE_INFO of sbo_10_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_10";
	ATTRIBUTE X_INTERFACE_INFO of sbo_11_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_11";
	ATTRIBUTE X_INTERFACE_INFO of sbo_12_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_12";
	ATTRIBUTE X_INTERFACE_INFO of sbo_13_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_13";
	ATTRIBUTE X_INTERFACE_INFO of sbo_14_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_14";
	ATTRIBUTE X_INTERFACE_INFO of sbo_15_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_15";
	ATTRIBUTE X_INTERFACE_INFO of sbo_16_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_16";
	ATTRIBUTE X_INTERFACE_INFO of sbo_17_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_17";
	ATTRIBUTE X_INTERFACE_INFO of sbo_18_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_18";
	ATTRIBUTE X_INTERFACE_INFO of sbo_19_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_19";
	ATTRIBUTE X_INTERFACE_INFO of sbo_20_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_20";
	ATTRIBUTE X_INTERFACE_INFO of sbo_21_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_21";
	ATTRIBUTE X_INTERFACE_INFO of sbo_22_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_22";
	ATTRIBUTE X_INTERFACE_INFO of sbo_23_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_23";
	ATTRIBUTE X_INTERFACE_INFO of sbo_24_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_24";
	ATTRIBUTE X_INTERFACE_INFO of sbo_25_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_25";
	ATTRIBUTE X_INTERFACE_INFO of sbo_26_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_26";
	ATTRIBUTE X_INTERFACE_INFO of sbo_27_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_27";
	ATTRIBUTE X_INTERFACE_INFO of sbo_28_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_28";
	ATTRIBUTE X_INTERFACE_INFO of sbo_29_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_29";
	ATTRIBUTE X_INTERFACE_INFO of sbo_30_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_30";
	ATTRIBUTE X_INTERFACE_INFO of sbo_31_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_31";
	ATTRIBUTE X_INTERFACE_INFO of sbo_63_in: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBO reg_63";

	-- Informations to infer the SBO interface
	ATTRIBUTE X_INTERFACE_INFO of sbi_00_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_00";
	ATTRIBUTE X_INTERFACE_INFO of sbi_01_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_01";
	ATTRIBUTE X_INTERFACE_INFO of sbi_02_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_02";
	ATTRIBUTE X_INTERFACE_INFO of sbi_03_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_03";
	ATTRIBUTE X_INTERFACE_INFO of sbi_04_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_04";
	ATTRIBUTE X_INTERFACE_INFO of sbi_05_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_05";
	ATTRIBUTE X_INTERFACE_INFO of sbi_06_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_06";
	ATTRIBUTE X_INTERFACE_INFO of sbi_07_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_07";
	ATTRIBUTE X_INTERFACE_INFO of sbi_08_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_08";
	ATTRIBUTE X_INTERFACE_INFO of sbi_09_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_09";
	ATTRIBUTE X_INTERFACE_INFO of sbi_10_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_10";
	ATTRIBUTE X_INTERFACE_INFO of sbi_11_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_11";
	ATTRIBUTE X_INTERFACE_INFO of sbi_12_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_12";
	ATTRIBUTE X_INTERFACE_INFO of sbi_13_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_13";
	ATTRIBUTE X_INTERFACE_INFO of sbi_14_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_14";
	ATTRIBUTE X_INTERFACE_INFO of sbi_15_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_15";
	ATTRIBUTE X_INTERFACE_INFO of sbi_16_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_16";
	ATTRIBUTE X_INTERFACE_INFO of sbi_17_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_17";
	ATTRIBUTE X_INTERFACE_INFO of sbi_18_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_18";
	ATTRIBUTE X_INTERFACE_INFO of sbi_19_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_19";
	ATTRIBUTE X_INTERFACE_INFO of sbi_20_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_20";
	ATTRIBUTE X_INTERFACE_INFO of sbi_21_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_21";
	ATTRIBUTE X_INTERFACE_INFO of sbi_22_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_22";
	ATTRIBUTE X_INTERFACE_INFO of sbi_23_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_23";
	ATTRIBUTE X_INTERFACE_INFO of sbi_24_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_24";
	ATTRIBUTE X_INTERFACE_INFO of sbi_25_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_25";
	ATTRIBUTE X_INTERFACE_INFO of sbi_26_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_26";
	ATTRIBUTE X_INTERFACE_INFO of sbi_27_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_27";
	ATTRIBUTE X_INTERFACE_INFO of sbi_28_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_28";
	ATTRIBUTE X_INTERFACE_INFO of sbi_29_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_29";
	ATTRIBUTE X_INTERFACE_INFO of sbi_30_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_30";
	ATTRIBUTE X_INTERFACE_INFO of sbi_31_out: SIGNAL is "imperix.ch:ix:user_regs_rtl:1.0 SBI reg_31";

	-- SBO registers
	type t_sbois is array (0 to 63) of std_logic_vector(15 downto 0);
	signal r_sbo : t_sbois;
	signal r_data_valid : std_logic := '0';

	-- ADC registers
	type t_adcs is array (0 to 15) of std_logic_vector(15 downto 0);
	signal r_adc : t_adcs;
	signal r_adc_done : std_logic := '0';
	-- Ts count
    signal cnt_Ts : unsigned(31 downto 0) := (30 downto 0 => '0') & '1';
    signal r_Ts : std_logic_vector(31 downto 0) := (others => '0');

	-- controller nReset
	signal r_CpuCommand           : std_logic := '1'; -- 1: output disabled; 0: output enabled
	signal reg_nReset_ctrl        : std_logic := '1';
	signal reg_nReset_ctrl_delay1 : std_logic := '1';
	signal reg_nReset_ctrl_delay2 : std_logic := '1';
	signal reg_nReset_ctrl_delay3 : std_logic := '1';

	-- sync nReset
	signal reg_nReset_sync        : std_logic := '1';
	signal reg_nReset_sync_delay1 : std_logic := '1';
	signal reg_nReset_sync_delay2 : std_logic := '1';
	signal reg_nReset_sync_delay3 : std_logic := '1';

begin

	P_ADC_AXIS : process(clk)
	begin
        if rising_edge(clk) then
            -- ADC0
            if r_data_valid = '1'then
                M_AXIS_ADC_00_tvalid <= '1';
                M_AXIS_ADC_00_tdata <= r_adc(0);
            else
                if M_AXIS_ADC_00_tready = '1' then
                    M_AXIS_ADC_00_tvalid <= '0';
                end if;
            end if;
    
            -- ADC1
            if r_data_valid = '1' then
                M_AXIS_ADC_01_tvalid <= '1';
                M_AXIS_ADC_01_tdata <= r_adc(1);
            else
                if M_AXIS_ADC_01_tready = '1' then
                    M_AXIS_ADC_01_tvalid <= '0';
                end if;
            end if;
    
            -- ADC2
            if r_data_valid = '1'then
                M_AXIS_ADC_02_tvalid <= '1';
                M_AXIS_ADC_02_tdata <= r_adc(2);
            else
                if M_AXIS_ADC_02_tready = '1' then
                    M_AXIS_ADC_02_tvalid <= '0';
                end if;
            end if;
    
            -- ADC3
            if r_data_valid = '1'then
                M_AXIS_ADC_03_tvalid <= '1';
                M_AXIS_ADC_03_tdata <= r_adc(3);
            else
                if M_AXIS_ADC_03_tready = '1' then
                    M_AXIS_ADC_03_tvalid <= '0';
                end if;
            end if;
    
            -- ADC4
            if r_data_valid = '1'then
                M_AXIS_ADC_04_tvalid <= '1';
                M_AXIS_ADC_04_tdata <= r_adc(4);
            else
                if M_AXIS_ADC_04_tready = '1' then
                    M_AXIS_ADC_04_tvalid <= '0';
                end if;
            end if;
    
            -- ADC5
            if r_data_valid = '1'then
                M_AXIS_ADC_05_tvalid <= '1';
                M_AXIS_ADC_05_tdata <= r_adc(5);
            else
                if M_AXIS_ADC_05_tready = '1' then
                    M_AXIS_ADC_05_tvalid <= '0';
                end if;
            end if;
    
            -- ADC6
            if r_data_valid = '1'then
                M_AXIS_ADC_06_tvalid <= '1';
                M_AXIS_ADC_06_tdata <= r_adc(6);
            else
                if M_AXIS_ADC_06_tready = '1' then
                    M_AXIS_ADC_06_tvalid <= '0';
                end if;
            end if;
    
            -- ADC7
            if r_data_valid = '1'then
                M_AXIS_ADC_07_tvalid <= '1';
                M_AXIS_ADC_07_tdata <= r_adc(7);
            else
                if M_AXIS_ADC_07_tready = '1' then
                    M_AXIS_ADC_07_tvalid <= '0';
                end if;
            end if;
    
            -- ADC8
            if r_data_valid = '1'then
                M_AXIS_ADC_08_tvalid <= '1';
                M_AXIS_ADC_08_tdata <= r_adc(8);
            else
                if M_AXIS_ADC_08_tready = '1' then
                    M_AXIS_ADC_08_tvalid <= '0';
                end if;
            end if;
    
            -- ADC9
            if r_data_valid = '1'then
                M_AXIS_ADC_09_tvalid <= '1';
                M_AXIS_ADC_09_tdata <= r_adc(9);
            else
                if M_AXIS_ADC_09_tready = '1' then
                    M_AXIS_ADC_09_tvalid <= '0';
                end if;
            end if;
    
            -- ADC10
            if r_data_valid = '1'then
                M_AXIS_ADC_10_tvalid <= '1';
                M_AXIS_ADC_10_tdata <= r_adc(10);
            else
                if M_AXIS_ADC_10_tready = '1' then
                    M_AXIS_ADC_10_tvalid <= '0';
                end if;
            end if;
    
            -- ADC11
            if r_data_valid = '1'then
                M_AXIS_ADC_11_tvalid <= '1';
                M_AXIS_ADC_11_tdata <= r_adc(11);
            else
                if M_AXIS_ADC_11_tready = '1' then
                    M_AXIS_ADC_11_tvalid <= '0';
                end if;
            end if;
    
            -- ADC12
            if r_data_valid = '1'then
                M_AXIS_ADC_12_tvalid <= '1';
                M_AXIS_ADC_12_tdata <= r_adc(12);
            else
                if M_AXIS_ADC_12_tready = '1' then
                    M_AXIS_ADC_12_tvalid <= '0';
                end if;
            end if;
    
            -- ADC13
            if r_data_valid = '1'then
                M_AXIS_ADC_13_tvalid <= '1';
                M_AXIS_ADC_13_tdata <= r_adc(13);
            else
                if M_AXIS_ADC_13_tready = '1' then
                    M_AXIS_ADC_13_tvalid <= '0';
                end if;
            end if;
    
            -- ADC14
            if r_data_valid = '1'then
                M_AXIS_ADC_14_tvalid <= '1';
                M_AXIS_ADC_14_tdata <= r_adc(14);
            else
                if M_AXIS_ADC_14_tready = '1' then
                    M_AXIS_ADC_14_tvalid <= '0';
                end if;
            end if;
    
            -- ADC15
            if r_data_valid = '1'then
                M_AXIS_ADC_15_tvalid <= '1';
                M_AXIS_ADC_15_tdata <= r_adc(15);
            else
                if M_AXIS_ADC_15_tready = '1' then
                    M_AXIS_ADC_15_tvalid <= '0';
                end if;
            end if;
		end if;

	end process P_ADC_AXIS;

	------------------------------------------------------------------------
	-- CPU2FPGA output streams
	------------------------------------------------------------------------
	P_CPU2FPGA_AXIS : process(clk)
	begin
        if rising_edge(clk) then
            -- CPU2FPGA 00: 32-bit data using SBO_00 and SBO_01
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_00_tvalid <= '1';
                M_AXIS_CPU2FPGA_00_tdata <= r_sbo(1) & r_sbo(0);
            else
                if M_AXIS_CPU2FPGA_00_tready = '1' then
                    M_AXIS_CPU2FPGA_00_tvalid <= '0';
                end if;
            end if;
    
            -- CPU2FPGA 01: 32-bit data using SBO_02 and SBO_03
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_01_tvalid <= '1';
                M_AXIS_CPU2FPGA_01_tdata <= r_sbo(3) & r_sbo(2);
            else
                if M_AXIS_CPU2FPGA_01_tready = '1' then
                    M_AXIS_CPU2FPGA_01_tvalid <= '0';
                end if;
            end if;
    
            -- CPU2FPGA 02: 32-bit data using SBO_04 and SBO_05
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_02_tvalid <= '1';
                M_AXIS_CPU2FPGA_02_tdata <= r_sbo(5) & r_sbo(4);
            else
                if M_AXIS_CPU2FPGA_02_tready = '1' then
                    M_AXIS_CPU2FPGA_02_tvalid <= '0';
                end if;
            end if;
    
            -- CPU2FPGA 03: 32-bit data using SBO_06 and SBO_07
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_03_tvalid <= '1';
                M_AXIS_CPU2FPGA_03_tdata <= r_sbo(7) & r_sbo(6);
            else
                if M_AXIS_CPU2FPGA_03_tready = '1' then
                    M_AXIS_CPU2FPGA_03_tvalid <= '0';
                end if;
            end if;
    
            -- CPU2FPGA 04: 32-bit data using SBO_08 and SBO_09
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_04_tvalid <= '1';
                M_AXIS_CPU2FPGA_04_tdata <= r_sbo(9) & r_sbo(8);
            else
                if M_AXIS_CPU2FPGA_04_tready = '1' then
                    M_AXIS_CPU2FPGA_04_tvalid <= '0';
                end if;
            end if;
    
            -- CPU2FPGA 05: 32-bit data using SBO_10 and SBO_11
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_05_tvalid <= '1';
                M_AXIS_CPU2FPGA_05_tdata <= r_sbo(11) & r_sbo(10);
            else
                if M_AXIS_CPU2FPGA_05_tready = '1' then
                    M_AXIS_CPU2FPGA_05_tvalid <= '0';
                end if;
            end if;
    
            -- CPU2FPGA 06: 32-bit data using SBO_12 and SBO_13
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_06_tvalid <= '1';
                M_AXIS_CPU2FPGA_06_tdata <= r_sbo(13) & r_sbo(12);
            else
                if M_AXIS_CPU2FPGA_06_tready = '1' then
                    M_AXIS_CPU2FPGA_06_tvalid <= '0';
                end if;
            end if;
    
            -- CPU2FPGA 07: 32-bit data using SBO_14 and SBO_15
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_07_tvalid <= '1';
                M_AXIS_CPU2FPGA_07_tdata <= r_sbo(15) & r_sbo(14);
            else
                if M_AXIS_CPU2FPGA_07_tready = '1' then
                    M_AXIS_CPU2FPGA_07_tvalid <= '0';
                end if;
            end if;
    
            -- CPU2FPGA 08: 32-bit data using SBO_16 and SBO_17
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_08_tvalid <= '1';
                M_AXIS_CPU2FPGA_08_tdata <= r_sbo(17) & r_sbo(16);
            else
                if M_AXIS_CPU2FPGA_08_tready = '1' then
                    M_AXIS_CPU2FPGA_08_tvalid <= '0';
                end if;
            end if;
    
            -- CPU2FPGA 09: 32-bit data using SBO_18 and SBO_19
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_09_tvalid <= '1';
                M_AXIS_CPU2FPGA_09_tdata <= r_sbo(19) & r_sbo(18);
            else
                if M_AXIS_CPU2FPGA_09_tready = '1' then
                    M_AXIS_CPU2FPGA_09_tvalid <= '0';
                end if;
            end if;
    
            -- CPU2FPGA 10: 32-bit data using SBO_20 and SBO_21
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_10_tvalid <= '1';
                M_AXIS_CPU2FPGA_10_tdata <= r_sbo(21) & r_sbo(20);
            else
                if M_AXIS_CPU2FPGA_10_tready = '1' then
                    M_AXIS_CPU2FPGA_10_tvalid <= '0';
                end if;
            end if;
    
            -- CPU2FPGA 11: 32-bit data using SBO_22 and SBO_23
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_11_tvalid <= '1';
                M_AXIS_CPU2FPGA_11_tdata <= r_sbo(23) & r_sbo(22);
            else
                if M_AXIS_CPU2FPGA_11_tready = '1' then
                    M_AXIS_CPU2FPGA_11_tvalid <= '0';
                end if;
            end if;
    
            -- CPU2FPGA 12: 32-bit data using SBO_24 and SBO_25
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_12_tvalid <= '1';
                M_AXIS_CPU2FPGA_12_tdata <= r_sbo(25) & r_sbo(24);
            else
                if M_AXIS_CPU2FPGA_12_tready = '1' then
                    M_AXIS_CPU2FPGA_12_tvalid <= '0';
                end if;
            end if;
    
            -- CPU2FPGA 13: 32-bit data using SBO_26 and SBO_27
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_13_tvalid <= '1';
                M_AXIS_CPU2FPGA_13_tdata <= r_sbo(27) & r_sbo(26);
            else
                if M_AXIS_CPU2FPGA_13_tready = '1' then
                    M_AXIS_CPU2FPGA_13_tvalid <= '0';
                end if;
            end if;
    
            -- CPU2FPGA 14: 32-bit data using SBO_28 and SBO_09
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_14_tvalid <= '1';
                M_AXIS_CPU2FPGA_14_tdata <= r_sbo(29) & r_sbo(28);
            else
                if M_AXIS_CPU2FPGA_14_tready = '1' then
                    M_AXIS_CPU2FPGA_14_tvalid <= '0';
                end if;
            end if;
    
            -- CPU2FPGA 15: 32-bit data using SBO_30 and SBO_31
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_15_tvalid <= '1';
                M_AXIS_CPU2FPGA_15_tdata <= r_sbo(31) & r_sbo(30);
            else
                if M_AXIS_CPU2FPGA_15_tready = '1' then
                    M_AXIS_CPU2FPGA_15_tvalid <= '0';
                end if;
            end if;
		end if;

	end process P_CPU2FPGA_AXIS;

	------------------------------------------------------------------------
	-- FPGA2CPU input streams
	------------------------------------------------------------------------
	P_FPGA2CPU_AXIS : process(clk)
	begin
        if rising_edge(clk) then
            -- accept SBI data only when not reading
            S_AXIS_FPGA2CPU_00_tready <= not data_reading_in;
            S_AXIS_FPGA2CPU_01_tready <= not data_reading_in;
            S_AXIS_FPGA2CPU_02_tready <= not data_reading_in;
            S_AXIS_FPGA2CPU_03_tready <= not data_reading_in;
            S_AXIS_FPGA2CPU_04_tready <= not data_reading_in;
            S_AXIS_FPGA2CPU_05_tready <= not data_reading_in;
            S_AXIS_FPGA2CPU_06_tready <= not data_reading_in;
            S_AXIS_FPGA2CPU_07_tready <= not data_reading_in;
            S_AXIS_FPGA2CPU_08_tready <= not data_reading_in;
            S_AXIS_FPGA2CPU_09_tready <= not data_reading_in;
            S_AXIS_FPGA2CPU_10_tready <= not data_reading_in;
            S_AXIS_FPGA2CPU_11_tready <= not data_reading_in;
            S_AXIS_FPGA2CPU_12_tready <= not data_reading_in;
            S_AXIS_FPGA2CPU_13_tready <= not data_reading_in;
            S_AXIS_FPGA2CPU_14_tready <= not data_reading_in;
            S_AXIS_FPGA2CPU_15_tready <= not data_reading_in;
    
            -- FPGA2CPU 00: 32-bit data using SBI_00 and SBI_01
            if data_reading_in = '0' and S_AXIS_FPGA2CPU_00_tvalid = '1' then
                sbi_00_out <= S_AXIS_FPGA2CPU_00_tdata(15 downto 0);
                sbi_01_out <= S_AXIS_FPGA2CPU_00_tdata(31 downto 16);
            end if;
    
            -- FPGA2CPU 01: 32-bit data using SBI_02 and SBI_03
            if data_reading_in = '0' and S_AXIS_FPGA2CPU_01_tvalid = '1' then
                sbi_02_out <= S_AXIS_FPGA2CPU_01_tdata(15 downto 0);
                sbi_03_out <= S_AXIS_FPGA2CPU_01_tdata(31 downto 16);
            end if;
    
            -- FPGA2CPU 02: 32-bit data using SBI_04 and SBI_05
            if data_reading_in = '0' and S_AXIS_FPGA2CPU_02_tvalid = '1' then
                sbi_04_out <= S_AXIS_FPGA2CPU_02_tdata(15 downto 0);
                sbi_05_out <= S_AXIS_FPGA2CPU_02_tdata(31 downto 16);
            end if;
    
            -- FPGA2CPU 03: 32-bit data using SBI_06 and SBI_07
            if data_reading_in = '0' and S_AXIS_FPGA2CPU_03_tvalid = '1' then
                sbi_06_out <= S_AXIS_FPGA2CPU_03_tdata(15 downto 0);
                sbi_07_out <= S_AXIS_FPGA2CPU_03_tdata(31 downto 16);
            end if;
    
            -- FPGA2CPU 04: 32-bit data using SBI_08 and SBI_09
            if data_reading_in = '0' and S_AXIS_FPGA2CPU_04_tvalid = '1' then
                sbi_08_out <= S_AXIS_FPGA2CPU_04_tdata(15 downto 0);
                sbi_09_out <= S_AXIS_FPGA2CPU_04_tdata(31 downto 16);
            end if;
    
            -- FPGA2CPU 05: 32-bit data using SBI_10 and SBI_11
            if data_reading_in = '0' and S_AXIS_FPGA2CPU_05_tvalid = '1' then
                sbi_10_out <= S_AXIS_FPGA2CPU_05_tdata(15 downto 0);
                sbi_11_out <= S_AXIS_FPGA2CPU_05_tdata(31 downto 16);
            end if;
    
            -- FPGA2CPU 06: 32-bit data using SBI_12 and SBI_13
            if data_reading_in = '0' and S_AXIS_FPGA2CPU_06_tvalid = '1' then
                sbi_12_out <= S_AXIS_FPGA2CPU_06_tdata(15 downto 0);
                sbi_13_out <= S_AXIS_FPGA2CPU_06_tdata(31 downto 16);
            end if;
    
            -- FPGA2CPU 07: 32-bit data using SBI_14 and SBI_15
            if data_reading_in = '0' and S_AXIS_FPGA2CPU_07_tvalid = '1' then
                sbi_14_out <= S_AXIS_FPGA2CPU_07_tdata(15 downto 0);
                sbi_15_out <= S_AXIS_FPGA2CPU_07_tdata(31 downto 16);
            end if;
    
            -- FPGA2CPU 08: 32-bit data using SBI_16 and SBI_17
            if data_reading_in = '0' and S_AXIS_FPGA2CPU_08_tvalid = '1' then
                sbi_16_out <= S_AXIS_FPGA2CPU_08_tdata(15 downto 0);
                sbi_17_out <= S_AXIS_FPGA2CPU_08_tdata(31 downto 16);
            end if;
    
            -- FPGA2CPU 09: 32-bit data using SBI_18 and SBI_19
            if data_reading_in = '0' and S_AXIS_FPGA2CPU_09_tvalid = '1' then
                sbi_18_out <= S_AXIS_FPGA2CPU_09_tdata(15 downto 0);
                sbi_19_out <= S_AXIS_FPGA2CPU_09_tdata(31 downto 16);
            end if;
    
            -- FPGA2CPU 10: 32-bit data using SBI_20 and SBI_21
            if data_reading_in = '0' and S_AXIS_FPGA2CPU_10_tvalid = '1' then
                sbi_20_out <= S_AXIS_FPGA2CPU_10_tdata(15 downto 0);
                sbi_21_out <= S_AXIS_FPGA2CPU_10_tdata(31 downto 16);
            end if;
    
            -- FPGA2CPU 11: 32-bit data using SBI_22 and SBI_23
            if data_reading_in = '0' and S_AXIS_FPGA2CPU_11_tvalid = '1' then
                sbi_22_out <= S_AXIS_FPGA2CPU_11_tdata(15 downto 0);
                sbi_23_out <= S_AXIS_FPGA2CPU_11_tdata(31 downto 16);
            end if;
    
            -- FPGA2CPU 12: 32-bit data using SBI_24 and SBI_25
            if data_reading_in = '0' and S_AXIS_FPGA2CPU_12_tvalid = '1' then
                sbi_24_out <= S_AXIS_FPGA2CPU_12_tdata(15 downto 0);
                sbi_25_out <= S_AXIS_FPGA2CPU_12_tdata(31 downto 16);
            end if;
    
            -- FPGA2CPU 13: 32-bit data using SBI_26 and SBI_27
            if data_reading_in = '0' and S_AXIS_FPGA2CPU_13_tvalid = '1' then
                sbi_26_out <= S_AXIS_FPGA2CPU_13_tdata(15 downto 0);
                sbi_27_out <= S_AXIS_FPGA2CPU_13_tdata(31 downto 16);
            end if;
    
            -- FPGA2CPU 14: 32-bit data using SBI_28 and SBI_29
            if data_reading_in = '0' and S_AXIS_FPGA2CPU_14_tvalid = '1' then
                sbi_28_out <= S_AXIS_FPGA2CPU_14_tdata(15 downto 0);
                sbi_29_out <= S_AXIS_FPGA2CPU_14_tdata(31 downto 16);
            end if;
    
            -- FPGA2CPU 15: 32-bit data using SBI_30 and SBI_31
            if data_reading_in = '0' and S_AXIS_FPGA2CPU_15_tvalid = '1' then
                sbi_30_out <= S_AXIS_FPGA2CPU_15_tdata(15 downto 0);
                sbi_31_out <= S_AXIS_FPGA2CPU_15_tdata(31 downto 16);
            end if;
		end if;

	end process P_FPGA2CPU_AXIS;

	P_TS_AXIS : process(clk)
	begin
        if rising_edge(clk) then
            -- Ts
            if r_data_valid = '1'then
                M_AXIS_Ts_tvalid <= '1';
                M_AXIS_Ts_tdata  <= r_Ts;
            else
                if M_AXIS_Ts_tready = '1' then
                    M_AXIS_Ts_tvalid <= '0';
                end if;
            end if;
		end if;

	end process P_TS_AXIS;

	P : process(clk)
	begin
		if rising_edge(clk) then

			-- Retrieving SBO data
			if data_valid_pulse_in = '1' then -- new data have been written to SBO registers
				-- save SBO inputs into registers
				r_sbo(0)  <= sbo_00_in;
				r_sbo(1)  <= sbo_01_in;
				r_sbo(2)  <= sbo_02_in;
				r_sbo(3)  <= sbo_03_in;
				r_sbo(4)  <= sbo_04_in;
				r_sbo(5)  <= sbo_05_in;
				r_sbo(6)  <= sbo_06_in;
				r_sbo(7)  <= sbo_07_in;
				r_sbo(8)  <= sbo_08_in;
				r_sbo(9)  <= sbo_09_in;
				r_sbo(10) <= sbo_10_in;
				r_sbo(11) <= sbo_11_in;
				r_sbo(12) <= sbo_12_in;
				r_sbo(13) <= sbo_13_in;
				r_sbo(14) <= sbo_14_in;
				r_sbo(15) <= sbo_15_in;
				r_sbo(16) <= sbo_16_in;
				r_sbo(17) <= sbo_17_in;
				r_sbo(18) <= sbo_18_in;
				r_sbo(19) <= sbo_19_in;
				r_sbo(20) <= sbo_20_in;
				r_sbo(21) <= sbo_21_in;
				r_sbo(22) <= sbo_22_in;
				r_sbo(23) <= sbo_23_in;
				r_sbo(24) <= sbo_24_in;
				r_sbo(25) <= sbo_25_in;
				r_sbo(26) <= sbo_26_in;
				r_sbo(27) <= sbo_27_in;
				r_sbo(28) <= sbo_28_in;
				r_sbo(29) <= sbo_29_in;
				r_sbo(30) <= sbo_30_in;
				r_sbo(31) <= sbo_31_in;

			end if;

            -- ADC Input
            r_data_valid <= '0'; -- default
			r_adc_done <= adc_done_pulse_in;
            if r_adc_done = '1' then -- sampled values are available in ADC registers
                -- save ADC inputs into registers
                r_adc(0)  <= adc_00_in;
                r_adc(1)  <= adc_01_in;
                r_adc(2)  <= adc_02_in;
                r_adc(3)  <= adc_03_in;
                r_adc(4)  <= adc_04_in;
                r_adc(5)  <= adc_05_in;
                r_adc(6)  <= adc_06_in;
                r_adc(7)  <= adc_07_in;
                r_adc(8)  <= adc_08_in;
                r_adc(9)  <= adc_09_in;
                r_adc(10) <= adc_10_in;
                r_adc(11) <= adc_11_in;
                r_adc(12) <= adc_12_in;
                r_adc(13) <= adc_13_in;
                r_adc(14) <= adc_14_in;
                r_adc(15) <= adc_15_in;
                r_data_valid <= '1';
            end if;

            -- controller nReset
            reg_nReset_ctrl <= '1'; -- default value
            if data_valid_pulse_in = '1' then -- Receive controller nReset from SBO_reg_63
                -- detect falling edge on SBO_reg_63
                r_CpuCommand <= sbo_63_in(0);
                if sbo_63_in(0) = '0' and r_CpuCommand = '1' then
                    reg_nReset_ctrl <= '0';
                end if;
            end if;
            reg_nReset_ctrl_delay1 <= reg_nReset_ctrl;
            reg_nReset_ctrl_delay2 <= reg_nReset_ctrl_delay1;
            reg_nReset_ctrl_delay3 <= reg_nReset_ctrl_delay2;

            -- sync nReset
            reg_nReset_sync <= not sync_pulse_in;
            reg_nReset_sync_delay1 <= reg_nReset_sync;
            reg_nReset_sync_delay2 <= reg_nReset_sync_delay1;
            reg_nReset_sync_delay3 <= reg_nReset_sync_delay2;

            -- Ts counter control
            cnt_Ts <= cnt_Ts + 4; -- clk is running at 250 Mhz, so increment by 4 ns
            if r_adc_done = '1' then
               r_Ts <= std_logic_vector(cnt_Ts);
               cnt_Ts <= to_unsigned(4, cnt_Ts'length);
			end if;

		end if;
	end process P;

	-- nReset outputs are asserted for 4 clock cycles
	nReset_ctrl <= reg_nReset_ctrl and reg_nReset_ctrl_delay1 and reg_nReset_ctrl_delay2 and reg_nReset_ctrl_delay3;
	nReset_sync <= reg_nReset_sync and reg_nReset_sync_delay1 and reg_nReset_sync_delay2 and reg_nReset_sync_delay3;

end impl;
