library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;

entity ix_64_axis_interface is
	Port (
		------------------------------------------------------------------------
		-- INTERFACE WITH USER FPGA LOGIC
		------------------------------------------------------------------------

		-- CPU to FPGA outputs

        M_AXIS_CPU2FPGA_00_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_00_tready : in std_logic;
		M_AXIS_CPU2FPGA_00_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_01_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_01_tready : in std_logic;
		M_AXIS_CPU2FPGA_01_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_02_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_02_tready : in std_logic;
		M_AXIS_CPU2FPGA_02_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_03_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_03_tready : in std_logic;
		M_AXIS_CPU2FPGA_03_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_04_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_04_tready : in std_logic;
		M_AXIS_CPU2FPGA_04_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_05_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_05_tready : in std_logic;
		M_AXIS_CPU2FPGA_05_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_06_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_06_tready : in std_logic;
		M_AXIS_CPU2FPGA_06_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_07_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_07_tready : in std_logic;
		M_AXIS_CPU2FPGA_07_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_08_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_08_tready : in std_logic;
		M_AXIS_CPU2FPGA_08_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_09_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_09_tready : in std_logic;
		M_AXIS_CPU2FPGA_09_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_10_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_10_tready : in std_logic;
		M_AXIS_CPU2FPGA_10_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_11_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_11_tready : in std_logic;
		M_AXIS_CPU2FPGA_11_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_12_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_12_tready : in std_logic;
		M_AXIS_CPU2FPGA_12_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_13_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_13_tready : in std_logic;
		M_AXIS_CPU2FPGA_13_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_14_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_14_tready : in std_logic;
		M_AXIS_CPU2FPGA_14_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_15_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_15_tready : in std_logic;
		M_AXIS_CPU2FPGA_15_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_16_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_16_tready : in std_logic;
		M_AXIS_CPU2FPGA_16_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_17_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_17_tready : in std_logic;
		M_AXIS_CPU2FPGA_17_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_18_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_18_tready : in std_logic;
		M_AXIS_CPU2FPGA_18_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_19_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_19_tready : in std_logic;
		M_AXIS_CPU2FPGA_19_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_20_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_20_tready : in std_logic;
		M_AXIS_CPU2FPGA_20_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_21_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_21_tready : in std_logic;
		M_AXIS_CPU2FPGA_21_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_22_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_22_tready : in std_logic;
		M_AXIS_CPU2FPGA_22_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_23_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_23_tready : in std_logic;
		M_AXIS_CPU2FPGA_23_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_24_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_24_tready : in std_logic;
		M_AXIS_CPU2FPGA_24_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_25_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_25_tready : in std_logic;
		M_AXIS_CPU2FPGA_25_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_26_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_26_tready : in std_logic;
		M_AXIS_CPU2FPGA_26_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_27_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_27_tready : in std_logic;
		M_AXIS_CPU2FPGA_27_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_28_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_28_tready : in std_logic;
		M_AXIS_CPU2FPGA_28_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_29_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_29_tready : in std_logic;
		M_AXIS_CPU2FPGA_29_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_30_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_30_tready : in std_logic;
		M_AXIS_CPU2FPGA_30_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_31_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_31_tready : in std_logic;
		M_AXIS_CPU2FPGA_31_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_32_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_32_tready : in std_logic;
		M_AXIS_CPU2FPGA_32_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_33_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_33_tready : in std_logic;
		M_AXIS_CPU2FPGA_33_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_34_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_34_tready : in std_logic;
		M_AXIS_CPU2FPGA_34_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_35_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_35_tready : in std_logic;
		M_AXIS_CPU2FPGA_35_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_36_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_36_tready : in std_logic;
		M_AXIS_CPU2FPGA_36_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_37_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_37_tready : in std_logic;
		M_AXIS_CPU2FPGA_37_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_38_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_38_tready : in std_logic;
		M_AXIS_CPU2FPGA_38_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_39_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_39_tready : in std_logic;
		M_AXIS_CPU2FPGA_39_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_40_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_40_tready : in std_logic;
		M_AXIS_CPU2FPGA_40_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_41_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_41_tready : in std_logic;
		M_AXIS_CPU2FPGA_41_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_42_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_42_tready : in std_logic;
		M_AXIS_CPU2FPGA_42_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_43_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_43_tready : in std_logic;
		M_AXIS_CPU2FPGA_43_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_44_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_44_tready : in std_logic;
		M_AXIS_CPU2FPGA_44_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_45_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_45_tready : in std_logic;
		M_AXIS_CPU2FPGA_45_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_46_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_46_tready : in std_logic;
		M_AXIS_CPU2FPGA_46_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_47_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_47_tready : in std_logic;
		M_AXIS_CPU2FPGA_47_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_48_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_48_tready : in std_logic;
		M_AXIS_CPU2FPGA_48_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_49_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_49_tready : in std_logic;
		M_AXIS_CPU2FPGA_49_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_50_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_50_tready : in std_logic;
		M_AXIS_CPU2FPGA_50_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_51_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_51_tready : in std_logic;
		M_AXIS_CPU2FPGA_51_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_52_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_52_tready : in std_logic;
		M_AXIS_CPU2FPGA_52_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_53_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_53_tready : in std_logic;
		M_AXIS_CPU2FPGA_53_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_54_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_54_tready : in std_logic;
		M_AXIS_CPU2FPGA_54_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_55_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_55_tready : in std_logic;
		M_AXIS_CPU2FPGA_55_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_56_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_56_tready : in std_logic;
		M_AXIS_CPU2FPGA_56_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_57_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_57_tready : in std_logic;
		M_AXIS_CPU2FPGA_57_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_58_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_58_tready : in std_logic;
		M_AXIS_CPU2FPGA_58_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_59_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_59_tready : in std_logic;
		M_AXIS_CPU2FPGA_59_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_60_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_60_tready : in std_logic;
		M_AXIS_CPU2FPGA_60_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_61_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_61_tready : in std_logic;
		M_AXIS_CPU2FPGA_61_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_62_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_62_tready : in std_logic;
		M_AXIS_CPU2FPGA_62_tvalid : out std_logic;
        
        M_AXIS_CPU2FPGA_63_tdata  : out std_logic_vector(31 downto 0);
		M_AXIS_CPU2FPGA_63_tready : in std_logic;
		M_AXIS_CPU2FPGA_63_tvalid : out std_logic;
        

		-- FPGA to CPU inputs

        S_AXIS_FPGA2CPU_00_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_00_tready : out std_logic;
		S_AXIS_FPGA2CPU_00_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_01_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_01_tready : out std_logic;
		S_AXIS_FPGA2CPU_01_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_02_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_02_tready : out std_logic;
		S_AXIS_FPGA2CPU_02_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_03_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_03_tready : out std_logic;
		S_AXIS_FPGA2CPU_03_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_04_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_04_tready : out std_logic;
		S_AXIS_FPGA2CPU_04_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_05_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_05_tready : out std_logic;
		S_AXIS_FPGA2CPU_05_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_06_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_06_tready : out std_logic;
		S_AXIS_FPGA2CPU_06_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_07_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_07_tready : out std_logic;
		S_AXIS_FPGA2CPU_07_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_08_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_08_tready : out std_logic;
		S_AXIS_FPGA2CPU_08_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_09_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_09_tready : out std_logic;
		S_AXIS_FPGA2CPU_09_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_10_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_10_tready : out std_logic;
		S_AXIS_FPGA2CPU_10_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_11_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_11_tready : out std_logic;
		S_AXIS_FPGA2CPU_11_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_12_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_12_tready : out std_logic;
		S_AXIS_FPGA2CPU_12_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_13_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_13_tready : out std_logic;
		S_AXIS_FPGA2CPU_13_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_14_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_14_tready : out std_logic;
		S_AXIS_FPGA2CPU_14_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_15_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_15_tready : out std_logic;
		S_AXIS_FPGA2CPU_15_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_16_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_16_tready : out std_logic;
		S_AXIS_FPGA2CPU_16_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_17_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_17_tready : out std_logic;
		S_AXIS_FPGA2CPU_17_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_18_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_18_tready : out std_logic;
		S_AXIS_FPGA2CPU_18_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_19_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_19_tready : out std_logic;
		S_AXIS_FPGA2CPU_19_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_20_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_20_tready : out std_logic;
		S_AXIS_FPGA2CPU_20_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_21_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_21_tready : out std_logic;
		S_AXIS_FPGA2CPU_21_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_22_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_22_tready : out std_logic;
		S_AXIS_FPGA2CPU_22_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_23_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_23_tready : out std_logic;
		S_AXIS_FPGA2CPU_23_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_24_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_24_tready : out std_logic;
		S_AXIS_FPGA2CPU_24_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_25_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_25_tready : out std_logic;
		S_AXIS_FPGA2CPU_25_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_26_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_26_tready : out std_logic;
		S_AXIS_FPGA2CPU_26_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_27_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_27_tready : out std_logic;
		S_AXIS_FPGA2CPU_27_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_28_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_28_tready : out std_logic;
		S_AXIS_FPGA2CPU_28_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_29_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_29_tready : out std_logic;
		S_AXIS_FPGA2CPU_29_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_30_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_30_tready : out std_logic;
		S_AXIS_FPGA2CPU_30_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_31_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_31_tready : out std_logic;
		S_AXIS_FPGA2CPU_31_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_32_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_32_tready : out std_logic;
		S_AXIS_FPGA2CPU_32_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_33_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_33_tready : out std_logic;
		S_AXIS_FPGA2CPU_33_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_34_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_34_tready : out std_logic;
		S_AXIS_FPGA2CPU_34_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_35_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_35_tready : out std_logic;
		S_AXIS_FPGA2CPU_35_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_36_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_36_tready : out std_logic;
		S_AXIS_FPGA2CPU_36_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_37_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_37_tready : out std_logic;
		S_AXIS_FPGA2CPU_37_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_38_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_38_tready : out std_logic;
		S_AXIS_FPGA2CPU_38_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_39_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_39_tready : out std_logic;
		S_AXIS_FPGA2CPU_39_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_40_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_40_tready : out std_logic;
		S_AXIS_FPGA2CPU_40_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_41_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_41_tready : out std_logic;
		S_AXIS_FPGA2CPU_41_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_42_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_42_tready : out std_logic;
		S_AXIS_FPGA2CPU_42_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_43_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_43_tready : out std_logic;
		S_AXIS_FPGA2CPU_43_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_44_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_44_tready : out std_logic;
		S_AXIS_FPGA2CPU_44_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_45_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_45_tready : out std_logic;
		S_AXIS_FPGA2CPU_45_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_46_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_46_tready : out std_logic;
		S_AXIS_FPGA2CPU_46_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_47_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_47_tready : out std_logic;
		S_AXIS_FPGA2CPU_47_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_48_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_48_tready : out std_logic;
		S_AXIS_FPGA2CPU_48_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_49_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_49_tready : out std_logic;
		S_AXIS_FPGA2CPU_49_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_50_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_50_tready : out std_logic;
		S_AXIS_FPGA2CPU_50_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_51_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_51_tready : out std_logic;
		S_AXIS_FPGA2CPU_51_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_52_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_52_tready : out std_logic;
		S_AXIS_FPGA2CPU_52_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_53_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_53_tready : out std_logic;
		S_AXIS_FPGA2CPU_53_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_54_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_54_tready : out std_logic;
		S_AXIS_FPGA2CPU_54_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_55_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_55_tready : out std_logic;
		S_AXIS_FPGA2CPU_55_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_56_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_56_tready : out std_logic;
		S_AXIS_FPGA2CPU_56_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_57_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_57_tready : out std_logic;
		S_AXIS_FPGA2CPU_57_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_58_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_58_tready : out std_logic;
		S_AXIS_FPGA2CPU_58_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_59_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_59_tready : out std_logic;
		S_AXIS_FPGA2CPU_59_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_60_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_60_tready : out std_logic;
		S_AXIS_FPGA2CPU_60_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_61_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_61_tready : out std_logic;
		S_AXIS_FPGA2CPU_61_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_62_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_62_tready : out std_logic;
		S_AXIS_FPGA2CPU_62_tvalid : in std_logic := '1';
        
        S_AXIS_FPGA2CPU_63_tdata  : in std_logic_vector(31 downto 0) := (others => '0');
		S_AXIS_FPGA2CPU_63_tready : out std_logic;
		S_AXIS_FPGA2CPU_63_tvalid : in std_logic := '1';
        
		------------------------------------------------------------------------
		-- INTERFACE WITH IMPERIX FIRMWARE IP
		------------------------------------------------------------------------

		-- SBIO

        SBIO_BUS_addr  : in  std_logic_vector(9 downto 0);
		SBIO_BUS_we    : in  std_logic;
		SBIO_BUS_wdata : in  std_logic_vector(15 downto 0);
		SBIO_BUS_rdata : out std_logic_vector(15 downto 0);
        
        -- Timing pulses
        
        adc_done_pulse_in   : in std_logic;
        data_valid_pulse_in : in std_logic;
		data_reading_in     : in std_logic;

		-- Main clock running at 250 MHz
		clk : in std_logic
	);
end ix_64_axis_interface;

architecture impl of ix_64_axis_interface is

	ATTRIBUTE X_INTERFACE_INFO : STRING;
	ATTRIBUTE X_INTERFACE_PARAMETER : STRING;
	ATTRIBUTE X_INTERFACE_INFO of clk: SIGNAL is "xilinx.com:signal:clock:1.0 clk CLK";

    -- SBIO interface

    ATTRIBUTE X_INTERFACE_INFO of SBIO_BUS_addr:  SIGNAL is "imperix.ch:ix:sbio_bus:1.0 SBIO_BUS sb_addr";
	ATTRIBUTE X_INTERFACE_INFO of SBIO_BUS_we:    SIGNAL is "imperix.ch:ix:sbio_bus:1.0 SBIO_BUS sb_we";
	ATTRIBUTE X_INTERFACE_INFO of SBIO_BUS_wdata: SIGNAL is "imperix.ch:ix:sbio_bus:1.0 SBIO_BUS sb_wdata";
	ATTRIBUTE X_INTERFACE_INFO of SBIO_BUS_rdata: SIGNAL is "imperix.ch:ix:sbio_bus:1.0 SBIO_BUS sb_rdata";
	    
	-- SBO registers
	type t_sbois is array (0 to 127) of std_logic_vector(15 downto 0);
	signal r_sbo : t_sbois;
	signal r_data_valid : std_logic := '0';

    signal r_S_AXIS_FPGA2CPU_tready: std_logic;
    signal r_adc_done : std_logic := '0';

    -- SBIO-related signals

	type t_addr_low is array (0 to 7) of std_logic_vector(3 downto 0);
    signal r_addr_low : t_addr_low;

	type t_addr_high is array (0 to 7) of std_logic_vector(3 downto 0);
    signal r_addr_high : t_addr_high;

    signal r_addr     : natural range 0 to 127;
    signal r_addr_ff  : natural range 0 to 127;
    signal r_addr_ff2 : natural range 0 to 127;
	
    signal r_we  :	std_logic;

	type t_wdata is array (0 to 7) of std_logic_vector(15 downto 0);
    signal r_wdata : t_wdata;
	
	type t_addr is array (0 to 7) of natural range 0 to 15;
    signal w_addr : t_addr;

	type t_bank is array (0 to 7) of natural range 0 to 15;
    signal w_bank : t_bank;

    type type_sbo_bank is array(natural range 0 to 15) of std_logic_vector(15 downto 0);
	type t_sbo_bank is array (0 to 7) of type_sbo_bank;
	signal r_sbo_bank : t_sbo_bank;

    type type_sbi is array(natural range 0 to 127) of std_logic_vector(15 downto 0);
    signal r_sbi : type_sbi;

    attribute KEEP : string;
    attribute KEEP of r_addr_low  : signal is "true";
    attribute KEEP of r_addr_high  : signal is "true";
    attribute KEEP of r_wdata  : signal is "true";

    attribute SAVE : string;
    attribute SAVE of r_addr_low  : signal is "true";
    attribute SAVE of r_addr_high  : signal is "true";
    attribute SAVE of r_wdata  : signal is "true";

begin

	GENERATE_FOR: for ii in 0 to 7 generate
		w_addr(ii) <= to_integer(unsigned(r_addr_low(ii)));
		w_bank(ii) <= to_integer(unsigned(r_addr_high(ii)));
	end generate GENERATE_FOR;

	A : process(clk)
	begin
		if rising_edge(clk) then
			r_we    <= SBIO_BUS_we;

			r_addr <= to_integer(unsigned(SBIO_BUS_addr(7 downto 0)));
			r_addr_ff <= r_addr;
			r_addr_ff2 <= r_addr_ff;
			SBIO_BUS_rdata <= r_sbi(r_addr_ff2); -- latency of 4
			
			for i in 0 to 7 loop
				r_wdata(i) <= SBIO_BUS_wdata;
				r_addr_low(i) <= SBIO_BUS_addr(3 downto 0);
				r_addr_high(i) <= SBIO_BUS_addr(7 downto 4);
				
				if (r_we = '1') and (w_bank(i) = i) then
					r_sbo_bank(i)(w_addr(i)) <= r_wdata(i);
				end if;
			end loop;
		end if;
	end process A;

    B : process(clk)
	begin
		if rising_edge(clk) then
			if data_valid_pulse_in = '1' then
				for i in 0 to 7 loop
					for j in 0 to 15 loop
						r_sbo((16*i)+j)  <= r_sbo_bank(i)(j);
					end loop;
				end loop;
			end if;
        end if;
    end process B;
    
    P : process(clk)
	begin
		if rising_edge(clk) then
            -- ADC Input
            r_data_valid <= '0'; -- default
            r_adc_done <= adc_done_pulse_in;
            if r_adc_done = '1' then -- sampled values are available in ADC registers
                r_data_valid <= '1';
            end if;
		end if;
	end process P;

	------------------------------------------------------------------------
	-- CPU2FPGA output streams
	------------------------------------------------------------------------
	P_CPU2FPGA_AXIS : process(clk)
	begin
        if rising_edge(clk) then
            -- CPU2FPGA 00: 32-bit data using SBO_00 and SBO_01
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_00_tvalid <= '1';
                M_AXIS_CPU2FPGA_00_tdata <= r_sbo(1) & r_sbo(0);
            else
                if M_AXIS_CPU2FPGA_00_tready = '1' then
                    M_AXIS_CPU2FPGA_00_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 01: 32-bit data using SBO_02 and SBO_03
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_01_tvalid <= '1';
                M_AXIS_CPU2FPGA_01_tdata <= r_sbo(3) & r_sbo(2);
            else
                if M_AXIS_CPU2FPGA_01_tready = '1' then
                    M_AXIS_CPU2FPGA_01_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 02: 32-bit data using SBO_04 and SBO_05
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_02_tvalid <= '1';
                M_AXIS_CPU2FPGA_02_tdata <= r_sbo(5) & r_sbo(4);
            else
                if M_AXIS_CPU2FPGA_02_tready = '1' then
                    M_AXIS_CPU2FPGA_02_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 03: 32-bit data using SBO_06 and SBO_07
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_03_tvalid <= '1';
                M_AXIS_CPU2FPGA_03_tdata <= r_sbo(7) & r_sbo(6);
            else
                if M_AXIS_CPU2FPGA_03_tready = '1' then
                    M_AXIS_CPU2FPGA_03_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 04: 32-bit data using SBO_08 and SBO_09
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_04_tvalid <= '1';
                M_AXIS_CPU2FPGA_04_tdata <= r_sbo(9) & r_sbo(8);
            else
                if M_AXIS_CPU2FPGA_04_tready = '1' then
                    M_AXIS_CPU2FPGA_04_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 05: 32-bit data using SBO_10 and SBO_11
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_05_tvalid <= '1';
                M_AXIS_CPU2FPGA_05_tdata <= r_sbo(11) & r_sbo(10);
            else
                if M_AXIS_CPU2FPGA_05_tready = '1' then
                    M_AXIS_CPU2FPGA_05_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 06: 32-bit data using SBO_12 and SBO_13
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_06_tvalid <= '1';
                M_AXIS_CPU2FPGA_06_tdata <= r_sbo(13) & r_sbo(12);
            else
                if M_AXIS_CPU2FPGA_06_tready = '1' then
                    M_AXIS_CPU2FPGA_06_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 07: 32-bit data using SBO_14 and SBO_15
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_07_tvalid <= '1';
                M_AXIS_CPU2FPGA_07_tdata <= r_sbo(15) & r_sbo(14);
            else
                if M_AXIS_CPU2FPGA_07_tready = '1' then
                    M_AXIS_CPU2FPGA_07_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 08: 32-bit data using SBO_16 and SBO_17
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_08_tvalid <= '1';
                M_AXIS_CPU2FPGA_08_tdata <= r_sbo(17) & r_sbo(16);
            else
                if M_AXIS_CPU2FPGA_08_tready = '1' then
                    M_AXIS_CPU2FPGA_08_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 09: 32-bit data using SBO_18 and SBO_19
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_09_tvalid <= '1';
                M_AXIS_CPU2FPGA_09_tdata <= r_sbo(19) & r_sbo(18);
            else
                if M_AXIS_CPU2FPGA_09_tready = '1' then
                    M_AXIS_CPU2FPGA_09_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 10: 32-bit data using SBO_20 and SBO_21
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_10_tvalid <= '1';
                M_AXIS_CPU2FPGA_10_tdata <= r_sbo(21) & r_sbo(20);
            else
                if M_AXIS_CPU2FPGA_10_tready = '1' then
                    M_AXIS_CPU2FPGA_10_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 11: 32-bit data using SBO_22 and SBO_23
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_11_tvalid <= '1';
                M_AXIS_CPU2FPGA_11_tdata <= r_sbo(23) & r_sbo(22);
            else
                if M_AXIS_CPU2FPGA_11_tready = '1' then
                    M_AXIS_CPU2FPGA_11_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 12: 32-bit data using SBO_24 and SBO_25
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_12_tvalid <= '1';
                M_AXIS_CPU2FPGA_12_tdata <= r_sbo(25) & r_sbo(24);
            else
                if M_AXIS_CPU2FPGA_12_tready = '1' then
                    M_AXIS_CPU2FPGA_12_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 13: 32-bit data using SBO_26 and SBO_27
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_13_tvalid <= '1';
                M_AXIS_CPU2FPGA_13_tdata <= r_sbo(27) & r_sbo(26);
            else
                if M_AXIS_CPU2FPGA_13_tready = '1' then
                    M_AXIS_CPU2FPGA_13_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 14: 32-bit data using SBO_28 and SBO_29
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_14_tvalid <= '1';
                M_AXIS_CPU2FPGA_14_tdata <= r_sbo(29) & r_sbo(28);
            else
                if M_AXIS_CPU2FPGA_14_tready = '1' then
                    M_AXIS_CPU2FPGA_14_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 15: 32-bit data using SBO_30 and SBO_31
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_15_tvalid <= '1';
                M_AXIS_CPU2FPGA_15_tdata <= r_sbo(31) & r_sbo(30);
            else
                if M_AXIS_CPU2FPGA_15_tready = '1' then
                    M_AXIS_CPU2FPGA_15_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 16: 32-bit data using SBO_32 and SBO_33
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_16_tvalid <= '1';
                M_AXIS_CPU2FPGA_16_tdata <= r_sbo(33) & r_sbo(32);
            else
                if M_AXIS_CPU2FPGA_16_tready = '1' then
                    M_AXIS_CPU2FPGA_16_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 17: 32-bit data using SBO_34 and SBO_35
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_17_tvalid <= '1';
                M_AXIS_CPU2FPGA_17_tdata <= r_sbo(35) & r_sbo(34);
            else
                if M_AXIS_CPU2FPGA_17_tready = '1' then
                    M_AXIS_CPU2FPGA_17_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 18: 32-bit data using SBO_36 and SBO_37
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_18_tvalid <= '1';
                M_AXIS_CPU2FPGA_18_tdata <= r_sbo(37) & r_sbo(36);
            else
                if M_AXIS_CPU2FPGA_18_tready = '1' then
                    M_AXIS_CPU2FPGA_18_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 19: 32-bit data using SBO_38 and SBO_39
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_19_tvalid <= '1';
                M_AXIS_CPU2FPGA_19_tdata <= r_sbo(39) & r_sbo(38);
            else
                if M_AXIS_CPU2FPGA_19_tready = '1' then
                    M_AXIS_CPU2FPGA_19_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 20: 32-bit data using SBO_40 and SBO_41
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_20_tvalid <= '1';
                M_AXIS_CPU2FPGA_20_tdata <= r_sbo(41) & r_sbo(40);
            else
                if M_AXIS_CPU2FPGA_20_tready = '1' then
                    M_AXIS_CPU2FPGA_20_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 21: 32-bit data using SBO_42 and SBO_43
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_21_tvalid <= '1';
                M_AXIS_CPU2FPGA_21_tdata <= r_sbo(43) & r_sbo(42);
            else
                if M_AXIS_CPU2FPGA_21_tready = '1' then
                    M_AXIS_CPU2FPGA_21_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 22: 32-bit data using SBO_44 and SBO_45
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_22_tvalid <= '1';
                M_AXIS_CPU2FPGA_22_tdata <= r_sbo(45) & r_sbo(44);
            else
                if M_AXIS_CPU2FPGA_22_tready = '1' then
                    M_AXIS_CPU2FPGA_22_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 23: 32-bit data using SBO_46 and SBO_47
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_23_tvalid <= '1';
                M_AXIS_CPU2FPGA_23_tdata <= r_sbo(47) & r_sbo(46);
            else
                if M_AXIS_CPU2FPGA_23_tready = '1' then
                    M_AXIS_CPU2FPGA_23_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 24: 32-bit data using SBO_48 and SBO_49
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_24_tvalid <= '1';
                M_AXIS_CPU2FPGA_24_tdata <= r_sbo(49) & r_sbo(48);
            else
                if M_AXIS_CPU2FPGA_24_tready = '1' then
                    M_AXIS_CPU2FPGA_24_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 25: 32-bit data using SBO_50 and SBO_51
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_25_tvalid <= '1';
                M_AXIS_CPU2FPGA_25_tdata <= r_sbo(51) & r_sbo(50);
            else
                if M_AXIS_CPU2FPGA_25_tready = '1' then
                    M_AXIS_CPU2FPGA_25_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 26: 32-bit data using SBO_52 and SBO_53
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_26_tvalid <= '1';
                M_AXIS_CPU2FPGA_26_tdata <= r_sbo(53) & r_sbo(52);
            else
                if M_AXIS_CPU2FPGA_26_tready = '1' then
                    M_AXIS_CPU2FPGA_26_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 27: 32-bit data using SBO_54 and SBO_55
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_27_tvalid <= '1';
                M_AXIS_CPU2FPGA_27_tdata <= r_sbo(55) & r_sbo(54);
            else
                if M_AXIS_CPU2FPGA_27_tready = '1' then
                    M_AXIS_CPU2FPGA_27_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 28: 32-bit data using SBO_56 and SBO_57
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_28_tvalid <= '1';
                M_AXIS_CPU2FPGA_28_tdata <= r_sbo(57) & r_sbo(56);
            else
                if M_AXIS_CPU2FPGA_28_tready = '1' then
                    M_AXIS_CPU2FPGA_28_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 29: 32-bit data using SBO_58 and SBO_59
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_29_tvalid <= '1';
                M_AXIS_CPU2FPGA_29_tdata <= r_sbo(59) & r_sbo(58);
            else
                if M_AXIS_CPU2FPGA_29_tready = '1' then
                    M_AXIS_CPU2FPGA_29_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 30: 32-bit data using SBO_60 and SBO_61
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_30_tvalid <= '1';
                M_AXIS_CPU2FPGA_30_tdata <= r_sbo(61) & r_sbo(60);
            else
                if M_AXIS_CPU2FPGA_30_tready = '1' then
                    M_AXIS_CPU2FPGA_30_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 31: 32-bit data using SBO_62 and SBO_63
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_31_tvalid <= '1';
                M_AXIS_CPU2FPGA_31_tdata <= r_sbo(63) & r_sbo(62);
            else
                if M_AXIS_CPU2FPGA_31_tready = '1' then
                    M_AXIS_CPU2FPGA_31_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 32: 32-bit data using SBO_64 and SBO_65
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_32_tvalid <= '1';
                M_AXIS_CPU2FPGA_32_tdata <= r_sbo(65) & r_sbo(64);
            else
                if M_AXIS_CPU2FPGA_32_tready = '1' then
                    M_AXIS_CPU2FPGA_32_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 33: 32-bit data using SBO_66 and SBO_67
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_33_tvalid <= '1';
                M_AXIS_CPU2FPGA_33_tdata <= r_sbo(67) & r_sbo(66);
            else
                if M_AXIS_CPU2FPGA_33_tready = '1' then
                    M_AXIS_CPU2FPGA_33_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 34: 32-bit data using SBO_68 and SBO_69
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_34_tvalid <= '1';
                M_AXIS_CPU2FPGA_34_tdata <= r_sbo(69) & r_sbo(68);
            else
                if M_AXIS_CPU2FPGA_34_tready = '1' then
                    M_AXIS_CPU2FPGA_34_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 35: 32-bit data using SBO_70 and SBO_71
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_35_tvalid <= '1';
                M_AXIS_CPU2FPGA_35_tdata <= r_sbo(71) & r_sbo(70);
            else
                if M_AXIS_CPU2FPGA_35_tready = '1' then
                    M_AXIS_CPU2FPGA_35_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 36: 32-bit data using SBO_72 and SBO_73
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_36_tvalid <= '1';
                M_AXIS_CPU2FPGA_36_tdata <= r_sbo(73) & r_sbo(72);
            else
                if M_AXIS_CPU2FPGA_36_tready = '1' then
                    M_AXIS_CPU2FPGA_36_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 37: 32-bit data using SBO_74 and SBO_75
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_37_tvalid <= '1';
                M_AXIS_CPU2FPGA_37_tdata <= r_sbo(75) & r_sbo(74);
            else
                if M_AXIS_CPU2FPGA_37_tready = '1' then
                    M_AXIS_CPU2FPGA_37_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 38: 32-bit data using SBO_76 and SBO_77
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_38_tvalid <= '1';
                M_AXIS_CPU2FPGA_38_tdata <= r_sbo(77) & r_sbo(76);
            else
                if M_AXIS_CPU2FPGA_38_tready = '1' then
                    M_AXIS_CPU2FPGA_38_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 39: 32-bit data using SBO_78 and SBO_79
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_39_tvalid <= '1';
                M_AXIS_CPU2FPGA_39_tdata <= r_sbo(79) & r_sbo(78);
            else
                if M_AXIS_CPU2FPGA_39_tready = '1' then
                    M_AXIS_CPU2FPGA_39_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 40: 32-bit data using SBO_80 and SBO_81
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_40_tvalid <= '1';
                M_AXIS_CPU2FPGA_40_tdata <= r_sbo(81) & r_sbo(80);
            else
                if M_AXIS_CPU2FPGA_40_tready = '1' then
                    M_AXIS_CPU2FPGA_40_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 41: 32-bit data using SBO_82 and SBO_83
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_41_tvalid <= '1';
                M_AXIS_CPU2FPGA_41_tdata <= r_sbo(83) & r_sbo(82);
            else
                if M_AXIS_CPU2FPGA_41_tready = '1' then
                    M_AXIS_CPU2FPGA_41_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 42: 32-bit data using SBO_84 and SBO_85
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_42_tvalid <= '1';
                M_AXIS_CPU2FPGA_42_tdata <= r_sbo(85) & r_sbo(84);
            else
                if M_AXIS_CPU2FPGA_42_tready = '1' then
                    M_AXIS_CPU2FPGA_42_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 43: 32-bit data using SBO_86 and SBO_87
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_43_tvalid <= '1';
                M_AXIS_CPU2FPGA_43_tdata <= r_sbo(87) & r_sbo(86);
            else
                if M_AXIS_CPU2FPGA_43_tready = '1' then
                    M_AXIS_CPU2FPGA_43_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 44: 32-bit data using SBO_88 and SBO_89
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_44_tvalid <= '1';
                M_AXIS_CPU2FPGA_44_tdata <= r_sbo(89) & r_sbo(88);
            else
                if M_AXIS_CPU2FPGA_44_tready = '1' then
                    M_AXIS_CPU2FPGA_44_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 45: 32-bit data using SBO_90 and SBO_91
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_45_tvalid <= '1';
                M_AXIS_CPU2FPGA_45_tdata <= r_sbo(91) & r_sbo(90);
            else
                if M_AXIS_CPU2FPGA_45_tready = '1' then
                    M_AXIS_CPU2FPGA_45_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 46: 32-bit data using SBO_92 and SBO_93
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_46_tvalid <= '1';
                M_AXIS_CPU2FPGA_46_tdata <= r_sbo(93) & r_sbo(92);
            else
                if M_AXIS_CPU2FPGA_46_tready = '1' then
                    M_AXIS_CPU2FPGA_46_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 47: 32-bit data using SBO_94 and SBO_95
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_47_tvalid <= '1';
                M_AXIS_CPU2FPGA_47_tdata <= r_sbo(95) & r_sbo(94);
            else
                if M_AXIS_CPU2FPGA_47_tready = '1' then
                    M_AXIS_CPU2FPGA_47_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 48: 32-bit data using SBO_96 and SBO_97
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_48_tvalid <= '1';
                M_AXIS_CPU2FPGA_48_tdata <= r_sbo(97) & r_sbo(96);
            else
                if M_AXIS_CPU2FPGA_48_tready = '1' then
                    M_AXIS_CPU2FPGA_48_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 49: 32-bit data using SBO_98 and SBO_99
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_49_tvalid <= '1';
                M_AXIS_CPU2FPGA_49_tdata <= r_sbo(99) & r_sbo(98);
            else
                if M_AXIS_CPU2FPGA_49_tready = '1' then
                    M_AXIS_CPU2FPGA_49_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 50: 32-bit data using SBO_100 and SBO_101
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_50_tvalid <= '1';
                M_AXIS_CPU2FPGA_50_tdata <= r_sbo(101) & r_sbo(100);
            else
                if M_AXIS_CPU2FPGA_50_tready = '1' then
                    M_AXIS_CPU2FPGA_50_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 51: 32-bit data using SBO_102 and SBO_103
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_51_tvalid <= '1';
                M_AXIS_CPU2FPGA_51_tdata <= r_sbo(103) & r_sbo(102);
            else
                if M_AXIS_CPU2FPGA_51_tready = '1' then
                    M_AXIS_CPU2FPGA_51_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 52: 32-bit data using SBO_104 and SBO_105
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_52_tvalid <= '1';
                M_AXIS_CPU2FPGA_52_tdata <= r_sbo(105) & r_sbo(104);
            else
                if M_AXIS_CPU2FPGA_52_tready = '1' then
                    M_AXIS_CPU2FPGA_52_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 53: 32-bit data using SBO_106 and SBO_107
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_53_tvalid <= '1';
                M_AXIS_CPU2FPGA_53_tdata <= r_sbo(107) & r_sbo(106);
            else
                if M_AXIS_CPU2FPGA_53_tready = '1' then
                    M_AXIS_CPU2FPGA_53_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 54: 32-bit data using SBO_108 and SBO_109
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_54_tvalid <= '1';
                M_AXIS_CPU2FPGA_54_tdata <= r_sbo(109) & r_sbo(108);
            else
                if M_AXIS_CPU2FPGA_54_tready = '1' then
                    M_AXIS_CPU2FPGA_54_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 55: 32-bit data using SBO_110 and SBO_111
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_55_tvalid <= '1';
                M_AXIS_CPU2FPGA_55_tdata <= r_sbo(111) & r_sbo(110);
            else
                if M_AXIS_CPU2FPGA_55_tready = '1' then
                    M_AXIS_CPU2FPGA_55_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 56: 32-bit data using SBO_112 and SBO_113
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_56_tvalid <= '1';
                M_AXIS_CPU2FPGA_56_tdata <= r_sbo(113) & r_sbo(112);
            else
                if M_AXIS_CPU2FPGA_56_tready = '1' then
                    M_AXIS_CPU2FPGA_56_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 57: 32-bit data using SBO_114 and SBO_115
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_57_tvalid <= '1';
                M_AXIS_CPU2FPGA_57_tdata <= r_sbo(115) & r_sbo(114);
            else
                if M_AXIS_CPU2FPGA_57_tready = '1' then
                    M_AXIS_CPU2FPGA_57_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 58: 32-bit data using SBO_116 and SBO_117
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_58_tvalid <= '1';
                M_AXIS_CPU2FPGA_58_tdata <= r_sbo(117) & r_sbo(116);
            else
                if M_AXIS_CPU2FPGA_58_tready = '1' then
                    M_AXIS_CPU2FPGA_58_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 59: 32-bit data using SBO_118 and SBO_119
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_59_tvalid <= '1';
                M_AXIS_CPU2FPGA_59_tdata <= r_sbo(119) & r_sbo(118);
            else
                if M_AXIS_CPU2FPGA_59_tready = '1' then
                    M_AXIS_CPU2FPGA_59_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 60: 32-bit data using SBO_120 and SBO_121
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_60_tvalid <= '1';
                M_AXIS_CPU2FPGA_60_tdata <= r_sbo(121) & r_sbo(120);
            else
                if M_AXIS_CPU2FPGA_60_tready = '1' then
                    M_AXIS_CPU2FPGA_60_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 61: 32-bit data using SBO_122 and SBO_123
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_61_tvalid <= '1';
                M_AXIS_CPU2FPGA_61_tdata <= r_sbo(123) & r_sbo(122);
            else
                if M_AXIS_CPU2FPGA_61_tready = '1' then
                    M_AXIS_CPU2FPGA_61_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 62: 32-bit data using SBO_124 and SBO_125
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_62_tvalid <= '1';
                M_AXIS_CPU2FPGA_62_tdata <= r_sbo(125) & r_sbo(124);
            else
                if M_AXIS_CPU2FPGA_62_tready = '1' then
                    M_AXIS_CPU2FPGA_62_tvalid <= '0';
                end if;
            end if;
        
            -- CPU2FPGA 63: 32-bit data using SBO_126 and SBO_127
            if r_data_valid = '1' then
                M_AXIS_CPU2FPGA_63_tvalid <= '1';
                M_AXIS_CPU2FPGA_63_tdata <= r_sbo(127) & r_sbo(126);
            else
                if M_AXIS_CPU2FPGA_63_tready = '1' then
                    M_AXIS_CPU2FPGA_63_tvalid <= '0';
                end if;
            end if;
        
        end if;
    end process P_CPU2FPGA_AXIS;

	------------------------------------------------------------------------
	-- FPGA2CPU input streams
	------------------------------------------------------------------------

    S_AXIS_FPGA2CPU_00_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_01_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_02_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_03_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_04_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_05_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_06_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_07_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_08_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_09_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_10_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_11_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_12_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_13_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_14_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_15_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_16_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_17_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_18_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_19_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_20_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_21_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_22_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_23_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_24_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_25_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_26_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_27_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_28_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_29_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_30_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_31_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_32_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_33_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_34_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_35_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_36_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_37_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_38_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_39_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_40_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_41_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_42_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_43_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_44_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_45_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_46_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_47_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_48_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_49_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_50_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_51_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_52_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_53_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_54_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_55_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_56_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_57_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_58_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_59_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_60_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_61_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_62_tready <= r_S_AXIS_FPGA2CPU_tready;  
    S_AXIS_FPGA2CPU_63_tready <= r_S_AXIS_FPGA2CPU_tready;  

    P_FPGA2CPU_AXIS : process(clk)
	begin
        if rising_edge(clk) then
            -- accept SBI data only when not reading
            -- EXCEPT for one cycle, but OK because
            -- reading with latency of 4
			r_S_AXIS_FPGA2CPU_tready <= not data_reading_in;

            -- FPGA2CPU 00: 32-bit data using SBI_00 and SBI_01
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_00_tvalid = '1') then
                r_sbi(0) <= S_AXIS_FPGA2CPU_00_tdata(15 downto 0);
                r_sbi(1) <= S_AXIS_FPGA2CPU_00_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 01: 32-bit data using SBI_02 and SBI_03
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_01_tvalid = '1') then
                r_sbi(2) <= S_AXIS_FPGA2CPU_01_tdata(15 downto 0);
                r_sbi(3) <= S_AXIS_FPGA2CPU_01_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 02: 32-bit data using SBI_04 and SBI_05
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_02_tvalid = '1') then
                r_sbi(4) <= S_AXIS_FPGA2CPU_02_tdata(15 downto 0);
                r_sbi(5) <= S_AXIS_FPGA2CPU_02_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 03: 32-bit data using SBI_06 and SBI_07
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_03_tvalid = '1') then
                r_sbi(6) <= S_AXIS_FPGA2CPU_03_tdata(15 downto 0);
                r_sbi(7) <= S_AXIS_FPGA2CPU_03_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 04: 32-bit data using SBI_08 and SBI_09
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_04_tvalid = '1') then
                r_sbi(8) <= S_AXIS_FPGA2CPU_04_tdata(15 downto 0);
                r_sbi(9) <= S_AXIS_FPGA2CPU_04_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 05: 32-bit data using SBI_10 and SBI_11
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_05_tvalid = '1') then
                r_sbi(10) <= S_AXIS_FPGA2CPU_05_tdata(15 downto 0);
                r_sbi(11) <= S_AXIS_FPGA2CPU_05_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 06: 32-bit data using SBI_12 and SBI_13
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_06_tvalid = '1') then
                r_sbi(12) <= S_AXIS_FPGA2CPU_06_tdata(15 downto 0);
                r_sbi(13) <= S_AXIS_FPGA2CPU_06_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 07: 32-bit data using SBI_14 and SBI_15
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_07_tvalid = '1') then
                r_sbi(14) <= S_AXIS_FPGA2CPU_07_tdata(15 downto 0);
                r_sbi(15) <= S_AXIS_FPGA2CPU_07_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 08: 32-bit data using SBI_16 and SBI_17
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_08_tvalid = '1') then
                r_sbi(16) <= S_AXIS_FPGA2CPU_08_tdata(15 downto 0);
                r_sbi(17) <= S_AXIS_FPGA2CPU_08_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 09: 32-bit data using SBI_18 and SBI_19
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_09_tvalid = '1') then
                r_sbi(18) <= S_AXIS_FPGA2CPU_09_tdata(15 downto 0);
                r_sbi(19) <= S_AXIS_FPGA2CPU_09_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 10: 32-bit data using SBI_20 and SBI_21
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_10_tvalid = '1') then
                r_sbi(20) <= S_AXIS_FPGA2CPU_10_tdata(15 downto 0);
                r_sbi(21) <= S_AXIS_FPGA2CPU_10_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 11: 32-bit data using SBI_22 and SBI_23
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_11_tvalid = '1') then
                r_sbi(22) <= S_AXIS_FPGA2CPU_11_tdata(15 downto 0);
                r_sbi(23) <= S_AXIS_FPGA2CPU_11_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 12: 32-bit data using SBI_24 and SBI_25
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_12_tvalid = '1') then
                r_sbi(24) <= S_AXIS_FPGA2CPU_12_tdata(15 downto 0);
                r_sbi(25) <= S_AXIS_FPGA2CPU_12_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 13: 32-bit data using SBI_26 and SBI_27
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_13_tvalid = '1') then
                r_sbi(26) <= S_AXIS_FPGA2CPU_13_tdata(15 downto 0);
                r_sbi(27) <= S_AXIS_FPGA2CPU_13_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 14: 32-bit data using SBI_28 and SBI_29
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_14_tvalid = '1') then
                r_sbi(28) <= S_AXIS_FPGA2CPU_14_tdata(15 downto 0);
                r_sbi(29) <= S_AXIS_FPGA2CPU_14_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 15: 32-bit data using SBI_30 and SBI_31
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_15_tvalid = '1') then
                r_sbi(30) <= S_AXIS_FPGA2CPU_15_tdata(15 downto 0);
                r_sbi(31) <= S_AXIS_FPGA2CPU_15_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 16: 32-bit data using SBI_32 and SBI_33
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_16_tvalid = '1') then
                r_sbi(32) <= S_AXIS_FPGA2CPU_16_tdata(15 downto 0);
                r_sbi(33) <= S_AXIS_FPGA2CPU_16_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 17: 32-bit data using SBI_34 and SBI_35
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_17_tvalid = '1') then
                r_sbi(34) <= S_AXIS_FPGA2CPU_17_tdata(15 downto 0);
                r_sbi(35) <= S_AXIS_FPGA2CPU_17_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 18: 32-bit data using SBI_36 and SBI_37
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_18_tvalid = '1') then
                r_sbi(36) <= S_AXIS_FPGA2CPU_18_tdata(15 downto 0);
                r_sbi(37) <= S_AXIS_FPGA2CPU_18_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 19: 32-bit data using SBI_38 and SBI_39
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_19_tvalid = '1') then
                r_sbi(38) <= S_AXIS_FPGA2CPU_19_tdata(15 downto 0);
                r_sbi(39) <= S_AXIS_FPGA2CPU_19_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 20: 32-bit data using SBI_40 and SBI_41
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_20_tvalid = '1') then
                r_sbi(40) <= S_AXIS_FPGA2CPU_20_tdata(15 downto 0);
                r_sbi(41) <= S_AXIS_FPGA2CPU_20_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 21: 32-bit data using SBI_42 and SBI_43
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_21_tvalid = '1') then
                r_sbi(42) <= S_AXIS_FPGA2CPU_21_tdata(15 downto 0);
                r_sbi(43) <= S_AXIS_FPGA2CPU_21_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 22: 32-bit data using SBI_44 and SBI_45
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_22_tvalid = '1') then
                r_sbi(44) <= S_AXIS_FPGA2CPU_22_tdata(15 downto 0);
                r_sbi(45) <= S_AXIS_FPGA2CPU_22_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 23: 32-bit data using SBI_46 and SBI_47
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_23_tvalid = '1') then
                r_sbi(46) <= S_AXIS_FPGA2CPU_23_tdata(15 downto 0);
                r_sbi(47) <= S_AXIS_FPGA2CPU_23_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 24: 32-bit data using SBI_48 and SBI_49
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_24_tvalid = '1') then
                r_sbi(48) <= S_AXIS_FPGA2CPU_24_tdata(15 downto 0);
                r_sbi(49) <= S_AXIS_FPGA2CPU_24_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 25: 32-bit data using SBI_50 and SBI_51
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_25_tvalid = '1') then
                r_sbi(50) <= S_AXIS_FPGA2CPU_25_tdata(15 downto 0);
                r_sbi(51) <= S_AXIS_FPGA2CPU_25_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 26: 32-bit data using SBI_52 and SBI_53
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_26_tvalid = '1') then
                r_sbi(52) <= S_AXIS_FPGA2CPU_26_tdata(15 downto 0);
                r_sbi(53) <= S_AXIS_FPGA2CPU_26_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 27: 32-bit data using SBI_54 and SBI_55
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_27_tvalid = '1') then
                r_sbi(54) <= S_AXIS_FPGA2CPU_27_tdata(15 downto 0);
                r_sbi(55) <= S_AXIS_FPGA2CPU_27_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 28: 32-bit data using SBI_56 and SBI_57
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_28_tvalid = '1') then
                r_sbi(56) <= S_AXIS_FPGA2CPU_28_tdata(15 downto 0);
                r_sbi(57) <= S_AXIS_FPGA2CPU_28_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 29: 32-bit data using SBI_58 and SBI_59
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_29_tvalid = '1') then
                r_sbi(58) <= S_AXIS_FPGA2CPU_29_tdata(15 downto 0);
                r_sbi(59) <= S_AXIS_FPGA2CPU_29_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 30: 32-bit data using SBI_60 and SBI_61
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_30_tvalid = '1') then
                r_sbi(60) <= S_AXIS_FPGA2CPU_30_tdata(15 downto 0);
                r_sbi(61) <= S_AXIS_FPGA2CPU_30_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 31: 32-bit data using SBI_62 and SBI_63
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_31_tvalid = '1') then
                r_sbi(62) <= S_AXIS_FPGA2CPU_31_tdata(15 downto 0);
                r_sbi(63) <= S_AXIS_FPGA2CPU_31_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 32: 32-bit data using SBI_64 and SBI_65
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_32_tvalid = '1') then
                r_sbi(64) <= S_AXIS_FPGA2CPU_32_tdata(15 downto 0);
                r_sbi(65) <= S_AXIS_FPGA2CPU_32_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 33: 32-bit data using SBI_66 and SBI_67
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_33_tvalid = '1') then
                r_sbi(66) <= S_AXIS_FPGA2CPU_33_tdata(15 downto 0);
                r_sbi(67) <= S_AXIS_FPGA2CPU_33_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 34: 32-bit data using SBI_68 and SBI_69
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_34_tvalid = '1') then
                r_sbi(68) <= S_AXIS_FPGA2CPU_34_tdata(15 downto 0);
                r_sbi(69) <= S_AXIS_FPGA2CPU_34_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 35: 32-bit data using SBI_70 and SBI_71
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_35_tvalid = '1') then
                r_sbi(70) <= S_AXIS_FPGA2CPU_35_tdata(15 downto 0);
                r_sbi(71) <= S_AXIS_FPGA2CPU_35_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 36: 32-bit data using SBI_72 and SBI_73
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_36_tvalid = '1') then
                r_sbi(72) <= S_AXIS_FPGA2CPU_36_tdata(15 downto 0);
                r_sbi(73) <= S_AXIS_FPGA2CPU_36_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 37: 32-bit data using SBI_74 and SBI_75
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_37_tvalid = '1') then
                r_sbi(74) <= S_AXIS_FPGA2CPU_37_tdata(15 downto 0);
                r_sbi(75) <= S_AXIS_FPGA2CPU_37_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 38: 32-bit data using SBI_76 and SBI_77
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_38_tvalid = '1') then
                r_sbi(76) <= S_AXIS_FPGA2CPU_38_tdata(15 downto 0);
                r_sbi(77) <= S_AXIS_FPGA2CPU_38_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 39: 32-bit data using SBI_78 and SBI_79
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_39_tvalid = '1') then
                r_sbi(78) <= S_AXIS_FPGA2CPU_39_tdata(15 downto 0);
                r_sbi(79) <= S_AXIS_FPGA2CPU_39_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 40: 32-bit data using SBI_80 and SBI_81
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_40_tvalid = '1') then
                r_sbi(80) <= S_AXIS_FPGA2CPU_40_tdata(15 downto 0);
                r_sbi(81) <= S_AXIS_FPGA2CPU_40_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 41: 32-bit data using SBI_82 and SBI_83
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_41_tvalid = '1') then
                r_sbi(82) <= S_AXIS_FPGA2CPU_41_tdata(15 downto 0);
                r_sbi(83) <= S_AXIS_FPGA2CPU_41_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 42: 32-bit data using SBI_84 and SBI_85
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_42_tvalid = '1') then
                r_sbi(84) <= S_AXIS_FPGA2CPU_42_tdata(15 downto 0);
                r_sbi(85) <= S_AXIS_FPGA2CPU_42_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 43: 32-bit data using SBI_86 and SBI_87
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_43_tvalid = '1') then
                r_sbi(86) <= S_AXIS_FPGA2CPU_43_tdata(15 downto 0);
                r_sbi(87) <= S_AXIS_FPGA2CPU_43_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 44: 32-bit data using SBI_88 and SBI_89
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_44_tvalid = '1') then
                r_sbi(88) <= S_AXIS_FPGA2CPU_44_tdata(15 downto 0);
                r_sbi(89) <= S_AXIS_FPGA2CPU_44_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 45: 32-bit data using SBI_90 and SBI_91
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_45_tvalid = '1') then
                r_sbi(90) <= S_AXIS_FPGA2CPU_45_tdata(15 downto 0);
                r_sbi(91) <= S_AXIS_FPGA2CPU_45_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 46: 32-bit data using SBI_92 and SBI_93
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_46_tvalid = '1') then
                r_sbi(92) <= S_AXIS_FPGA2CPU_46_tdata(15 downto 0);
                r_sbi(93) <= S_AXIS_FPGA2CPU_46_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 47: 32-bit data using SBI_94 and SBI_95
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_47_tvalid = '1') then
                r_sbi(94) <= S_AXIS_FPGA2CPU_47_tdata(15 downto 0);
                r_sbi(95) <= S_AXIS_FPGA2CPU_47_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 48: 32-bit data using SBI_96 and SBI_97
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_48_tvalid = '1') then
                r_sbi(96) <= S_AXIS_FPGA2CPU_48_tdata(15 downto 0);
                r_sbi(97) <= S_AXIS_FPGA2CPU_48_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 49: 32-bit data using SBI_98 and SBI_99
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_49_tvalid = '1') then
                r_sbi(98) <= S_AXIS_FPGA2CPU_49_tdata(15 downto 0);
                r_sbi(99) <= S_AXIS_FPGA2CPU_49_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 50: 32-bit data using SBI_100 and SBI_101
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_50_tvalid = '1') then
                r_sbi(100) <= S_AXIS_FPGA2CPU_50_tdata(15 downto 0);
                r_sbi(101) <= S_AXIS_FPGA2CPU_50_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 51: 32-bit data using SBI_102 and SBI_103
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_51_tvalid = '1') then
                r_sbi(102) <= S_AXIS_FPGA2CPU_51_tdata(15 downto 0);
                r_sbi(103) <= S_AXIS_FPGA2CPU_51_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 52: 32-bit data using SBI_104 and SBI_105
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_52_tvalid = '1') then
                r_sbi(104) <= S_AXIS_FPGA2CPU_52_tdata(15 downto 0);
                r_sbi(105) <= S_AXIS_FPGA2CPU_52_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 53: 32-bit data using SBI_106 and SBI_107
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_53_tvalid = '1') then
                r_sbi(106) <= S_AXIS_FPGA2CPU_53_tdata(15 downto 0);
                r_sbi(107) <= S_AXIS_FPGA2CPU_53_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 54: 32-bit data using SBI_108 and SBI_109
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_54_tvalid = '1') then
                r_sbi(108) <= S_AXIS_FPGA2CPU_54_tdata(15 downto 0);
                r_sbi(109) <= S_AXIS_FPGA2CPU_54_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 55: 32-bit data using SBI_110 and SBI_111
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_55_tvalid = '1') then
                r_sbi(110) <= S_AXIS_FPGA2CPU_55_tdata(15 downto 0);
                r_sbi(111) <= S_AXIS_FPGA2CPU_55_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 56: 32-bit data using SBI_112 and SBI_113
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_56_tvalid = '1') then
                r_sbi(112) <= S_AXIS_FPGA2CPU_56_tdata(15 downto 0);
                r_sbi(113) <= S_AXIS_FPGA2CPU_56_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 57: 32-bit data using SBI_114 and SBI_115
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_57_tvalid = '1') then
                r_sbi(114) <= S_AXIS_FPGA2CPU_57_tdata(15 downto 0);
                r_sbi(115) <= S_AXIS_FPGA2CPU_57_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 58: 32-bit data using SBI_116 and SBI_117
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_58_tvalid = '1') then
                r_sbi(116) <= S_AXIS_FPGA2CPU_58_tdata(15 downto 0);
                r_sbi(117) <= S_AXIS_FPGA2CPU_58_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 59: 32-bit data using SBI_118 and SBI_119
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_59_tvalid = '1') then
                r_sbi(118) <= S_AXIS_FPGA2CPU_59_tdata(15 downto 0);
                r_sbi(119) <= S_AXIS_FPGA2CPU_59_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 60: 32-bit data using SBI_120 and SBI_121
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_60_tvalid = '1') then
                r_sbi(120) <= S_AXIS_FPGA2CPU_60_tdata(15 downto 0);
                r_sbi(121) <= S_AXIS_FPGA2CPU_60_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 61: 32-bit data using SBI_122 and SBI_123
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_61_tvalid = '1') then
                r_sbi(122) <= S_AXIS_FPGA2CPU_61_tdata(15 downto 0);
                r_sbi(123) <= S_AXIS_FPGA2CPU_61_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 62: 32-bit data using SBI_124 and SBI_125
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_62_tvalid = '1') then
                r_sbi(124) <= S_AXIS_FPGA2CPU_62_tdata(15 downto 0);
                r_sbi(125) <= S_AXIS_FPGA2CPU_62_tdata(31 downto 16);
            end if;
        
            -- FPGA2CPU 63: 32-bit data using SBI_126 and SBI_127
            if (r_S_AXIS_FPGA2CPU_tready = '1') and (S_AXIS_FPGA2CPU_63_tvalid = '1') then
                r_sbi(126) <= S_AXIS_FPGA2CPU_63_tdata(15 downto 0);
                r_sbi(127) <= S_AXIS_FPGA2CPU_63_tdata(31 downto 16);
            end if;
        
        end if;

	end process P_FPGA2CPU_AXIS;

end impl;
