library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity ixip is
  generic(
	SB_GT_SFP_0 : boolean := false;
	SB_GT_SFP_1 : boolean := false;
	SB_GT_SFP_2 : boolean := false;
	Remove_CB_PWM_0_to_7 : boolean := true;
	Remove_CB_PWM_8_to_15 : boolean := true;
	Remove_CB_PWM_16_to_23 : boolean := true;
	Remove_CB_PWM_24_to_31 : boolean := true;
	Remove_PP_PWM : boolean := true;
	Remove_SS_PWM : boolean := true);
  Port ( 
	clk_50_mhz : out STD_LOGIC;
	clk_250_mhz : out STD_LOGIC;
	ADC_reg_00 : out STD_LOGIC_VECTOR ( 15 downto 0 );
	ADC_reg_01 : out STD_LOGIC_VECTOR ( 15 downto 0 );
	ADC_reg_02 : out STD_LOGIC_VECTOR ( 15 downto 0 );
	ADC_reg_03 : out STD_LOGIC_VECTOR ( 15 downto 0 );
	ADC_reg_04 : out STD_LOGIC_VECTOR ( 15 downto 0 );
	ADC_reg_05 : out STD_LOGIC_VECTOR ( 15 downto 0 );
	ADC_reg_06 : out STD_LOGIC_VECTOR ( 15 downto 0 );
	ADC_reg_07 : out STD_LOGIC_VECTOR ( 15 downto 0 );
	ADC_reg_08 : out STD_LOGIC_VECTOR ( 15 downto 0 );
	ADC_reg_09 : out STD_LOGIC_VECTOR ( 15 downto 0 );
	ADC_reg_10 : out STD_LOGIC_VECTOR ( 15 downto 0 );
	ADC_reg_11 : out STD_LOGIC_VECTOR ( 15 downto 0 );
	ADC_reg_12 : out STD_LOGIC_VECTOR ( 15 downto 0 );
	ADC_reg_13 : out STD_LOGIC_VECTOR ( 15 downto 0 );
	ADC_reg_14 : out STD_LOGIC_VECTOR ( 15 downto 0 );
	ADC_reg_15 : out STD_LOGIC_VECTOR ( 15 downto 0 );
	data_valid_pulse : out STD_LOGIC;
	sync_pulse : out STD_LOGIC;
	pwm : out STD_LOGIC_VECTOR ( 31 downto 0 );
	gpo : out STD_LOGIC_VECTOR ( 15 downto 0 );
	oversampling_pulse : out STD_LOGIC;
	BBOX_tri_o : out STD_LOGIC_VECTOR ( 51 downto 0 );
	BBOX_tri_t : out STD_LOGIC_VECTOR ( 51 downto 0 );
	cpu_core_state : out STD_LOGIC_VECTOR ( 1 downto 0 );
	fault : out STD_LOGIC;
	rxn_0 : out STD_LOGIC;
	rxp_0 : out STD_LOGIC;
	rxn_1 : out STD_LOGIC;
	rxp_1 : out STD_LOGIC;
	rxn_2 : out STD_LOGIC;
	rxp_2 : out STD_LOGIC;
	private_out : out STD_LOGIC_VECTOR ( 35 downto 0 );
	adc_done_cpu_pulse : out STD_LOGIC;
	adc_done_pulse : out STD_LOGIC;
	sampling_pulse : out STD_LOGIC;
	GT_gt0_qplllock : out STD_LOGIC;
	GT_gt0_qpllrefclklost : out STD_LOGIC;
	GT_gt_qpllclk_quad1 : out STD_LOGIC;
	GT_gt_qpllrefclk_quad1 : out STD_LOGIC;
	GT_gt_refclk1 : out STD_LOGIC;
	USR_tri_o : out STD_LOGIC_VECTOR ( 35 downto 0 );
	USR_tri_t : out STD_LOGIC_VECTOR ( 35 downto 0 );
	CLOCK_0_clk_en : out STD_LOGIC;
	CLOCK_0_period : out STD_LOGIC_VECTOR ( 15 downto 0 );
	CLOCK_0_prescaler : out STD_LOGIC_VECTOR ( 15 downto 0 );
	CLOCK_0_timer : out STD_LOGIC_VECTOR ( 15 downto 0 );
	CLOCK_1_clk_en : out STD_LOGIC;
	CLOCK_1_period : out STD_LOGIC_VECTOR ( 15 downto 0 );
	CLOCK_1_prescaler : out STD_LOGIC_VECTOR ( 15 downto 0 );
	CLOCK_1_timer : out STD_LOGIC_VECTOR ( 15 downto 0 );
	CLOCK_2_clk_en : out STD_LOGIC;
	CLOCK_2_period : out STD_LOGIC_VECTOR ( 15 downto 0 );
	CLOCK_2_prescaler : out STD_LOGIC_VECTOR ( 15 downto 0 );
	CLOCK_2_timer : out STD_LOGIC_VECTOR ( 15 downto 0 );
	CLOCK_3_clk_en : out STD_LOGIC;
	CLOCK_3_period : out STD_LOGIC_VECTOR ( 15 downto 0 );
	CLOCK_3_prescaler : out STD_LOGIC_VECTOR ( 15 downto 0 );
	CLOCK_3_timer : out STD_LOGIC_VECTOR ( 15 downto 0 );
	reading : out STD_LOGIC;
	SBIO_BUS_sb_addr : out STD_LOGIC_VECTOR ( 9 downto 0 );
	SBIO_BUS_sb_we : out STD_LOGIC;
	SBIO_BUS_sb_wdata : out STD_LOGIC_VECTOR ( 15 downto 0 );
	FIXED_IO_mio : inout STD_LOGIC_VECTOR ( 53 downto 0 );
	DDR_cas_n : inout STD_LOGIC;
	DDR_cke : inout STD_LOGIC;
	DDR_ck_n : inout STD_LOGIC;
	DDR_ck_p : inout STD_LOGIC;
	DDR_cs_n : inout STD_LOGIC;
	DDR_reset_n : inout STD_LOGIC;
	DDR_odt : inout STD_LOGIC;
	DDR_ras_n : inout STD_LOGIC;
	DDR_we_n : inout STD_LOGIC;
	DDR_ba : inout STD_LOGIC_VECTOR ( 2 downto 0 );
	DDR_addr : inout STD_LOGIC_VECTOR ( 14 downto 0 );
	FIXED_IO_ddr_vrn : inout STD_LOGIC;
	FIXED_IO_ddr_vrp : inout STD_LOGIC;
	DDR_dm : inout STD_LOGIC_VECTOR ( 3 downto 0 );
	DDR_dq : inout STD_LOGIC_VECTOR ( 31 downto 0 );
	DDR_dqs_n : inout STD_LOGIC_VECTOR ( 3 downto 0 );
	DDR_dqs_p : inout STD_LOGIC_VECTOR ( 3 downto 0 );
	FIXED_IO_ps_srstb : inout STD_LOGIC;
	FIXED_IO_ps_clk : inout STD_LOGIC;
	FIXED_IO_ps_porb : inout STD_LOGIC;
	flt : in STD_LOGIC_VECTOR ( 15 downto 0 );
	gpi : in STD_LOGIC_VECTOR ( 15 downto 0 );
	BBOX_tri_i : in STD_LOGIC_VECTOR ( 51 downto 0 );
	private_in : in STD_LOGIC_VECTOR ( 30 downto 0 );
	txn_0 : in STD_LOGIC;
	txp_0 : in STD_LOGIC;
	txn_1 : in STD_LOGIC;
	txp_1 : in STD_LOGIC;
	txn_2 : in STD_LOGIC;
	txp_2 : in STD_LOGIC;
	USR_tri_i : in STD_LOGIC_VECTOR ( 35 downto 0 );
	sb_pwm : in STD_LOGIC_VECTOR ( 31 downto 0 );
	user_fw_id : in STD_LOGIC_VECTOR ( 15 downto 0 );
	SBIO_BUS_sb_rdata : in STD_LOGIC_VECTOR ( 15 downto 0 )
  );

end ixip;

architecture stub of ixip is

	attribute X_INTERFACE_INFO : string;
	attribute X_INTERFACE_INFO of DDR_cas_n : signal is "xilinx.com:interface:ddrx:1.0 DDR CAS_N";
	attribute X_INTERFACE_INFO of DDR_ck_n : signal is "xilinx.com:interface:ddrx:1.0 DDR CK_N";
	attribute X_INTERFACE_INFO of DDR_ck_p : signal is "xilinx.com:interface:ddrx:1.0 DDR CK_P";
	attribute X_INTERFACE_INFO of DDR_cke : signal is "xilinx.com:interface:ddrx:1.0 DDR CKE";
	attribute X_INTERFACE_INFO of DDR_cs_n : signal is "xilinx.com:interface:ddrx:1.0 DDR CS_N";
	attribute X_INTERFACE_INFO of DDR_odt : signal is "xilinx.com:interface:ddrx:1.0 DDR ODT";
	attribute X_INTERFACE_INFO of DDR_ras_n : signal is "xilinx.com:interface:ddrx:1.0 DDR RAS_N";
	attribute X_INTERFACE_INFO of DDR_reset_n : signal is "xilinx.com:interface:ddrx:1.0 DDR RESET_N";
	attribute X_INTERFACE_INFO of DDR_we_n : signal is "xilinx.com:interface:ddrx:1.0 DDR WE_N";
	attribute X_INTERFACE_INFO of FIXED_IO_ddr_vrn : signal is "xilinx.com:display_processing_system7:fixedio:1.0 FIXED_IO DDR_VRN";
	attribute X_INTERFACE_PARAMETER : string;
	attribute X_INTERFACE_PARAMETER of FIXED_IO_ddr_vrn : signal is "XIL_INTERFACENAME FIXED_IO, CAN_DEBUG false";
	attribute X_INTERFACE_INFO of FIXED_IO_ddr_vrp : signal is "xilinx.com:display_processing_system7:fixedio:1.0 FIXED_IO DDR_VRP";
	attribute X_INTERFACE_INFO of FIXED_IO_ps_clk : signal is "xilinx.com:display_processing_system7:fixedio:1.0 FIXED_IO PS_CLK";
	attribute X_INTERFACE_INFO of FIXED_IO_ps_porb : signal is "xilinx.com:display_processing_system7:fixedio:1.0 FIXED_IO PS_PORB";
	attribute X_INTERFACE_INFO of FIXED_IO_ps_srstb : signal is "xilinx.com:display_processing_system7:fixedio:1.0 FIXED_IO PS_SRSTB";
	attribute X_INTERFACE_INFO of DDR_addr : signal is "xilinx.com:interface:ddrx:1.0 DDR ADDR";
	attribute X_INTERFACE_PARAMETER of DDR_addr : signal is "XIL_INTERFACENAME DDR, AXI_ARBITRATION_SCHEME TDM, BURST_LENGTH 8, CAN_DEBUG false, CAS_LATENCY 11, CAS_WRITE_LATENCY 11, CS_ENABLED true, DATA_MASK_ENABLED true, DATA_WIDTH 8, MEMORY_TYPE COMPONENTS, MEM_ADDR_MAP ROW_COLUMN_BANK, SLOT Single, TIMEPERIOD_PS 1250";
	attribute X_INTERFACE_INFO of DDR_ba : signal is "xilinx.com:interface:ddrx:1.0 DDR BA";
	attribute X_INTERFACE_INFO of DDR_dm : signal is "xilinx.com:interface:ddrx:1.0 DDR DM";
	attribute X_INTERFACE_INFO of DDR_dq : signal is "xilinx.com:interface:ddrx:1.0 DDR DQ";
	attribute X_INTERFACE_INFO of DDR_dqs_n : signal is "xilinx.com:interface:ddrx:1.0 DDR DQS_N";
	attribute X_INTERFACE_INFO of DDR_dqs_p : signal is "xilinx.com:interface:ddrx:1.0 DDR DQS_P";
	attribute X_INTERFACE_INFO of FIXED_IO_mio : signal is "xilinx.com:display_processing_system7:fixedio:1.0 FIXED_IO MIO";
	attribute X_INTERFACE_INFO of USR_tri_i : signal is "xilinx.com:interface:gpio:1.0 USR TRI_I";
	attribute X_INTERFACE_INFO of USR_tri_o : signal is "xilinx.com:interface:gpio:1.0 USR TRI_O";
	attribute X_INTERFACE_INFO of USR_tri_t : signal is "xilinx.com:interface:gpio:1.0 USR TRI_T";
	
	component ip_imp_OWDWE0 is
	Port ( 
		clk_50_mhz : out STD_LOGIC;
		clk_250_mhz : out STD_LOGIC;
		ADC_reg_00 : out STD_LOGIC_VECTOR ( 15 downto 0 );
		ADC_reg_01 : out STD_LOGIC_VECTOR ( 15 downto 0 );
		ADC_reg_02 : out STD_LOGIC_VECTOR ( 15 downto 0 );
		ADC_reg_03 : out STD_LOGIC_VECTOR ( 15 downto 0 );
		ADC_reg_04 : out STD_LOGIC_VECTOR ( 15 downto 0 );
		ADC_reg_05 : out STD_LOGIC_VECTOR ( 15 downto 0 );
		ADC_reg_06 : out STD_LOGIC_VECTOR ( 15 downto 0 );
		ADC_reg_07 : out STD_LOGIC_VECTOR ( 15 downto 0 );
		ADC_reg_08 : out STD_LOGIC_VECTOR ( 15 downto 0 );
		ADC_reg_09 : out STD_LOGIC_VECTOR ( 15 downto 0 );
		ADC_reg_10 : out STD_LOGIC_VECTOR ( 15 downto 0 );
		ADC_reg_11 : out STD_LOGIC_VECTOR ( 15 downto 0 );
		ADC_reg_12 : out STD_LOGIC_VECTOR ( 15 downto 0 );
		ADC_reg_13 : out STD_LOGIC_VECTOR ( 15 downto 0 );
		ADC_reg_14 : out STD_LOGIC_VECTOR ( 15 downto 0 );
		ADC_reg_15 : out STD_LOGIC_VECTOR ( 15 downto 0 );
		data_valid_pulse : out STD_LOGIC;
		sync_pulse : out STD_LOGIC;
		pwm : out STD_LOGIC_VECTOR ( 31 downto 0 );
		gpo : out STD_LOGIC_VECTOR ( 15 downto 0 );
		oversampling_pulse : out STD_LOGIC;
		BBOX_tri_o : out STD_LOGIC_VECTOR ( 51 downto 0 );
		BBOX_tri_t : out STD_LOGIC_VECTOR ( 51 downto 0 );
		cpu_core_state : out STD_LOGIC_VECTOR ( 1 downto 0 );
		fault : out STD_LOGIC;
		private_out : out STD_LOGIC_VECTOR ( 35 downto 0 );
		adc_done_cpu_pulse : out STD_LOGIC;
		adc_done_pulse : out STD_LOGIC;
		sampling_pulse : out STD_LOGIC;
		GT_gt0_qplllock : out STD_LOGIC;
		GT_gt0_qpllrefclklost : out STD_LOGIC;
		GT_gt_qpllclk_quad1 : out STD_LOGIC;
		GT_gt_qpllrefclk_quad1 : out STD_LOGIC;
		GT_gt_refclk1 : out STD_LOGIC;
		USR_tri_o : out STD_LOGIC_VECTOR ( 35 downto 0 );
		USR_tri_t : out STD_LOGIC_VECTOR ( 35 downto 0 );
		CLOCK_0_clk_en : out STD_LOGIC;
		CLOCK_0_period : out STD_LOGIC_VECTOR ( 15 downto 0 );
		CLOCK_0_prescaler : out STD_LOGIC_VECTOR ( 15 downto 0 );
		CLOCK_0_timer : out STD_LOGIC_VECTOR ( 15 downto 0 );
		CLOCK_1_clk_en : out STD_LOGIC;
		CLOCK_1_period : out STD_LOGIC_VECTOR ( 15 downto 0 );
		CLOCK_1_prescaler : out STD_LOGIC_VECTOR ( 15 downto 0 );
		CLOCK_1_timer : out STD_LOGIC_VECTOR ( 15 downto 0 );
		CLOCK_2_clk_en : out STD_LOGIC;
		CLOCK_2_period : out STD_LOGIC_VECTOR ( 15 downto 0 );
		CLOCK_2_prescaler : out STD_LOGIC_VECTOR ( 15 downto 0 );
		CLOCK_2_timer : out STD_LOGIC_VECTOR ( 15 downto 0 );
		CLOCK_3_clk_en : out STD_LOGIC;
		CLOCK_3_period : out STD_LOGIC_VECTOR ( 15 downto 0 );
		CLOCK_3_prescaler : out STD_LOGIC_VECTOR ( 15 downto 0 );
		CLOCK_3_timer : out STD_LOGIC_VECTOR ( 15 downto 0 );
		reading : out STD_LOGIC;
		SBIO_BUS_sb_addr : out STD_LOGIC_VECTOR ( 9 downto 0 );
		SBIO_BUS_sb_we : out STD_LOGIC;
		SBIO_BUS_sb_wdata : out STD_LOGIC_VECTOR ( 15 downto 0 );
		FIXED_IO_mio : inout STD_LOGIC_VECTOR ( 53 downto 0 );
		DDR_cas_n : inout STD_LOGIC;
		DDR_cke : inout STD_LOGIC;
		DDR_ck_n : inout STD_LOGIC;
		DDR_ck_p : inout STD_LOGIC;
		DDR_cs_n : inout STD_LOGIC;
		DDR_reset_n : inout STD_LOGIC;
		DDR_odt : inout STD_LOGIC;
		DDR_ras_n : inout STD_LOGIC;
		DDR_we_n : inout STD_LOGIC;
		DDR_ba : inout STD_LOGIC_VECTOR ( 2 downto 0 );
		DDR_addr : inout STD_LOGIC_VECTOR ( 14 downto 0 );
		FIXED_IO_ddr_vrn : inout STD_LOGIC;
		FIXED_IO_ddr_vrp : inout STD_LOGIC;
		DDR_dm : inout STD_LOGIC_VECTOR ( 3 downto 0 );
		DDR_dq : inout STD_LOGIC_VECTOR ( 31 downto 0 );
		DDR_dqs_n : inout STD_LOGIC_VECTOR ( 3 downto 0 );
		DDR_dqs_p : inout STD_LOGIC_VECTOR ( 3 downto 0 );
		FIXED_IO_ps_srstb : inout STD_LOGIC;
		FIXED_IO_ps_clk : inout STD_LOGIC;
		FIXED_IO_ps_porb : inout STD_LOGIC;
		flt : in STD_LOGIC_VECTOR ( 15 downto 0 );
		gpi : in STD_LOGIC_VECTOR ( 15 downto 0 );
		BBOX_tri_i : in STD_LOGIC_VECTOR ( 51 downto 0 );
		private_in : in STD_LOGIC_VECTOR ( 30 downto 0 );
		inst_aurora : in STD_LOGIC_VECTOR ( 2 downto 0 );
		USR_tri_i : in STD_LOGIC_VECTOR ( 35 downto 0 );
		sb_pwm : in STD_LOGIC_VECTOR ( 31 downto 0 );
		inst_cb_pwm : in STD_LOGIC_VECTOR ( 31 downto 0 );
		inst_pp_pwm : in STD_LOGIC;
		inst_ss_pwm : in STD_LOGIC;
		user_fw_id : in STD_LOGIC_VECTOR ( 15 downto 0 );
		SBIO_BUS_sb_rdata : in STD_LOGIC_VECTOR ( 15 downto 0 )
	);
	end component ip_imp_OWDWE0;

	signal inst_aurora : std_logic_vector(2 downto 0);
	signal inst_cb_pwm : std_logic_vector(31 downto 0);
	signal inst_ss_pwm : std_logic;
	signal inst_pp_pwm : std_logic;
	
	signal i_private_in : std_logic_vector(30 downto 0);
	signal i_private_out : std_logic_vector(35 downto 0);
	
	signal RealSync_SFP_0 : boolean;
	signal RealSync_SFP_1 : boolean;
	signal RealSync_SFP_2 : boolean;

begin

	RealSync_SFP_0 <= not SB_GT_SFP_0;
	RealSync_SFP_1 <= not SB_GT_SFP_1;
	RealSync_SFP_2 <= not SB_GT_SFP_2;

	inst_aurora(0) <= '1' when RealSync_SFP_0 else '0';
	inst_aurora(1) <= '1' when RealSync_SFP_1 else '0';
	inst_aurora(2) <= '1' when RealSync_SFP_2 else '0';
	
	i_private_in(22 downto 0) <= private_in(22 downto 0);
	
	i_private_in(23) <= private_in(23) when RealSync_SFP_0 else '0';
	i_private_in(24) <= private_in(24) when RealSync_SFP_0 else '0';
	i_private_in(25) <= private_in(25) when RealSync_SFP_1 else '0';
	i_private_in(26) <= private_in(26) when RealSync_SFP_1 else '0';
	i_private_in(27) <= private_in(27) when RealSync_SFP_2 else '0';
	i_private_in(28) <= private_in(28) when RealSync_SFP_2 else '0';
	
	rxp_0 <= '0' when RealSync_SFP_0 else private_in(23); -- T4, RX0_P
	rxn_0 <= '0' when RealSync_SFP_0 else private_in(24); -- T3, RX0_N
	rxp_1 <= '0' when RealSync_SFP_1 else private_in(25); -- V4, RX1_P
	rxn_1 <= '0' when RealSync_SFP_1 else private_in(26); -- V3, RX1_N
	rxp_2 <= '0' when RealSync_SFP_2 else private_in(27); -- Y4, RX2_P
	rxn_2 <= '0' when RealSync_SFP_2 else private_in(28); -- Y3, RX2_N
	
	i_private_in(30 downto 29) <= private_in(30 downto 29); -- GT3, unused
	
	private_out(27 downto 0) <= i_private_out(27 downto 0);
	
	private_out(28) <= i_private_out(28) when RealSync_SFP_0 else txp_0; -- R2, TX0_P
	private_out(29) <= i_private_out(29) when RealSync_SFP_0 else txn_0; -- R1, TX0_N
	private_out(30) <= i_private_out(30) when RealSync_SFP_1 else txp_1; -- U2, TX1_P
	private_out(31) <= i_private_out(31) when RealSync_SFP_1 else txn_1; -- U1, TX1_N
	private_out(32) <= i_private_out(32) when RealSync_SFP_2 else txp_2; -- W2, TX2_P
	private_out(33) <= i_private_out(33) when RealSync_SFP_2 else txn_2; -- W1, TX2_N

	private_out(35 downto 34) <= i_private_out(35 downto 34); -- GT3, unused

	inst_cb_pwm(0) <= '1' when not Remove_CB_PWM_0_to_7 else '0';
	inst_cb_pwm(1) <= '1' when not Remove_CB_PWM_0_to_7 else '0';
	inst_cb_pwm(2) <= '1' when not Remove_CB_PWM_0_to_7 else '0';
	inst_cb_pwm(3) <= '1' when not Remove_CB_PWM_0_to_7 else '0';
	inst_cb_pwm(4) <= '1' when not Remove_CB_PWM_0_to_7 else '0';
	inst_cb_pwm(5) <= '1' when not Remove_CB_PWM_0_to_7 else '0';
	inst_cb_pwm(6) <= '1' when not Remove_CB_PWM_0_to_7 else '0';
	inst_cb_pwm(7) <= '1' when not Remove_CB_PWM_0_to_7 else '0';
	inst_cb_pwm(8) <= '1' when not Remove_CB_PWM_8_to_15 else '0';
	inst_cb_pwm(9) <= '1' when not Remove_CB_PWM_8_to_15 else '0';
	inst_cb_pwm(10) <= '1' when not Remove_CB_PWM_8_to_15 else '0';
	inst_cb_pwm(11) <= '1' when not Remove_CB_PWM_8_to_15 else '0';
	inst_cb_pwm(12) <= '1' when not Remove_CB_PWM_8_to_15 else '0';
	inst_cb_pwm(13) <= '1' when not Remove_CB_PWM_8_to_15 else '0';
	inst_cb_pwm(14) <= '1' when not Remove_CB_PWM_8_to_15 else '0';
	inst_cb_pwm(15) <= '1' when not Remove_CB_PWM_8_to_15 else '0';
	inst_cb_pwm(16) <= '1' when not Remove_CB_PWM_16_to_23 else '0';
	inst_cb_pwm(17) <= '1' when not Remove_CB_PWM_16_to_23 else '0';
	inst_cb_pwm(18) <= '1' when not Remove_CB_PWM_16_to_23 else '0';
	inst_cb_pwm(19) <= '1' when not Remove_CB_PWM_16_to_23 else '0';
	inst_cb_pwm(20) <= '1' when not Remove_CB_PWM_16_to_23 else '0';
	inst_cb_pwm(21) <= '1' when not Remove_CB_PWM_16_to_23 else '0';
	inst_cb_pwm(22) <= '1' when not Remove_CB_PWM_16_to_23 else '0';
	inst_cb_pwm(23) <= '1' when not Remove_CB_PWM_16_to_23 else '0';
	inst_cb_pwm(24) <= '1' when not Remove_CB_PWM_24_to_31 else '0';
	inst_cb_pwm(25) <= '1' when not Remove_CB_PWM_24_to_31 else '0';
	inst_cb_pwm(26) <= '1' when not Remove_CB_PWM_24_to_31 else '0';
	inst_cb_pwm(27) <= '1' when not Remove_CB_PWM_24_to_31 else '0';
	inst_cb_pwm(28) <= '1' when not Remove_CB_PWM_24_to_31 else '0';
	inst_cb_pwm(29) <= '1' when not Remove_CB_PWM_24_to_31 else '0';
	inst_cb_pwm(30) <= '1' when not Remove_CB_PWM_24_to_31 else '0';
	inst_cb_pwm(31) <= '1' when not Remove_CB_PWM_24_to_31 else '0';
	
	inst_ss_pwm <= '1' when not Remove_SS_PWM else '0';
	inst_pp_pwm <= '1' when not Remove_PP_PWM else '0';

	ip_inst : ip_imp_OWDWE0
	port map(
		clk_50_mhz => clk_50_mhz,
		clk_250_mhz => clk_250_mhz,
		ADC_reg_00 => ADC_reg_00,
		ADC_reg_01 => ADC_reg_01,
		ADC_reg_02 => ADC_reg_02,
		ADC_reg_03 => ADC_reg_03,
		ADC_reg_04 => ADC_reg_04,
		ADC_reg_05 => ADC_reg_05,
		ADC_reg_06 => ADC_reg_06,
		ADC_reg_07 => ADC_reg_07,
		ADC_reg_08 => ADC_reg_08,
		ADC_reg_09 => ADC_reg_09,
		ADC_reg_10 => ADC_reg_10,
		ADC_reg_11 => ADC_reg_11,
		ADC_reg_12 => ADC_reg_12,
		ADC_reg_13 => ADC_reg_13,
		ADC_reg_14 => ADC_reg_14,
		ADC_reg_15 => ADC_reg_15,
		data_valid_pulse => data_valid_pulse,
		sync_pulse => sync_pulse,
		pwm => pwm,
		gpo => gpo,
		oversampling_pulse => oversampling_pulse,
		BBOX_tri_o => BBOX_tri_o,
		BBOX_tri_t => BBOX_tri_t,
		cpu_core_state => cpu_core_state,
		fault => fault,
		private_out => i_private_out,
		adc_done_cpu_pulse => adc_done_cpu_pulse,
		adc_done_pulse => adc_done_pulse,
		sampling_pulse => sampling_pulse,
		GT_gt0_qplllock => GT_gt0_qplllock,
		GT_gt0_qpllrefclklost => GT_gt0_qpllrefclklost,
		GT_gt_qpllclk_quad1 => GT_gt_qpllclk_quad1,
		GT_gt_qpllrefclk_quad1 => GT_gt_qpllrefclk_quad1,
		GT_gt_refclk1 => GT_gt_refclk1,
		USR_tri_o => USR_tri_o,
		USR_tri_t => USR_tri_t,
		CLOCK_0_clk_en => CLOCK_0_clk_en,
		CLOCK_0_period => CLOCK_0_period,
		CLOCK_0_prescaler => CLOCK_0_prescaler,
		CLOCK_0_timer => CLOCK_0_timer,
		CLOCK_1_clk_en => CLOCK_1_clk_en,
		CLOCK_1_period => CLOCK_1_period,
		CLOCK_1_prescaler => CLOCK_1_prescaler,
		CLOCK_1_timer => CLOCK_1_timer,
		CLOCK_2_clk_en => CLOCK_2_clk_en,
		CLOCK_2_period => CLOCK_2_period,
		CLOCK_2_prescaler => CLOCK_2_prescaler,
		CLOCK_2_timer => CLOCK_2_timer,
		CLOCK_3_clk_en => CLOCK_3_clk_en,
		CLOCK_3_period => CLOCK_3_period,
		CLOCK_3_prescaler => CLOCK_3_prescaler,
		CLOCK_3_timer => CLOCK_3_timer,
		reading => reading,
		SBIO_BUS_sb_addr => SBIO_BUS_sb_addr,
		SBIO_BUS_sb_we => SBIO_BUS_sb_we,
		SBIO_BUS_sb_wdata => SBIO_BUS_sb_wdata,
		FIXED_IO_mio => FIXED_IO_mio,
		DDR_cas_n => DDR_cas_n,
		DDR_cke => DDR_cke,
		DDR_ck_n => DDR_ck_n,
		DDR_ck_p => DDR_ck_p,
		DDR_cs_n => DDR_cs_n,
		DDR_reset_n => DDR_reset_n,
		DDR_odt => DDR_odt,
		DDR_ras_n => DDR_ras_n,
		DDR_we_n => DDR_we_n,
		DDR_ba => DDR_ba,
		DDR_addr => DDR_addr,
		FIXED_IO_ddr_vrn => FIXED_IO_ddr_vrn,
		FIXED_IO_ddr_vrp => FIXED_IO_ddr_vrp,
		DDR_dm => DDR_dm,
		DDR_dq => DDR_dq,
		DDR_dqs_n => DDR_dqs_n,
		DDR_dqs_p => DDR_dqs_p,
		FIXED_IO_ps_srstb => FIXED_IO_ps_srstb,
		FIXED_IO_ps_clk => FIXED_IO_ps_clk,
		FIXED_IO_ps_porb => FIXED_IO_ps_porb,
		flt => flt,
		gpi => gpi,
		BBOX_tri_i => BBOX_tri_i,
		private_in => i_private_in,
		inst_aurora => inst_aurora,
		USR_tri_i => USR_tri_i,
		sb_pwm => sb_pwm,
		inst_cb_pwm => inst_cb_pwm,
		inst_pp_pwm => inst_pp_pwm,
		inst_ss_pwm => inst_ss_pwm,
		user_fw_id => user_fw_id,
		SBIO_BUS_sb_rdata => SBIO_BUS_sb_rdata);

end;
