
if { $argc != 1 } {
	puts "The script requires the project name to be set as an argument."	
} else {

	start_gui
	
	set proj_name [lindex $argv 0]
	set script_path [ file dirname [ file normalize [ info script ] ] ]
	set vivado_dir_path ../vivado
	set ip_repo_dir_path ../ix_repo
	set hdl_dir_path ../hdl
	set constraint_dir_path ../constraints

	create_project $proj_name $vivado_dir_path/$proj_name -part xc7z030fbg676-3

	set_property target_language VHDL [current_project]
	
	# Work-around suggested by Xilinx to avoid the following inconsequential critical warning
	# [Memdata 28-165] The reference name: top_i_ip_m_blk_mem_gen_0 was not found in a previous reference definition. Either the bmm file or the bmm_info_* properties are malformed, therefore BRAM INIT strings can not be populated.
	# Source: https://support.xilinx.com/s/article/59639?language=en_US
	set_param memdata.disableAnnotatedBMM 1
	set_param memdata.disableBRAMInitStrings 1
	set_param memdata.ignoreEmbeddedBMMProperties 1

	set_property  ip_repo_paths  $ip_repo_dir_path [current_project]
	update_ip_catalog
	create_bd_design "top"
	create_bd_cell -type ip -vlnv imperix.ch:ix:IXIP:3.10 IXIP_0
	set_property name IXIP [get_bd_cells IXIP_0]

	add_files -fileset constrs_1 -norecurse $constraint_dir_path/sandbox_pins_3.10rev1.xdc

	make_bd_intf_pins_external  [get_bd_intf_pins IXIP/FIXED_IO]
	make_bd_intf_pins_external  [get_bd_intf_pins IXIP/DDR]
	make_bd_intf_pins_external  [get_bd_intf_pins IXIP/BBOX]
	make_bd_intf_pins_external  [get_bd_intf_pins IXIP/USR]

	set_property name FIXED_IO [get_bd_intf_ports FIXED_IO_0]
	set_property name DDR [get_bd_intf_ports DDR_0]
	set_property name BBOX [get_bd_intf_ports BBOX_0]
	set_property name USR [get_bd_intf_ports USR_0]

	make_bd_pins_external  [get_bd_pins IXIP/private_out]
	make_bd_pins_external  [get_bd_pins IXIP/pwm]
	make_bd_pins_external  [get_bd_pins IXIP/gpo]
	make_bd_pins_external  [get_bd_pins IXIP/private_in]
	make_bd_pins_external  [get_bd_pins IXIP/flt]
	make_bd_pins_external  [get_bd_pins IXIP/gpi]

	set_property name private_out [get_bd_ports private_out_0]
	set_property name pwm [get_bd_ports pwm_0]
	set_property name gpo [get_bd_ports gpo_0]
	set_property name private_in [get_bd_ports private_in_0]
	set_property name flt [get_bd_ports flt_0]
	set_property name gpi [get_bd_ports gpi_0]

	create_bd_cell -type ip -vlnv xilinx.com:ip:xlconstant:1.1 xlconstant_0
	set_property name USER_ID [get_bd_cells xlconstant_0]
	set_property -dict [list CONFIG.CONST_WIDTH {16}] [get_bd_cells USER_ID]
	set_property -dict [list CONFIG.CONST_VAL {1}] [get_bd_cells USER_ID]
	connect_bd_net [get_bd_pins USER_ID/dout] [get_bd_pins IXIP/user_fw_id]

	make_wrapper -files [get_files $vivado_dir_path/$proj_name/$proj_name.srcs/sources_1/bd/top/top.bd] -top
	import_files -force -norecurse $vivado_dir_path/$proj_name/$proj_name.gen/sources_1/bd/top/hdl/top_wrapper.vhd

	add_files -norecurse $hdl_dir_path/AXIS_interface.vhd
	create_bd_cell -type module -reference ix_axis_interface ix_axis_interface_0
	set_property name ix_axis_interface [get_bd_cells ix_axis_interface_0]
	connect_bd_intf_net [get_bd_intf_pins IXIP/SBIO_BUS] [get_bd_intf_pins ix_axis_interface/SBIO_BUS]
	connect_bd_intf_net [get_bd_intf_pins IXIP/ADC] [get_bd_intf_pins ix_axis_interface/ADC]
	connect_bd_net [get_bd_pins IXIP/adc_done_pulse] [get_bd_pins ix_axis_interface/adc_done_pulse_in]
	connect_bd_net [get_bd_pins IXIP/data_valid_pulse] [get_bd_pins ix_axis_interface/data_valid_pulse_in]
	connect_bd_net [get_bd_pins IXIP/reading] [get_bd_pins ix_axis_interface/data_reading_in]
	connect_bd_net [get_bd_pins IXIP/clk_250_mhz] [get_bd_pins ix_axis_interface/clk]
	connect_bd_net [get_bd_pins IXIP/sync_pulse] [get_bd_pins ix_axis_interface/sync_pulse_in]

	regenerate_bd_layout
	
	save_bd_design
}